/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.cf;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.cf.code.ConcreteMethod;
import com.android.dx.cf.code.Ropper;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.iface.Field;
import com.android.dx.cf.iface.FieldList;
import com.android.dx.cf.iface.Method;
import com.android.dx.cf.iface.MethodList;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.AttributeTranslator;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CodeStatistics;
import com.android.dx.dex.cf.OptimizerOptions;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.code.RopTranslator;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedField;
import com.android.dx.dex.file.EncodedMethod;
import com.android.dx.dex.file.FieldIdsSection;
import com.android.dx.dex.file.MethodIdsSection;
import com.android.dx.dex.file.TypeIdsSection;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.code.DexTranslationAdvice;
import com.android.dx.rop.code.LocalVariableExtractor;
import com.android.dx.rop.code.LocalVariableInfo;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.code.TranslationAdvice;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.rop.cst.CstBaseMethodRef;
import com.android.dx.rop.cst.CstBoolean;
import com.android.dx.rop.cst.CstByte;
import com.android.dx.rop.cst.CstChar;
import com.android.dx.rop.cst.CstEnumRef;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstInterfaceMethodRef;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstShort;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.TypedConstant;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.dx.ssa.Optimizer;
import com.android.dx.util.FixedSizeList;

public class CfTranslator {
    private static final boolean DEBUG = false;

    private CfTranslator() {
    }

    public static ClassDefItem translate(DirectClassFile directClassFile, byte[] byArray, CfOptions cfOptions, DexOptions dexOptions, DexFile dexFile) {
        try {
            return CfTranslator.translate0(directClassFile, byArray, cfOptions, dexOptions, dexFile);
        }
        catch (RuntimeException runtimeException) {
            String string = "...while processing " + directClassFile.getFilePath();
            throw ExceptionWithContext.withContext(runtimeException, string);
        }
    }

    private static ClassDefItem translate0(DirectClassFile directClassFile, byte[] byArray, CfOptions cfOptions, DexOptions dexOptions, DexFile dexFile) {
        OptimizerOptions.loadOptimizeLists(cfOptions.optimizeListFile, cfOptions.dontOptimizeListFile);
        CstType cstType = directClassFile.getThisClass();
        int n = directClassFile.getAccessFlags() & 0xFFFFFFDF;
        CstString cstString = cfOptions.positionInfo == 1 ? null : directClassFile.getSourceFile();
        ClassDefItem classDefItem = new ClassDefItem(cstType, n, directClassFile.getSuperclass(), directClassFile.getInterfaces(), cstString);
        Annotations annotations = AttributeTranslator.getClassAnnotations(directClassFile, cfOptions);
        if (annotations.size() != 0) {
            classDefItem.setClassAnnotations(annotations);
        }
        FieldIdsSection fieldIdsSection = dexFile.getFieldIds();
        MethodIdsSection methodIdsSection = dexFile.getMethodIds();
        TypeIdsSection typeIdsSection = dexFile.getTypeIds();
        CfTranslator.processFields(directClassFile, classDefItem, fieldIdsSection);
        CfTranslator.processMethods(directClassFile, cfOptions, dexOptions, classDefItem, methodIdsSection);
        ConstantPool constantPool = directClassFile.getConstantPool();
        int n2 = constantPool.size();
        for (int i = 0; i < n2; ++i) {
            Constant constant = constantPool.getOrNull(i);
            if (constant instanceof CstMethodRef) {
                methodIdsSection.intern((CstBaseMethodRef)constant);
                continue;
            }
            if (constant instanceof CstInterfaceMethodRef) {
                methodIdsSection.intern(((CstInterfaceMethodRef)constant).toMethodRef());
                continue;
            }
            if (constant instanceof CstFieldRef) {
                fieldIdsSection.intern((CstFieldRef)constant);
                continue;
            }
            if (constant instanceof CstEnumRef) {
                fieldIdsSection.intern(((CstEnumRef)constant).getFieldRef());
                continue;
            }
            if (!(constant instanceof CstType)) continue;
            typeIdsSection.intern((CstType)constant);
        }
        return classDefItem;
    }

    private static void processFields(DirectClassFile directClassFile, ClassDefItem classDefItem, FieldIdsSection fieldIdsSection) {
        CstType cstType = directClassFile.getThisClass();
        FieldList fieldList = directClassFile.getFields();
        int n = fieldList.size();
        for (int i = 0; i < n; ++i) {
            Field field = fieldList.get(i);
            try {
                Comparable<Constant> comparable;
                CstFieldRef cstFieldRef = new CstFieldRef(cstType, field.getNat());
                int n2 = field.getAccessFlags();
                if (AccessFlags.isStatic(n2)) {
                    comparable = field.getConstantValue();
                    EncodedField encodedField = new EncodedField(cstFieldRef, n2);
                    if (comparable != null) {
                        comparable = CfTranslator.coerceConstant((TypedConstant)comparable, cstFieldRef.getType());
                    }
                    classDefItem.addStaticField(encodedField, (Constant)comparable);
                } else {
                    comparable = new EncodedField(cstFieldRef, n2);
                    classDefItem.addInstanceField((EncodedField)comparable);
                }
                comparable = AttributeTranslator.getAnnotations(field.getAttributes());
                if (((Annotations)comparable).size() != 0) {
                    classDefItem.addFieldAnnotations(cstFieldRef, (Annotations)comparable);
                }
                fieldIdsSection.intern(cstFieldRef);
                continue;
            }
            catch (RuntimeException runtimeException) {
                String string = "...while processing " + field.getName().toHuman() + " " + field.getDescriptor().toHuman();
                throw ExceptionWithContext.withContext(runtimeException, string);
            }
        }
    }

    private static TypedConstant coerceConstant(TypedConstant typedConstant, Type type) {
        Type type2 = typedConstant.getType();
        if (type2.equals(type)) {
            return typedConstant;
        }
        switch (type.getBasicType()) {
            case 1: {
                return CstBoolean.make(((CstInteger)typedConstant).getValue());
            }
            case 2: {
                return CstByte.make(((CstInteger)typedConstant).getValue());
            }
            case 3: {
                return CstChar.make(((CstInteger)typedConstant).getValue());
            }
            case 8: {
                return CstShort.make(((CstInteger)typedConstant).getValue());
            }
        }
        throw new UnsupportedOperationException("can't coerce " + typedConstant + " to " + type);
    }

    private static void processMethods(DirectClassFile directClassFile, CfOptions cfOptions, DexOptions dexOptions, ClassDefItem classDefItem, MethodIdsSection methodIdsSection) {
        CstType cstType = directClassFile.getThisClass();
        MethodList methodList = directClassFile.getMethods();
        int n = methodList.size();
        for (int i = 0; i < n; ++i) {
            Method method = methodList.get(i);
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                DalvCode dalvCode;
                boolean bl;
                CstMethodRef cstMethodRef = new CstMethodRef(cstType, method.getNat());
                int n2 = method.getAccessFlags();
                boolean bl2 = AccessFlags.isStatic(n2);
                boolean bl3 = AccessFlags.isPrivate(n2);
                boolean bl4 = AccessFlags.isNative(n2);
                boolean bl5 = AccessFlags.isAbstract(n2);
                boolean bl6 = bl = cstMethodRef.isInstanceInit() || cstMethodRef.isClassInit();
                if (bl4 || bl5) {
                    dalvCode = null;
                } else {
                    object4 = new ConcreteMethod(method, directClassFile, cfOptions.positionInfo != 1, cfOptions.localInfo);
                    object3 = DexTranslationAdvice.THE_ONE;
                    object2 = Ropper.convert((ConcreteMethod)object4, (TranslationAdvice)object3);
                    object = null;
                    int n3 = cstMethodRef.getParameterWordCount(bl2);
                    String string = cstType.getClassType().getDescriptor() + "." + method.getName().getString();
                    if (cfOptions.optimize && OptimizerOptions.shouldOptimize(string)) {
                        object = object2;
                        object2 = Optimizer.optimize((RopMethod)object2, n3, bl2, cfOptions.localInfo, (TranslationAdvice)object3);
                        if (cfOptions.statistics) {
                            CodeStatistics.updateRopStatistics((RopMethod)object, (RopMethod)object2);
                        }
                    }
                    LocalVariableInfo localVariableInfo = null;
                    if (cfOptions.localInfo) {
                        localVariableInfo = LocalVariableExtractor.extract((RopMethod)object2);
                    }
                    dalvCode = RopTranslator.translate((RopMethod)object2, cfOptions.positionInfo, localVariableInfo, n3, dexOptions);
                    if (cfOptions.statistics && object != null) {
                        CfTranslator.updateDexStatistics(cfOptions, dexOptions, (RopMethod)object2, (RopMethod)object, localVariableInfo, n3, ((ConcreteMethod)object4).getCode().size());
                    }
                }
                if (AccessFlags.isSynchronized(n2)) {
                    n2 |= 0x20000;
                    if (!bl4) {
                        n2 &= 0xFFFFFFDF;
                    }
                }
                if (bl) {
                    n2 |= 0x10000;
                }
                object4 = AttributeTranslator.getExceptions(method);
                object3 = new EncodedMethod(cstMethodRef, n2, dalvCode, (TypeList)object4);
                if (cstMethodRef.isInstanceInit() || cstMethodRef.isClassInit() || bl2 || bl3) {
                    classDefItem.addDirectMethod((EncodedMethod)object3);
                } else {
                    classDefItem.addVirtualMethod((EncodedMethod)object3);
                }
                object2 = AttributeTranslator.getMethodAnnotations(method);
                if (((Annotations)object2).size() != 0) {
                    classDefItem.addMethodAnnotations(cstMethodRef, (Annotations)object2);
                }
                if (((FixedSizeList)(object = AttributeTranslator.getParameterAnnotations(method))).size() != 0) {
                    classDefItem.addParameterAnnotations(cstMethodRef, (AnnotationsList)object);
                }
                methodIdsSection.intern(cstMethodRef);
                continue;
            }
            catch (RuntimeException runtimeException) {
                String string = "...while processing " + method.getName().toHuman() + " " + method.getDescriptor().toHuman();
                throw ExceptionWithContext.withContext(runtimeException, string);
            }
        }
    }

    private static void updateDexStatistics(CfOptions cfOptions, DexOptions dexOptions, RopMethod ropMethod, RopMethod ropMethod2, LocalVariableInfo localVariableInfo, int n, int n2) {
        DalvCode dalvCode = RopTranslator.translate(ropMethod, cfOptions.positionInfo, localVariableInfo, n, dexOptions);
        DalvCode dalvCode2 = RopTranslator.translate(ropMethod2, cfOptions.positionInfo, localVariableInfo, n, dexOptions);
        DalvCode.AssignIndicesCallback assignIndicesCallback = new DalvCode.AssignIndicesCallback(){

            public int getIndex(Constant constant) {
                return 0;
            }
        };
        dalvCode.assignIndices(assignIndicesCallback);
        dalvCode2.assignIndices(assignIndicesCallback);
        CodeStatistics.updateDexStatistics(dalvCode2, dalvCode);
        CodeStatistics.updateOriginalByteCount(n2);
    }
}

