/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.grep;

import com.android.dex.ClassData;
import com.android.dex.ClassDef;
import com.android.dex.Dex;
import com.android.dex.EncodedValueReader;
import com.android.dex.MethodId;
import com.android.dx.io.CodeReader;
import com.android.dx.io.instructions.DecodedInstruction;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Grep {
    private final Dex dex;
    private final CodeReader codeReader = new CodeReader();
    private final Set<Integer> stringIds;
    private final PrintWriter out;
    private int count = 0;
    private ClassDef currentClass;
    private ClassData.Method currentMethod;

    public Grep(Dex dex, Pattern pattern, PrintWriter printWriter) {
        this.dex = dex;
        this.out = printWriter;
        this.stringIds = this.getStringIds(dex, pattern);
        this.codeReader.setStringVisitor(new CodeReader.Visitor(){

            public void visit(DecodedInstruction[] decodedInstructionArray, DecodedInstruction decodedInstruction) {
                Grep.this.encounterString(decodedInstruction.getIndex());
            }
        });
    }

    private void readArray(EncodedValueReader encodedValueReader) {
        int n = encodedValueReader.readArray();
        block4: for (int i = 0; i < n; ++i) {
            switch (encodedValueReader.peek()) {
                case 23: {
                    this.encounterString(encodedValueReader.readString());
                    continue block4;
                }
                case 28: {
                    this.readArray(encodedValueReader);
                }
            }
        }
    }

    private void encounterString(int n) {
        if (this.stringIds.contains(n)) {
            this.out.println(this.location() + " " + this.dex.strings().get(n));
            ++this.count;
        }
    }

    private String location() {
        String string = this.dex.typeNames().get(this.currentClass.getTypeIndex());
        if (this.currentMethod != null) {
            MethodId methodId = this.dex.methodIds().get(this.currentMethod.getMethodIndex());
            return string + "." + this.dex.strings().get(methodId.getNameIndex());
        }
        return string;
    }

    public int grep() {
        Iterator<ClassDef> iterator = this.dex.classDefs().iterator();
        while (iterator.hasNext()) {
            ClassDef classDef;
            this.currentClass = classDef = iterator.next();
            this.currentMethod = null;
            if (classDef.getClassDataOffset() == 0) continue;
            ClassData classData = this.dex.readClassData(classDef);
            int n = classDef.getStaticValuesOffset();
            if (n != 0) {
                this.readArray(new EncodedValueReader(this.dex.open(n)));
            }
            ClassData.Method[] methodArray = classData.allMethods();
            int n2 = methodArray.length;
            for (int i = 0; i < n2; ++i) {
                ClassData.Method method;
                this.currentMethod = method = methodArray[i];
                if (method.getCodeOffset() == 0) continue;
                this.codeReader.visitAll(this.dex.readCode(method).getInstructions());
            }
        }
        this.currentClass = null;
        this.currentMethod = null;
        return this.count;
    }

    private Set<Integer> getStringIds(Dex dex, Pattern pattern) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = 0;
        for (String string : dex.strings()) {
            if (pattern.matcher(string).find()) {
                hashSet.add(n);
            }
            ++n;
        }
        return hashSet;
    }
}

