/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dexer;

import com.android.dex.Dex;
import com.android.dex.DexException;
import com.android.dex.util.FileUtils;
import com.android.dx.cf.code.SimException;
import com.android.dx.cf.direct.ClassPathOpener;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.command.DxConsole;
import com.android.dx.command.UsageException;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.cf.CodeStatistics;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedMethod;
import com.android.dx.merge.CollisionPolicy;
import com.android.dx.merge.DexMerger;
import com.android.dx.rop.annotation.Annotation;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final String DEX_EXTENSION = ".dex";
    private static final String DEX_PREFIX = "classes";
    private static final String IN_RE_CORE_CLASSES = "Ill-advised or mistaken usage of a core class (java.* or javax.*)\nwhen not building a core library.\n\nThis is often due to inadvertently including a core library file\nin your application's project, when using an IDE (such as\nEclipse). If you are sure you're not intentionally defining a\ncore class, then this is the most likely explanation of what's\ngoing on.\n\nHowever, you might actually be trying to define a class in a core\nnamespace, the source of which you may have taken, for example,\nfrom a non-Android virtual machine project. This will most\nassuredly not work. At a minimum, it jeopardizes the\ncompatibility of your app with future versions of the platform.\nIt is also often of questionable legality.\n\nIf you really intend to build a core library -- which is only\nappropriate as part of creating a full virtual machine\ndistribution, as opposed to compiling an application -- then use\nthe \"--core-library\" option to suppress this error message.\n\nIf you go ahead and use \"--core-library\" but are in fact\nbuilding an application, then be forewarned that your application\nwill still fail to build or run, at some point. Please be\nprepared for angry customers who find, for example, that your\napplication ceases to function once they upgrade their operating\nsystem. You will be to blame for this problem.\n\nIf you are legitimately using some code that happens to be in a\ncore package, then the easiest safe alternative you have is to\nrepackage that code. That is, move the classes in question into\nyour own package namespace. This means that they will never be in\nconflict with core system classes. JarJar is a tool that may help\nyou in this endeavor. If you find that you cannot do this, then\nthat is an indication that the path you are on will ultimately\nlead to pain, suffering, grief, and lamentation.\n";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final String[] JAVAX_CORE = new String[]{"accessibility", "crypto", "imageio", "management", "naming", "net", "print", "rmi", "security", "sip", "sound", "sql", "swing", "transaction", "xml"};
    private static int errors = 0;
    private static Arguments args;
    private static DexFile outputDex;
    private static TreeMap<String, byte[]> outputResources;
    private static final List<byte[]> libraryDexBuffers;
    private static ExecutorService threadPool;
    private static boolean anyFilesProcessed;
    private static long minimumFileAge;
    private static Set<String> classesInMainDex;
    private static List<byte[]> dexOutputArrays;
    private static OutputStreamWriter humanOutWriter;

    private Main() {
    }

    public static void main(String[] stringArray) throws IOException {
        Arguments arguments = new Arguments();
        arguments.parse(stringArray);
        int n = Main.run(arguments);
        if (n != 0) {
            System.exit(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(Arguments arguments) throws IOException {
        errors = 0;
        libraryDexBuffers.clear();
        args = arguments;
        Main.args.makeOptionsObjects();
        OutputStream outputStream = null;
        if (Main.args.humanOutName != null) {
            outputStream = Main.openOutput(Main.args.humanOutName);
            humanOutWriter = new OutputStreamWriter(outputStream);
        }
        try {
            if (Main.args.multiDex) {
                int n = Main.runMultiDex();
                return n;
            }
            int n = Main.runMonoDex();
            return n;
        }
        finally {
            Main.closeOutput(outputStream);
        }
    }

    public static String getTooManyIdsErrorMessage() {
        if (Main.args.multiDex) {
            return "The list of classes given in --main-dex-list is too big and does not fit in the main dex.";
        }
        return "You may try using --multi-dex option.";
    }

    private static int runMonoDex() throws IOException {
        File file = null;
        if (Main.args.incremental) {
            if (Main.args.outName == null) {
                System.err.println("error: no incremental output name specified");
                return -1;
            }
            file = new File(Main.args.outName);
            if (file.exists()) {
                minimumFileAge = file.lastModified();
            }
        }
        if (!Main.processAllFiles()) {
            return 1;
        }
        if (Main.args.incremental && !anyFilesProcessed) {
            return 0;
        }
        byte[] byArray = null;
        if (!(outputDex.isEmpty() && Main.args.humanOutName == null || (byArray = Main.writeDex()) != null)) {
            return 2;
        }
        if (Main.args.incremental) {
            byArray = Main.mergeIncremental(byArray, file);
        }
        byArray = Main.mergeLibraryDexBuffers(byArray);
        if (Main.args.jarOutput) {
            outputDex = null;
            if (byArray != null) {
                outputResources.put("classes.dex", byArray);
            }
            if (!Main.createJar(Main.args.outName)) {
                return 3;
            }
        } else if (byArray != null && Main.args.outName != null) {
            OutputStream outputStream = Main.openOutput(Main.args.outName);
            outputStream.write(byArray);
            Main.closeOutput(outputStream);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runMultiDex() throws IOException {
        assert (!Main.args.incremental);
        assert (Main.args.numThreads == 1);
        if (Main.args.mainDexListFile != null) {
            classesInMainDex = Main.loadMainDexListFile(Main.args.mainDexListFile);
        }
        if (!Main.processAllFiles()) {
            return 1;
        }
        if (!libraryDexBuffers.isEmpty()) {
            throw new DexException("Library dex files are not supported in multi-dex mode");
        }
        if (outputDex != null) {
            dexOutputArrays.add(Main.writeDex());
            outputDex = null;
        }
        if (Main.args.jarOutput) {
            for (int i = 0; i < dexOutputArrays.size(); ++i) {
                outputResources.put(Main.getDexFileName(i), dexOutputArrays.get(i));
            }
            if (!Main.createJar(Main.args.outName)) {
                return 3;
            }
        } else if (Main.args.outName != null) {
            File file = new File(Main.args.outName);
            assert (file.isDirectory());
            for (int i = 0; i < dexOutputArrays.size(); ++i) {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(file, Main.getDexFileName(i)));
                try {
                    ((OutputStream)fileOutputStream).write(dexOutputArrays.get(i));
                    continue;
                }
                finally {
                    Main.closeOutput(fileOutputStream);
                }
            }
        }
        return 0;
    }

    private static String getDexFileName(int n) {
        if (n == 0) {
            return "classes.dex";
        }
        return DEX_PREFIX + (n + 1) + DEX_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> loadMainDexListFile(String string) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            FileReader fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            while (null != (string2 = bufferedReader.readLine())) {
                hashSet.add(Main.fixPath(string2));
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return hashSet;
    }

    private static byte[] mergeIncremental(byte[] byArray, File file) throws IOException {
        Dex dex = null;
        Dex dex2 = null;
        if (byArray != null) {
            dex = new Dex(byArray);
        }
        if (file.exists()) {
            dex2 = new Dex(file);
        }
        if (dex == null && dex2 == null) {
            return null;
        }
        Dex dex3 = dex == null ? dex2 : (dex2 == null ? dex : new DexMerger(dex, dex2, CollisionPolicy.KEEP_FIRST).merge());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        dex3.writeTo(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] mergeLibraryDexBuffers(byte[] byArray) throws IOException {
        for (byte[] byArray2 : libraryDexBuffers) {
            if (byArray == null) {
                byArray = byArray2;
                continue;
            }
            Dex dex = new Dex(byArray);
            Dex dex2 = new Dex(byArray2);
            Dex dex3 = new DexMerger(dex, dex2, CollisionPolicy.FAIL).merge();
            byArray = dex3.getBytes();
        }
        return byArray;
    }

    private static boolean processAllFiles() {
        Main.createDexFile();
        if (Main.args.jarOutput) {
            outputResources = new TreeMap();
        }
        anyFilesProcessed = false;
        String[] stringArray = Main.args.fileNames;
        if (Main.args.numThreads > 1) {
            threadPool = Executors.newFixedThreadPool(Main.args.numThreads);
        }
        try {
            if (Main.args.mainDexListFile != null) {
                int n;
                ClassPathOpener.FileNameFilter fileNameFilter = Main.args.strictNameCheck ? new MainDexListFilter() : new BestEffortMainDexListFilter();
                for (n = 0; n < stringArray.length; ++n) {
                    if (!Main.processOne(stringArray[n], fileNameFilter)) continue;
                    anyFilesProcessed = true;
                }
                if (dexOutputArrays.size() > 1) {
                    throw new DexException("Too many classes in --main-dex-list, main dex capacity exceeded");
                }
                if (Main.args.minimalMainDex) {
                    Main.createDexFile();
                }
                for (n = 0; n < stringArray.length; ++n) {
                    if (!Main.processOne(stringArray[n], new NotFilter(fileNameFilter))) continue;
                    anyFilesProcessed = true;
                }
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!Main.processOne(stringArray[i], ClassPathOpener.acceptAll)) continue;
                    anyFilesProcessed = true;
                }
            }
        }
        catch (StopProcessing stopProcessing) {
            // empty catch block
        }
        if (Main.args.numThreads > 1) {
            try {
                threadPool.shutdown();
                threadPool.awaitTermination(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Timed out waiting for threads.");
            }
        }
        if (errors != 0) {
            DxConsole.err.println(errors + " error" + (errors == 1 ? "" : "s") + "; aborting");
            return false;
        }
        if (Main.args.incremental && !anyFilesProcessed) {
            return true;
        }
        if (!anyFilesProcessed && !Main.args.emptyOk) {
            DxConsole.err.println("no classfiles specified");
            return false;
        }
        if (Main.args.optimize && Main.args.statistics) {
            CodeStatistics.dumpStatistics(DxConsole.out);
        }
        return true;
    }

    private static void createDexFile() {
        if (outputDex != null) {
            dexOutputArrays.add(Main.writeDex());
        }
        outputDex = new DexFile(Main.args.dexOptions);
        if (Main.args.dumpWidth != 0) {
            outputDex.setDumpWidth(Main.args.dumpWidth);
        }
    }

    private static boolean processOne(String string, ClassPathOpener.FileNameFilter fileNameFilter) {
        ClassPathOpener classPathOpener = new ClassPathOpener(string, false, fileNameFilter, new ClassPathOpener.Consumer(){

            public boolean processFileBytes(String string, long l, byte[] byArray) {
                if (args.numThreads > 1) {
                    threadPool.execute(new ParallelProcessor(string, l, byArray));
                    return false;
                }
                return Main.processFileBytes(string, l, byArray);
            }

            public void onException(Exception exception) {
                if (exception instanceof StopProcessing) {
                    throw (StopProcessing)exception;
                }
                if (exception instanceof SimException) {
                    DxConsole.err.println("\nEXCEPTION FROM SIMULATION:");
                    DxConsole.err.println(exception.getMessage() + "\n");
                    DxConsole.err.println(((SimException)exception).getContext());
                } else {
                    DxConsole.err.println("\nUNEXPECTED TOP-LEVEL EXCEPTION:");
                    exception.printStackTrace(DxConsole.err);
                }
                errors++;
            }

            public void onProcessArchiveStart(File file) {
                if (args.verbose) {
                    DxConsole.out.println("processing archive " + file + "...");
                }
            }
        });
        return classPathOpener.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processFileBytes(String string, long l, byte[] byArray) {
        boolean bl;
        boolean bl2 = string.endsWith(".class");
        boolean bl3 = string.equals("classes.dex");
        boolean bl4 = bl = outputResources != null;
        if (!(bl2 || bl3 || bl)) {
            if (Main.args.verbose) {
                DxConsole.out.println("ignored resource " + string);
            }
            return false;
        }
        if (Main.args.verbose) {
            DxConsole.out.println("processing " + string + "...");
        }
        String string2 = Main.fixPath(string);
        if (bl2) {
            if (bl && Main.args.keepClassesInJar) {
                TreeMap<String, byte[]> treeMap = outputResources;
                synchronized (treeMap) {
                    outputResources.put(string2, byArray);
                }
            }
            if (l < minimumFileAge) {
                return true;
            }
            return Main.processClass(string2, byArray);
        }
        if (bl3) {
            List<byte[]> list = libraryDexBuffers;
            synchronized (list) {
                libraryDexBuffers.add(byArray);
            }
            return true;
        }
        TreeMap<String, byte[]> treeMap = outputResources;
        synchronized (treeMap) {
            outputResources.put(string2, byArray);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processClass(String string, byte[] byArray) {
        if (!Main.args.coreLibrary) {
            Main.checkClassName(string);
        }
        DirectClassFile directClassFile = new DirectClassFile(byArray, string, Main.args.cfOptions.strictNameCheck);
        directClassFile.setAttributeFactory(StdAttributeFactory.THE_ONE);
        directClassFile.getMagic();
        int n = outputDex.getMethodIds().items().size();
        int n2 = outputDex.getFieldIds().items().size();
        int n3 = outputDex.getTypeIds().items().size();
        int n4 = directClassFile.getConstantPool().size();
        if (Main.args.multiDex && (n + n4 > args.maxNumberOfIdxPerDex || n2 + n4 > args.maxNumberOfIdxPerDex || n3 + n4 + 7 > args.maxNumberOfIdxPerDex)) {
            Main.createDexFile();
        }
        try {
            ClassDefItem classDefItem = CfTranslator.translate(directClassFile, byArray, Main.args.cfOptions, Main.args.dexOptions, outputDex);
            DexFile dexFile = outputDex;
            synchronized (dexFile) {
                outputDex.add(classDefItem);
            }
            return true;
        }
        catch (ParseException parseException) {
            DxConsole.err.println("\ntrouble processing:");
            if (Main.args.debug) {
                parseException.printStackTrace(DxConsole.err);
            } else {
                parseException.printContext(DxConsole.err);
            }
            ++errors;
            return false;
        }
    }

    private static void checkClassName(String string) {
        boolean bl = false;
        if (string.startsWith("java/")) {
            bl = true;
        } else if (string.startsWith("javax/")) {
            int n = string.indexOf(47, 6);
            if (n == -1) {
                bl = true;
            } else {
                String string2 = string.substring(6, n);
                boolean bl2 = bl = Arrays.binarySearch(JAVAX_CORE, string2) >= 0;
            }
        }
        if (!bl) {
            return;
        }
        DxConsole.err.println("\ntrouble processing \"" + string + "\":\n\n" + IN_RE_CORE_CLASSES);
        ++errors;
        throw new StopProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] writeDex() {
        byte[] byArray = null;
        try {
            try {
                if (Main.args.methodToDump != null) {
                    outputDex.toDex(null, false);
                    Main.dumpMethod(outputDex, Main.args.methodToDump, humanOutWriter);
                } else {
                    byArray = outputDex.toDex(humanOutWriter, Main.args.verboseDump);
                }
                if (Main.args.statistics) {
                    DxConsole.out.println(outputDex.getStatistics().toHuman());
                }
            }
            finally {
                if (humanOutWriter != null) {
                    humanOutWriter.flush();
                }
            }
        }
        catch (Exception exception) {
            if (Main.args.debug) {
                DxConsole.err.println("\ntrouble writing output:");
                exception.printStackTrace(DxConsole.err);
            } else {
                DxConsole.err.println("\ntrouble writing output: " + exception.getMessage());
            }
            return null;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createJar(String string) {
        try {
            Manifest manifest = Main.makeManifest();
            OutputStream outputStream = Main.openOutput(string);
            JarOutputStream jarOutputStream = new JarOutputStream(outputStream, manifest);
            try {
                for (Map.Entry<String, byte[]> entry : outputResources.entrySet()) {
                    String string2 = entry.getKey();
                    byte[] byArray = entry.getValue();
                    JarEntry jarEntry = new JarEntry(string2);
                    int n = byArray.length;
                    if (Main.args.verbose) {
                        DxConsole.out.println("writing " + string2 + "; size " + n + "...");
                    }
                    jarEntry.setSize(n);
                    jarOutputStream.putNextEntry(jarEntry);
                    jarOutputStream.write(byArray);
                    jarOutputStream.closeEntry();
                }
            }
            finally {
                jarOutputStream.finish();
                jarOutputStream.flush();
                Main.closeOutput(outputStream);
            }
        }
        catch (Exception exception) {
            if (Main.args.debug) {
                DxConsole.err.println("\ntrouble writing output:");
                exception.printStackTrace(DxConsole.err);
            } else {
                DxConsole.err.println("\ntrouble writing output: " + exception.getMessage());
            }
            return false;
        }
        return true;
    }

    private static Manifest makeManifest() throws IOException {
        Attributes attributes;
        Manifest manifest;
        byte[] byArray = outputResources.get(MANIFEST_NAME);
        if (byArray == null) {
            manifest = new Manifest();
            attributes = manifest.getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        } else {
            manifest = new Manifest(new ByteArrayInputStream(byArray));
            attributes = manifest.getMainAttributes();
            outputResources.remove(MANIFEST_NAME);
        }
        String string = attributes.getValue(CREATED_BY);
        string = string == null ? "" : string + " + ";
        string = string + "dx 1.8";
        attributes.put(CREATED_BY, string);
        attributes.putValue("Dex-Location", "classes.dex");
        return manifest;
    }

    private static OutputStream openOutput(String string) throws IOException {
        if (string.equals("-") || string.startsWith("-.")) {
            return System.out;
        }
        return new FileOutputStream(string);
    }

    private static void closeOutput(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return;
        }
        outputStream.flush();
        if (outputStream != System.out) {
            outputStream.close();
        }
    }

    private static String fixPath(String string) {
        int n;
        if (File.separatorChar == '\\') {
            string = string.replace('\\', '/');
        }
        if ((n = string.lastIndexOf("/./")) != -1) {
            return string.substring(n + 3);
        }
        if (string.startsWith("./")) {
            return string.substring(2);
        }
        return string;
    }

    private static void dumpMethod(DexFile dexFile, String string, OutputStreamWriter outputStreamWriter) {
        boolean bl = string.endsWith("*");
        int n = string.lastIndexOf(46);
        if (n <= 0 || n == string.length() - 1) {
            DxConsole.err.println("bogus fully-qualified method name: " + string);
            return;
        }
        String string2 = string.substring(0, n).replace('.', '/');
        String string3 = string.substring(n + 1);
        ClassDefItem classDefItem = dexFile.getClassOrNull(string2);
        if (classDefItem == null) {
            DxConsole.err.println("no such class: " + string2);
            return;
        }
        if (bl) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        ArrayList<EncodedMethod> arrayList = classDefItem.getMethods();
        TreeMap<CstNat, EncodedMethod> treeMap = new TreeMap<CstNat, EncodedMethod>();
        for (EncodedMethod object : arrayList) {
            Object object2 = object.getName().getString();
            if ((!bl || !((String)object2).startsWith(string3)) && (bl || !((String)object2).equals(string3))) continue;
            treeMap.put(object.getRef().getNat(), object);
        }
        if (treeMap.size() == 0) {
            DxConsole.err.println("no such method: " + string);
            return;
        }
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        for (Object object2 : treeMap.values()) {
            ((EncodedMethod)object2).debugPrint(printWriter, Main.args.verboseDump);
            CstString cstString = classDefItem.getSourceFile();
            if (cstString != null) {
                printWriter.println("  source file: " + cstString.toQuoted());
            }
            Annotations annotations = classDefItem.getMethodAnnotations(((EncodedMethod)object2).getRef());
            AnnotationsList annotationsList = classDefItem.getParameterAnnotations(((EncodedMethod)object2).getRef());
            if (annotations != null) {
                printWriter.println("  method annotations:");
                for (Annotation i : annotations.getAnnotations()) {
                    printWriter.println("    " + i);
                }
            }
            if (annotationsList == null) continue;
            printWriter.println("  parameter annotations:");
            int n2 = annotationsList.size();
            for (int i = 0; i < n2; ++i) {
                printWriter.println("    parameter " + i);
                Annotations annotations2 = annotationsList.get(i);
                for (Annotation annotation : annotations2.getAnnotations()) {
                    printWriter.println("      " + annotation);
                }
            }
        }
        printWriter.flush();
    }

    static {
        libraryDexBuffers = new ArrayList<byte[]>();
        minimumFileAge = 0L;
        classesInMainDex = null;
        dexOutputArrays = new ArrayList<byte[]>();
        humanOutWriter = null;
    }

    private static class ParallelProcessor
    implements Runnable {
        String path;
        long lastModified;
        byte[] bytes;

        private ParallelProcessor(String string, long l, byte[] byArray) {
            this.path = string;
            this.lastModified = l;
            this.bytes = byArray;
        }

        public void run() {
            if (Main.processFileBytes(this.path, this.lastModified, this.bytes)) {
                anyFilesProcessed = true;
            }
        }
    }

    public static class Arguments {
        private static final String MINIMAL_MAIN_DEX_OPTION = "--minimal-main-dex";
        private static final String MAIN_DEX_LIST_OPTION = "--main-dex-list";
        private static final String MULTI_DEX_OPTION = "--multi-dex";
        private static final String NUM_THREADS_OPTION = "--num-threads";
        private static final String INCREMENTAL_OPTION = "--incremental";
        public boolean debug = false;
        public boolean verbose = false;
        public boolean verboseDump = false;
        public boolean coreLibrary = false;
        public String methodToDump = null;
        public int dumpWidth = 0;
        public String outName = null;
        public String humanOutName = null;
        public boolean strictNameCheck = true;
        public boolean emptyOk = false;
        public boolean jarOutput = false;
        public boolean keepClassesInJar = false;
        public int positionInfo = 2;
        public boolean localInfo = true;
        public boolean incremental = false;
        public boolean forceJumbo = false;
        public String[] fileNames;
        public boolean optimize = true;
        public String optimizeListFile = null;
        public String dontOptimizeListFile = null;
        public boolean statistics;
        public CfOptions cfOptions;
        public DexOptions dexOptions;
        public int numThreads = 1;
        public boolean multiDex = false;
        public String mainDexListFile = null;
        public boolean minimalMainDex = false;
        private int maxNumberOfIdxPerDex = 65536;

        public void parse(String[] stringArray) {
            ArgumentsParser argumentsParser = new ArgumentsParser(stringArray);
            boolean bl = false;
            boolean bl2 = false;
            while (argumentsParser.getNext()) {
                if (argumentsParser.isArg("--debug")) {
                    this.debug = true;
                    continue;
                }
                if (argumentsParser.isArg("--verbose")) {
                    this.verbose = true;
                    continue;
                }
                if (argumentsParser.isArg("--verbose-dump")) {
                    this.verboseDump = true;
                    continue;
                }
                if (argumentsParser.isArg("--no-files")) {
                    this.emptyOk = true;
                    continue;
                }
                if (argumentsParser.isArg("--no-optimize")) {
                    this.optimize = false;
                    continue;
                }
                if (argumentsParser.isArg("--no-strict")) {
                    this.strictNameCheck = false;
                    continue;
                }
                if (argumentsParser.isArg("--core-library")) {
                    this.coreLibrary = true;
                    continue;
                }
                if (argumentsParser.isArg("--statistics")) {
                    this.statistics = true;
                    continue;
                }
                if (argumentsParser.isArg("--optimize-list=")) {
                    if (this.dontOptimizeListFile != null) {
                        System.err.println("--optimize-list and --no-optimize-list are incompatible.");
                        throw new UsageException();
                    }
                    this.optimize = true;
                    this.optimizeListFile = argumentsParser.getLastValue();
                    continue;
                }
                if (argumentsParser.isArg("--no-optimize-list=")) {
                    if (this.dontOptimizeListFile != null) {
                        System.err.println("--optimize-list and --no-optimize-list are incompatible.");
                        throw new UsageException();
                    }
                    this.optimize = true;
                    this.dontOptimizeListFile = argumentsParser.getLastValue();
                    continue;
                }
                if (argumentsParser.isArg("--keep-classes")) {
                    this.keepClassesInJar = true;
                    continue;
                }
                if (argumentsParser.isArg("--output=")) {
                    this.outName = argumentsParser.getLastValue();
                    if (new File(this.outName).isDirectory()) {
                        this.jarOutput = false;
                        bl = true;
                        continue;
                    }
                    if (FileUtils.hasArchiveSuffix(this.outName)) {
                        this.jarOutput = true;
                        continue;
                    }
                    if (this.outName.endsWith(Main.DEX_EXTENSION) || this.outName.equals("-")) {
                        this.jarOutput = false;
                        bl2 = true;
                        continue;
                    }
                    System.err.println("unknown output extension: " + this.outName);
                    throw new UsageException();
                }
                if (argumentsParser.isArg("--dump-to=")) {
                    this.humanOutName = argumentsParser.getLastValue();
                    continue;
                }
                if (argumentsParser.isArg("--dump-width=")) {
                    this.dumpWidth = Integer.parseInt(argumentsParser.getLastValue());
                    continue;
                }
                if (argumentsParser.isArg("--dump-method=")) {
                    this.methodToDump = argumentsParser.getLastValue();
                    this.jarOutput = false;
                    continue;
                }
                if (argumentsParser.isArg("--positions=")) {
                    String string = argumentsParser.getLastValue().intern();
                    if (string == "none") {
                        this.positionInfo = 1;
                        continue;
                    }
                    if (string == "important") {
                        this.positionInfo = 3;
                        continue;
                    }
                    if (string == "lines") {
                        this.positionInfo = 2;
                        continue;
                    }
                    System.err.println("unknown positions option: " + string);
                    throw new UsageException();
                }
                if (argumentsParser.isArg("--no-locals")) {
                    this.localInfo = false;
                    continue;
                }
                if (argumentsParser.isArg("--num-threads=")) {
                    this.numThreads = Integer.parseInt(argumentsParser.getLastValue());
                    continue;
                }
                if (argumentsParser.isArg(INCREMENTAL_OPTION)) {
                    this.incremental = true;
                    continue;
                }
                if (argumentsParser.isArg("--force-jumbo")) {
                    this.forceJumbo = true;
                    continue;
                }
                if (argumentsParser.isArg(MULTI_DEX_OPTION)) {
                    this.multiDex = true;
                    continue;
                }
                if (argumentsParser.isArg("--main-dex-list=")) {
                    this.mainDexListFile = argumentsParser.getLastValue();
                    continue;
                }
                if (argumentsParser.isArg(MINIMAL_MAIN_DEX_OPTION)) {
                    this.minimalMainDex = true;
                    continue;
                }
                if (argumentsParser.isArg("--set-max-idx-number=")) {
                    this.maxNumberOfIdxPerDex = Integer.parseInt(argumentsParser.getLastValue());
                    continue;
                }
                System.err.println("unknown option: " + argumentsParser.getCurrent());
                throw new UsageException();
            }
            this.fileNames = argumentsParser.getRemaining();
            if (this.fileNames.length == 0) {
                if (!this.emptyOk) {
                    System.err.println("no input files specified");
                    throw new UsageException();
                }
            } else if (this.emptyOk) {
                System.out.println("ignoring input files");
            }
            if (this.humanOutName == null && this.methodToDump != null) {
                this.humanOutName = "-";
            }
            if (this.mainDexListFile != null && !this.multiDex) {
                System.err.println("--main-dex-list is only supported in combination with --multi-dex");
                throw new UsageException();
            }
            if (this.minimalMainDex && (this.mainDexListFile == null || !this.multiDex)) {
                System.err.println("--minimal-main-dex is only supported in combination with --multi-dex and --main-dex-list");
                throw new UsageException();
            }
            if (this.multiDex && this.numThreads != 1) {
                System.out.println("--num-threads is ignored when used with --multi-dex");
                this.numThreads = 1;
            }
            if (this.multiDex && this.incremental) {
                System.err.println("--incremental is not supported with --multi-dex");
                throw new UsageException();
            }
            if (this.multiDex && bl2) {
                System.err.println("Unsupported output \"" + this.outName + "\". " + MULTI_DEX_OPTION + " supports only archive or directory output");
                throw new UsageException();
            }
            if (bl && !this.multiDex) {
                this.outName = new File(this.outName, "classes.dex").getPath();
            }
            this.makeOptionsObjects();
        }

        private void makeOptionsObjects() {
            this.cfOptions = new CfOptions();
            this.cfOptions.positionInfo = this.positionInfo;
            this.cfOptions.localInfo = this.localInfo;
            this.cfOptions.strictNameCheck = this.strictNameCheck;
            this.cfOptions.optimize = this.optimize;
            this.cfOptions.optimizeListFile = this.optimizeListFile;
            this.cfOptions.dontOptimizeListFile = this.dontOptimizeListFile;
            this.cfOptions.statistics = this.statistics;
            this.cfOptions.warn = DxConsole.err;
            this.dexOptions = new DexOptions();
            this.dexOptions.forceJumbo = this.forceJumbo;
        }

        private static class ArgumentsParser {
            private final String[] arguments;
            private int index;
            private String current;
            private String lastValue;

            public ArgumentsParser(String[] stringArray) {
                this.arguments = stringArray;
                this.index = 0;
            }

            public String getCurrent() {
                return this.current;
            }

            public String getLastValue() {
                return this.lastValue;
            }

            public boolean getNext() {
                if (this.index >= this.arguments.length) {
                    return false;
                }
                this.current = this.arguments[this.index];
                if (this.current.equals("--") || !this.current.startsWith("--")) {
                    return false;
                }
                ++this.index;
                return true;
            }

            private boolean getNextValue() {
                if (this.index >= this.arguments.length) {
                    return false;
                }
                this.current = this.arguments[this.index];
                ++this.index;
                return true;
            }

            public String[] getRemaining() {
                int n = this.arguments.length - this.index;
                String[] stringArray = new String[n];
                if (n > 0) {
                    System.arraycopy(this.arguments, this.index, stringArray, 0, n);
                }
                return stringArray;
            }

            public boolean isArg(String string) {
                int n = string.length();
                if (n > 0 && string.charAt(n - 1) == '=') {
                    if (this.current.startsWith(string)) {
                        this.lastValue = this.current.substring(n);
                        return true;
                    }
                    if (this.current.equals(string = string.substring(0, n - 1))) {
                        if (this.getNextValue()) {
                            this.lastValue = this.current;
                            return true;
                        }
                        System.err.println("Missing value after parameter " + string);
                        throw new UsageException();
                    }
                    return false;
                }
                return this.current.equals(string);
            }
        }
    }

    private static class StopProcessing
    extends RuntimeException {
        private StopProcessing() {
        }
    }

    private static class BestEffortMainDexListFilter
    implements ClassPathOpener.FileNameFilter {
        Map<String, List<String>> map = new HashMap<String, List<String>>();

        public BestEffortMainDexListFilter() {
            for (String string : classesInMainDex) {
                String string2 = Main.fixPath(string);
                String string3 = BestEffortMainDexListFilter.getSimpleName(string2);
                List<String> list = this.map.get(string3);
                if (list == null) {
                    list = new ArrayList<String>(1);
                    this.map.put(string3, list);
                }
                list.add(string2);
            }
        }

        public boolean accept(String string) {
            if (string.endsWith(".class")) {
                String string2 = Main.fixPath(string);
                String string3 = BestEffortMainDexListFilter.getSimpleName(string2);
                List<String> list = this.map.get(string3);
                if (list != null) {
                    for (String string4 : list) {
                        if (!string2.endsWith(string4)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        private static String getSimpleName(String string) {
            int n = string.lastIndexOf(47);
            if (n >= 0) {
                return string.substring(n + 1);
            }
            return string;
        }
    }

    private static class MainDexListFilter
    implements ClassPathOpener.FileNameFilter {
        private MainDexListFilter() {
        }

        public boolean accept(String string) {
            if (string.endsWith(".class")) {
                String string2 = Main.fixPath(string);
                return classesInMainDex.contains(string2);
            }
            return true;
        }
    }

    private static class NotFilter
    implements ClassPathOpener.FileNameFilter {
        private final ClassPathOpener.FileNameFilter filter;

        private NotFilter(ClassPathOpener.FileNameFilter fileNameFilter) {
            this.filter = fileNameFilter;
        }

        public boolean accept(String string) {
            return !this.filter.accept(string);
        }
    }
}

