/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.annotool;

import com.android.dx.command.annotool.AnnotationLister;
import java.lang.annotation.ElementType;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Locale;

public class Main {
    private Main() {
    }

    public static void main(String[] stringArray) {
        Arguments arguments = new Arguments();
        try {
            arguments.parse(stringArray);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            System.err.println(invalidArgumentException.getMessage());
            throw new RuntimeException("usage");
        }
        new AnnotationLister(arguments).process();
    }

    static class Arguments {
        String aclass;
        EnumSet<ElementType> eTypes = EnumSet.noneOf(ElementType.class);
        EnumSet<PrintType> printTypes = EnumSet.noneOf(PrintType.class);
        String[] files;

        Arguments() {
        }

        void parse(String[] stringArray) throws InvalidArgumentException {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                String string2 = stringArray[i];
                if (string2.startsWith("--annotation=")) {
                    string = string2.substring(string2.indexOf(61) + 1);
                    if (this.aclass != null) {
                        throw new InvalidArgumentException("--annotation can only be specified once.");
                    }
                    this.aclass = string.replace('.', '/');
                    continue;
                }
                if (string2.startsWith("--element=")) {
                    string = string2.substring(string2.indexOf(61) + 1);
                    try {
                        for (String string3 : string.split(",")) {
                            this.eTypes.add(ElementType.valueOf(string3.toUpperCase(Locale.ROOT)));
                        }
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidArgumentException("invalid --element");
                    }
                }
                if (string2.startsWith("--print=")) {
                    string = string2.substring(string2.indexOf(61) + 1);
                    try {
                        for (String string3 : string.split(",")) {
                            this.printTypes.add(PrintType.valueOf(string3.toUpperCase(Locale.ROOT)));
                        }
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidArgumentException("invalid --print");
                    }
                }
                this.files = new String[stringArray.length - i];
                System.arraycopy(stringArray, i, this.files, 0, this.files.length);
                break;
            }
            if (this.aclass == null) {
                throw new InvalidArgumentException("--annotation must be specified");
            }
            if (this.printTypes.isEmpty()) {
                this.printTypes.add(PrintType.CLASS);
            }
            if (this.eTypes.isEmpty()) {
                this.eTypes.add(ElementType.TYPE);
            }
            Object object = this.eTypes.clone();
            ((AbstractCollection)object).remove((Object)ElementType.TYPE);
            ((AbstractCollection)object).remove((Object)ElementType.PACKAGE);
            if (!((AbstractCollection)object).isEmpty()) {
                throw new InvalidArgumentException("only --element parameters 'type' and 'package' supported");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PrintType {
        CLASS,
        INNERCLASS,
        METHOD,
        PACKAGE;

    }

    private static class InvalidArgumentException
    extends Exception {
        InvalidArgumentException() {
        }

        InvalidArgumentException(String string) {
            super(string);
        }
    }
}

