/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.cf.code.BasicBlocker;
import com.android.dx.cf.code.ByteBlock;
import com.android.dx.cf.code.ByteBlockList;
import com.android.dx.cf.code.ByteCatchList;
import com.android.dx.cf.code.ConcreteMethod;
import com.android.dx.cf.code.Frame;
import com.android.dx.cf.code.LocalVariableList;
import com.android.dx.cf.code.ReturnAddress;
import com.android.dx.cf.code.RopperMachine;
import com.android.dx.cf.code.SimException;
import com.android.dx.cf.code.Simulator;
import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.InsnList;
import com.android.dx.rop.code.PlainCstInsn;
import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.code.Rops;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.code.ThrowingCstInsn;
import com.android.dx.rop.code.ThrowingInsn;
import com.android.dx.rop.code.TranslationAdvice;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Prototype;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.util.Bits;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;
import com.android.dx.util.MutabilityControl;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class Ropper {
    private static final int PARAM_ASSIGNMENT = -1;
    private static final int RETURN = -2;
    private static final int SYNCH_RETURN = -3;
    private static final int SYNCH_SETUP_1 = -4;
    private static final int SYNCH_SETUP_2 = -5;
    private static final int SYNCH_CATCH_1 = -6;
    private static final int SYNCH_CATCH_2 = -7;
    private static final int SPECIAL_LABEL_COUNT = 7;
    private final ConcreteMethod method;
    private final ByteBlockList blocks;
    private final int maxLocals;
    private final int maxLabel;
    private final RopperMachine machine;
    private final Simulator sim;
    private final Frame[] startFrames;
    private final ArrayList<BasicBlock> result;
    private final ArrayList<IntList> resultSubroutines;
    private final CatchInfo[] catchInfos;
    private boolean synchNeedsExceptionHandler;
    private final Subroutine[] subroutines;
    private boolean hasSubroutines;
    private final ExceptionSetupLabelAllocator exceptionSetupLabelAllocator;

    public static RopMethod convert(ConcreteMethod concreteMethod, TranslationAdvice translationAdvice) {
        try {
            Ropper ropper = new Ropper(concreteMethod, translationAdvice);
            ropper.doit();
            return ropper.getRopMethod();
        }
        catch (SimException simException) {
            simException.addContext("...while working on method " + concreteMethod.getNat().toHuman());
            throw simException;
        }
    }

    private Ropper(ConcreteMethod concreteMethod, TranslationAdvice translationAdvice) {
        if (concreteMethod == null) {
            throw new NullPointerException("method == null");
        }
        if (translationAdvice == null) {
            throw new NullPointerException("advice == null");
        }
        this.method = concreteMethod;
        this.blocks = BasicBlocker.identifyBlocks(concreteMethod);
        this.maxLabel = this.blocks.getMaxLabel();
        this.maxLocals = concreteMethod.getMaxLocals();
        this.machine = new RopperMachine(this, concreteMethod, translationAdvice);
        this.sim = new Simulator(this.machine, concreteMethod);
        this.startFrames = new Frame[this.maxLabel];
        this.subroutines = new Subroutine[this.maxLabel];
        this.result = new ArrayList(this.blocks.size() * 2 + 10);
        this.resultSubroutines = new ArrayList(this.blocks.size() * 2 + 10);
        this.catchInfos = new CatchInfo[this.maxLabel];
        this.synchNeedsExceptionHandler = false;
        this.startFrames[0] = new Frame(this.maxLocals, concreteMethod.getMaxStack());
        this.exceptionSetupLabelAllocator = new ExceptionSetupLabelAllocator();
    }

    int getFirstTempStackReg() {
        int n = this.getNormalRegCount();
        return this.isSynchronized() ? n + 1 : n;
    }

    private int getSpecialLabel(int n) {
        return this.maxLabel + this.method.getCatches().size() + ~n;
    }

    private int getMinimumUnreservedLabel() {
        return this.maxLabel + this.method.getCatches().size() + 7;
    }

    private int getAvailableLabel() {
        int n = this.getMinimumUnreservedLabel();
        for (BasicBlock basicBlock : this.result) {
            int n2 = basicBlock.getLabel();
            if (n2 < n) continue;
            n = n2 + 1;
        }
        return n;
    }

    private boolean isSynchronized() {
        int n = this.method.getAccessFlags();
        return (n & 0x20) != 0;
    }

    private boolean isStatic() {
        int n = this.method.getAccessFlags();
        return (n & 8) != 0;
    }

    private int getNormalRegCount() {
        return this.maxLocals + this.method.getMaxStack();
    }

    private RegisterSpec getSynchReg() {
        int n = this.getNormalRegCount();
        return RegisterSpec.make(n < 1 ? 1 : n, Type.OBJECT);
    }

    private int labelToResultIndex(int n) {
        int n2 = this.result.size();
        for (int i = 0; i < n2; ++i) {
            BasicBlock basicBlock = this.result.get(i);
            if (basicBlock.getLabel() != n) continue;
            return i;
        }
        return -1;
    }

    private BasicBlock labelToBlock(int n) {
        int n2 = this.labelToResultIndex(n);
        if (n2 < 0) {
            throw new IllegalArgumentException("no such label " + Hex.u2(n));
        }
        return this.result.get(n2);
    }

    private void addBlock(BasicBlock basicBlock, IntList intList) {
        if (basicBlock == null) {
            throw new NullPointerException("block == null");
        }
        this.result.add(basicBlock);
        intList.throwIfMutable();
        this.resultSubroutines.add(intList);
    }

    private boolean addOrReplaceBlock(BasicBlock basicBlock, IntList intList) {
        boolean bl;
        if (basicBlock == null) {
            throw new NullPointerException("block == null");
        }
        int n = this.labelToResultIndex(basicBlock.getLabel());
        if (n < 0) {
            bl = false;
        } else {
            this.removeBlockAndSpecialSuccessors(n);
            bl = true;
        }
        this.result.add(basicBlock);
        intList.throwIfMutable();
        this.resultSubroutines.add(intList);
        return bl;
    }

    private boolean addOrReplaceBlockNoDelete(BasicBlock basicBlock, IntList intList) {
        boolean bl;
        if (basicBlock == null) {
            throw new NullPointerException("block == null");
        }
        int n = this.labelToResultIndex(basicBlock.getLabel());
        if (n < 0) {
            bl = false;
        } else {
            this.result.remove(n);
            this.resultSubroutines.remove(n);
            bl = true;
        }
        this.result.add(basicBlock);
        intList.throwIfMutable();
        this.resultSubroutines.add(intList);
        return bl;
    }

    private void removeBlockAndSpecialSuccessors(int n) {
        int n2 = this.getMinimumUnreservedLabel();
        BasicBlock basicBlock = this.result.get(n);
        IntList intList = basicBlock.getSuccessors();
        int n3 = intList.size();
        this.result.remove(n);
        this.resultSubroutines.remove(n);
        for (int i = 0; i < n3; ++i) {
            int n4 = intList.get(i);
            if (n4 < n2) continue;
            n = this.labelToResultIndex(n4);
            if (n < 0) {
                throw new RuntimeException("Invalid label " + Hex.u2(n4));
            }
            this.removeBlockAndSpecialSuccessors(n);
        }
    }

    private RopMethod getRopMethod() {
        int n = this.result.size();
        BasicBlockList basicBlockList = new BasicBlockList(n);
        for (int i = 0; i < n; ++i) {
            basicBlockList.set(i, this.result.get(i));
        }
        basicBlockList.setImmutable();
        return new RopMethod(basicBlockList, this.getSpecialLabel(-1));
    }

    private void doit() {
        int n;
        int[] nArray = Bits.makeBitSet(this.maxLabel);
        Bits.set(nArray, 0);
        this.addSetupBlocks();
        this.setFirstFrame();
        while ((n = Bits.findFirst(nArray, 0)) >= 0) {
            Bits.clear(nArray, n);
            ByteBlock byteBlock = this.blocks.labelToBlock(n);
            Frame frame = this.startFrames[n];
            try {
                this.processBlock(byteBlock, frame, nArray);
            }
            catch (SimException simException) {
                simException.addContext("...while working on block " + Hex.u2(n));
                throw simException;
            }
        }
        this.addReturnBlock();
        this.addSynchExceptionHandlerBlock();
        this.addExceptionSetupBlocks();
        if (this.hasSubroutines) {
            this.inlineSubroutines();
        }
    }

    private void setFirstFrame() {
        Prototype prototype = this.method.getEffectiveDescriptor();
        this.startFrames[0].initializeWithParameters(prototype.getParameterTypes());
        this.startFrames[0].setImmutable();
    }

    private void processBlock(ByteBlock byteBlock, Frame frame, int[] nArray) {
        Object object;
        int n;
        Object object2;
        Object object3;
        int n2;
        Object object4;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        ByteCatchList byteCatchList = byteBlock.getCatches();
        this.machine.startBlock(byteCatchList.toRopCatchList());
        frame = frame.copy();
        this.sim.simulate(byteBlock, frame);
        frame.setImmutable();
        int n8 = this.machine.getExtraBlockCount();
        ArrayList<Insn> arrayList = this.machine.getInsns();
        int n9 = arrayList.size();
        int n10 = byteCatchList.size();
        Object object5 = byteBlock.getSuccessors();
        Subroutine subroutine = null;
        if (this.machine.hasJsr()) {
            n7 = 1;
            n6 = ((IntList)object5).get(1);
            if (this.subroutines[n6] == null) {
                this.subroutines[n6] = new Subroutine(n6);
            }
            this.subroutines[n6].addCallerBlock(byteBlock.getLabel());
            subroutine = this.subroutines[n6];
        } else if (this.machine.hasRet()) {
            ReturnAddress returnAddress = this.machine.getReturnAddress();
            n5 = returnAddress.getSubroutineAddress();
            if (this.subroutines[n5] == null) {
                this.subroutines[n5] = new Subroutine(n5, byteBlock.getLabel());
            } else {
                this.subroutines[n5].addRetBlock(byteBlock.getLabel());
            }
            object5 = this.subroutines[n5].getSuccessors();
            this.subroutines[n5].mergeToSuccessors(frame, nArray);
            n7 = ((IntList)object5).size();
        } else {
            n7 = this.machine.wereCatchesUsed() ? n10 : 0;
        }
        n6 = ((IntList)object5).size();
        for (n5 = n7; n5 < n6; ++n5) {
            n4 = ((IntList)object5).get(n5);
            try {
                this.mergeAndWorkAsNecessary(n4, byteBlock.getLabel(), subroutine, frame, nArray);
                continue;
            }
            catch (SimException simException) {
                simException.addContext("...while merging to block " + Hex.u2(n4));
                throw simException;
            }
        }
        if (n6 == 0 && this.machine.returns()) {
            object5 = IntList.makeImmutable(this.getSpecialLabel(-2));
            n6 = 1;
        }
        if (n6 == 0) {
            n5 = -1;
        } else {
            n5 = this.machine.getPrimarySuccessorIndex();
            if (n5 >= 0) {
                n5 = ((IntList)object5).get(n5);
            }
        }
        int n11 = n4 = this.isSynchronized() && this.machine.canThrow() ? 1 : 0;
        if (n4 != 0 || n10 != 0) {
            n3 = 0;
            object4 = new IntList(n6);
            for (n2 = 0; n2 < n10; ++n2) {
                object3 = byteCatchList.get(n2);
                object2 = ((ByteCatchList.Item)object3).getExceptionClass();
                n = ((ByteCatchList.Item)object3).getHandlerPc();
                n3 |= object2 == CstType.OBJECT ? 1 : 0;
                object = frame.makeExceptionHandlerStartFrame((CstType)object2);
                try {
                    this.mergeAndWorkAsNecessary(n, byteBlock.getLabel(), null, (Frame)object, nArray);
                }
                catch (SimException simException) {
                    simException.addContext("...while merging exception to block " + Hex.u2(n));
                    throw simException;
                }
                CatchInfo catchInfo = this.catchInfos[n];
                if (catchInfo == null) {
                    this.catchInfos[n] = catchInfo = new CatchInfo();
                }
                ExceptionHandlerSetup exceptionHandlerSetup = catchInfo.getSetup(((CstType)object2).getClassType());
                ((IntList)object4).add(exceptionHandlerSetup.getLabel());
            }
            if (n4 != 0 && n3 == 0) {
                ((IntList)object4).add(this.getSpecialLabel(-6));
                this.synchNeedsExceptionHandler = true;
                for (n2 = n9 - n8 - 1; n2 < n9; ++n2) {
                    object3 = arrayList.get(n2);
                    if (!((Insn)object3).canThrow()) continue;
                    object3 = ((Insn)object3).withAddedCatch(Type.OBJECT);
                    arrayList.set(n2, (Insn)object3);
                }
            }
            if (n5 >= 0) {
                ((IntList)object4).add(n5);
            }
            ((MutabilityControl)object4).setImmutable();
            object5 = object4;
        }
        n3 = ((IntList)object5).indexOf(n5);
        while (n8 > 0) {
            n2 = ((Insn)(object4 = arrayList.get(--n9))).getOpcode().getBranchingness() == 1 ? 1 : 0;
            object3 = new InsnList(n2 != 0 ? 2 : 1);
            object2 = object5;
            ((InsnList)object3).set(0, (Insn)object4);
            if (n2 != 0) {
                ((InsnList)object3).set(1, new PlainInsn(Rops.GOTO, ((Insn)object4).getPosition(), null, RegisterSpecList.EMPTY));
                object2 = IntList.makeImmutable(n5);
            }
            ((MutabilityControl)object3).setImmutable();
            n = this.getAvailableLabel();
            object = new BasicBlock(n, (InsnList)object3, (IntList)object2, n5);
            this.addBlock((BasicBlock)object, frame.getSubroutines());
            object5 = ((IntList)object5).mutableCopy();
            ((IntList)object5).set(n3, n);
            ((MutabilityControl)object5).setImmutable();
            n5 = n;
            --n8;
        }
        Object object6 = object4 = n9 == 0 ? null : arrayList.get(n9 - 1);
        if (object4 == null || ((Insn)object4).getOpcode().getBranchingness() == 1) {
            SourcePosition sourcePosition = object4 == null ? SourcePosition.NO_INFO : ((Insn)object4).getPosition();
            arrayList.add(new PlainInsn(Rops.GOTO, sourcePosition, null, RegisterSpecList.EMPTY));
            ++n9;
        }
        InsnList insnList = new InsnList(n9);
        for (int i = 0; i < n9; ++i) {
            insnList.set(i, arrayList.get(i));
        }
        insnList.setImmutable();
        BasicBlock basicBlock = new BasicBlock(byteBlock.getLabel(), insnList, (IntList)object5, n5);
        this.addOrReplaceBlock(basicBlock, frame.getSubroutines());
    }

    private void mergeAndWorkAsNecessary(int n, int n2, Subroutine subroutine, Frame frame, int[] nArray) {
        Frame frame2 = this.startFrames[n];
        if (frame2 != null) {
            Frame frame3 = subroutine != null ? frame2.mergeWithSubroutineCaller(frame, subroutine.getStartBlock(), n2) : frame2.mergeWith(frame);
            if (frame3 != frame2) {
                this.startFrames[n] = frame3;
                Bits.set(nArray, n);
            }
        } else {
            this.startFrames[n] = subroutine != null ? frame.makeNewSubroutineStartFrame(n, n2) : frame;
            Bits.set(nArray, n);
        }
    }

    private void addSetupBlocks() {
        Insn insn;
        RegisterSpec registerSpec;
        Object object;
        int n;
        LocalVariableList localVariableList = this.method.getLocalVariables();
        SourcePosition sourcePosition = this.method.makeSourcePosistion(0);
        Prototype prototype = this.method.getEffectiveDescriptor();
        StdTypeList stdTypeList = prototype.getParameterTypes();
        int n2 = stdTypeList.size();
        InsnList insnList = new InsnList(n2 + 1);
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            Type type = stdTypeList.get(n);
            object = localVariableList.pcAndIndexToLocal(0, n3);
            registerSpec = object == null ? RegisterSpec.make(n3, type) : RegisterSpec.makeLocalOptional(n3, type, ((LocalVariableList.Item)object).getLocalItem());
            insn = new PlainCstInsn(Rops.opMoveParam(type), sourcePosition, registerSpec, RegisterSpecList.EMPTY, CstInteger.make(n3));
            insnList.set(n, insn);
            n3 += type.getCategory();
        }
        insnList.set(n2, new PlainInsn(Rops.GOTO, sourcePosition, null, RegisterSpecList.EMPTY));
        insnList.setImmutable();
        n = this.isSynchronized() ? 1 : 0;
        int n4 = n != 0 ? this.getSpecialLabel(-4) : 0;
        object = new BasicBlock(this.getSpecialLabel(-1), insnList, IntList.makeImmutable(n4), n4);
        this.addBlock((BasicBlock)object, IntList.EMPTY);
        if (n != 0) {
            registerSpec = this.getSynchReg();
            if (this.isStatic()) {
                insn = new ThrowingCstInsn(Rops.CONST_OBJECT, sourcePosition, RegisterSpecList.EMPTY, StdTypeList.EMPTY, (Constant)this.method.getDefiningClass());
                insnList = new InsnList(1);
                insnList.set(0, insn);
            } else {
                insnList = new InsnList(2);
                insn = new PlainCstInsn(Rops.MOVE_PARAM_OBJECT, sourcePosition, registerSpec, RegisterSpecList.EMPTY, CstInteger.VALUE_0);
                insnList.set(0, insn);
                insnList.set(1, new PlainInsn(Rops.GOTO, sourcePosition, null, RegisterSpecList.EMPTY));
            }
            int n5 = this.getSpecialLabel(-5);
            insnList.setImmutable();
            object = new BasicBlock(n4, insnList, IntList.makeImmutable(n5), n5);
            this.addBlock((BasicBlock)object, IntList.EMPTY);
            insnList = new InsnList(this.isStatic() ? 2 : 1);
            if (this.isStatic()) {
                insnList.set(0, new PlainInsn(Rops.opMoveResultPseudo(registerSpec), sourcePosition, registerSpec, RegisterSpecList.EMPTY));
            }
            insn = new ThrowingInsn(Rops.MONITOR_ENTER, sourcePosition, RegisterSpecList.make(registerSpec), StdTypeList.EMPTY);
            insnList.set(this.isStatic() ? 1 : 0, insn);
            insnList.setImmutable();
            object = new BasicBlock(n5, insnList, IntList.makeImmutable(0), 0);
            this.addBlock((BasicBlock)object, IntList.EMPTY);
        }
    }

    private void addReturnBlock() {
        RegisterSpecList registerSpecList;
        Object object;
        Object object2;
        InsnList insnList;
        Rop rop = this.machine.getReturnOp();
        if (rop == null) {
            return;
        }
        SourcePosition sourcePosition = this.machine.getReturnPosition();
        int n = this.getSpecialLabel(-2);
        if (this.isSynchronized()) {
            insnList = new InsnList(1);
            object2 = new ThrowingInsn(Rops.MONITOR_EXIT, sourcePosition, RegisterSpecList.make(this.getSynchReg()), StdTypeList.EMPTY);
            insnList.set(0, (Insn)object2);
            insnList.setImmutable();
            int n2 = this.getSpecialLabel(-3);
            object = new BasicBlock(n, insnList, IntList.makeImmutable(n2), n2);
            this.addBlock((BasicBlock)object, IntList.EMPTY);
            n = n2;
        }
        insnList = new InsnList(1);
        object2 = rop.getSources();
        if (object2.size() == 0) {
            registerSpecList = RegisterSpecList.EMPTY;
        } else {
            object = RegisterSpec.make(0, object2.getType(0));
            registerSpecList = RegisterSpecList.make((RegisterSpec)object);
        }
        object = new PlainInsn(rop, sourcePosition, null, registerSpecList);
        insnList.set(0, (Insn)object);
        insnList.setImmutable();
        BasicBlock basicBlock = new BasicBlock(n, insnList, IntList.EMPTY, -1);
        this.addBlock(basicBlock, IntList.EMPTY);
    }

    private void addSynchExceptionHandlerBlock() {
        if (!this.synchNeedsExceptionHandler) {
            return;
        }
        SourcePosition sourcePosition = this.method.makeSourcePosistion(0);
        RegisterSpec registerSpec = RegisterSpec.make(0, Type.THROWABLE);
        InsnList insnList = new InsnList(2);
        Insn insn = new PlainInsn(Rops.opMoveException(Type.THROWABLE), sourcePosition, registerSpec, RegisterSpecList.EMPTY);
        insnList.set(0, insn);
        insn = new ThrowingInsn(Rops.MONITOR_EXIT, sourcePosition, RegisterSpecList.make(this.getSynchReg()), StdTypeList.EMPTY);
        insnList.set(1, insn);
        insnList.setImmutable();
        int n = this.getSpecialLabel(-7);
        BasicBlock basicBlock = new BasicBlock(this.getSpecialLabel(-6), insnList, IntList.makeImmutable(n), n);
        this.addBlock(basicBlock, IntList.EMPTY);
        insnList = new InsnList(1);
        insn = new ThrowingInsn(Rops.THROW, sourcePosition, RegisterSpecList.make(registerSpec), StdTypeList.EMPTY);
        insnList.set(0, insn);
        insnList.setImmutable();
        basicBlock = new BasicBlock(n, insnList, IntList.EMPTY, -1);
        this.addBlock(basicBlock, IntList.EMPTY);
    }

    private void addExceptionSetupBlocks() {
        int n = this.catchInfos.length;
        for (int i = 0; i < n; ++i) {
            CatchInfo catchInfo = this.catchInfos[i];
            if (catchInfo == null) continue;
            for (ExceptionHandlerSetup exceptionHandlerSetup : catchInfo.getSetups()) {
                Insn insn = this.labelToBlock(i).getFirstInsn();
                SourcePosition sourcePosition = insn.getPosition();
                InsnList insnList = new InsnList(2);
                PlainInsn plainInsn = new PlainInsn(Rops.opMoveException(exceptionHandlerSetup.getCaughtType()), sourcePosition, RegisterSpec.make(this.maxLocals, exceptionHandlerSetup.getCaughtType()), RegisterSpecList.EMPTY);
                insnList.set(0, plainInsn);
                plainInsn = new PlainInsn(Rops.GOTO, sourcePosition, null, RegisterSpecList.EMPTY);
                insnList.set(1, plainInsn);
                insnList.setImmutable();
                BasicBlock basicBlock = new BasicBlock(exceptionHandlerSetup.getLabel(), insnList, IntList.makeImmutable(i), i);
                this.addBlock(basicBlock, this.startFrames[i].getSubroutines());
            }
        }
    }

    private boolean isSubroutineCaller(BasicBlock basicBlock) {
        IntList intList = basicBlock.getSuccessors();
        if (intList.size() < 2) {
            return false;
        }
        int n = intList.get(1);
        return n < this.subroutines.length && this.subroutines[n] != null;
    }

    private void inlineSubroutines() {
        int n;
        final IntList intList = new IntList(4);
        this.forEachNonSubBlockDepthFirst(0, new BasicBlock.Visitor(){

            public void visitBlock(BasicBlock basicBlock) {
                if (Ropper.this.isSubroutineCaller(basicBlock)) {
                    intList.add(basicBlock.getLabel());
                }
            }
        });
        int n2 = this.getAvailableLabel();
        ArrayList<IntList> arrayList = new ArrayList<IntList>(n2);
        for (n = 0; n < n2; ++n) {
            arrayList.add(null);
        }
        for (n = 0; n < this.result.size(); ++n) {
            BasicBlock basicBlock = this.result.get(n);
            if (basicBlock == null) continue;
            IntList intList2 = this.resultSubroutines.get(n);
            arrayList.set(basicBlock.getLabel(), intList2);
        }
        n = intList.size();
        for (int i = 0; i < n; ++i) {
            int n3 = intList.get(i);
            new SubroutineInliner(new LabelAllocator(this.getAvailableLabel()), arrayList).inlineSubroutineCalledFrom(this.labelToBlock(n3));
        }
        this.deleteUnreachableBlocks();
    }

    private void deleteUnreachableBlocks() {
        final IntList intList = new IntList(this.result.size());
        this.resultSubroutines.clear();
        this.forEachNonSubBlockDepthFirst(this.getSpecialLabel(-1), new BasicBlock.Visitor(){

            public void visitBlock(BasicBlock basicBlock) {
                intList.add(basicBlock.getLabel());
            }
        });
        intList.sort();
        for (int i = this.result.size() - 1; i >= 0; --i) {
            if (intList.indexOf(this.result.get(i).getLabel()) >= 0) continue;
            this.result.remove(i);
        }
    }

    private Subroutine subroutineFromRetBlock(int n) {
        for (int i = this.subroutines.length - 1; i >= 0; --i) {
            Subroutine subroutine;
            if (this.subroutines[i] == null || !(subroutine = this.subroutines[i]).retBlocks.get(n)) continue;
            return subroutine;
        }
        return null;
    }

    private InsnList filterMoveReturnAddressInsns(InsnList insnList) {
        int n = 0;
        int n2 = insnList.size();
        for (int i = 0; i < n2; ++i) {
            if (insnList.get(i).getOpcode() == Rops.MOVE_RETURN_ADDRESS) continue;
            ++n;
        }
        if (n == n2) {
            return insnList;
        }
        InsnList insnList2 = new InsnList(n);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Insn insn = insnList.get(i);
            if (insn.getOpcode() == Rops.MOVE_RETURN_ADDRESS) continue;
            insnList2.set(n3++, insn);
        }
        insnList2.setImmutable();
        return insnList2;
    }

    private void forEachNonSubBlockDepthFirst(int n, BasicBlock.Visitor visitor) {
        this.forEachNonSubBlockDepthFirst0(this.labelToBlock(n), visitor, new BitSet(this.maxLabel));
    }

    private void forEachNonSubBlockDepthFirst0(BasicBlock basicBlock, BasicBlock.Visitor visitor, BitSet bitSet) {
        visitor.visitBlock(basicBlock);
        bitSet.set(basicBlock.getLabel());
        IntList intList = basicBlock.getSuccessors();
        int n = intList.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = intList.get(i);
            if (bitSet.get(n3) || this.isSubroutineCaller(basicBlock) && i > 0 || (n2 = this.labelToResultIndex(n3)) < 0) continue;
            this.forEachNonSubBlockDepthFirst0(this.result.get(n2), visitor, bitSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubroutineInliner {
        private final HashMap<Integer, Integer> origLabelToCopiedLabel = new HashMap();
        private final BitSet workList;
        private int subroutineStart;
        private int subroutineSuccessor;
        private final LabelAllocator labelAllocator;
        private final ArrayList<IntList> labelToSubroutines;

        SubroutineInliner(LabelAllocator labelAllocator, ArrayList<IntList> arrayList) {
            this.workList = new BitSet(Ropper.this.maxLabel);
            this.labelAllocator = labelAllocator;
            this.labelToSubroutines = arrayList;
        }

        void inlineSubroutineCalledFrom(BasicBlock basicBlock) {
            this.subroutineSuccessor = basicBlock.getSuccessors().get(0);
            this.subroutineStart = basicBlock.getSuccessors().get(1);
            int n = this.mapOrAllocateLabel(this.subroutineStart);
            int n2 = this.workList.nextSetBit(0);
            while (n2 >= 0) {
                this.workList.clear(n2);
                int n3 = this.origLabelToCopiedLabel.get(n2);
                this.copyBlock(n2, n3);
                if (Ropper.this.isSubroutineCaller(Ropper.this.labelToBlock(n2))) {
                    new SubroutineInliner(this.labelAllocator, this.labelToSubroutines).inlineSubroutineCalledFrom(Ropper.this.labelToBlock(n3));
                }
                n2 = this.workList.nextSetBit(0);
            }
            Ropper.this.addOrReplaceBlockNoDelete(new BasicBlock(basicBlock.getLabel(), basicBlock.getInsns(), IntList.makeImmutable(n), n), this.labelToSubroutines.get(basicBlock.getLabel()));
        }

        private void copyBlock(int n, int n2) {
            IntList intList;
            BasicBlock basicBlock = Ropper.this.labelToBlock(n);
            IntList intList2 = basicBlock.getSuccessors();
            int n3 = -1;
            if (Ropper.this.isSubroutineCaller(basicBlock)) {
                intList = IntList.makeImmutable(this.mapOrAllocateLabel(intList2.get(0)), intList2.get(1));
            } else {
                Subroutine subroutine = Ropper.this.subroutineFromRetBlock(n);
                if (null != subroutine) {
                    if (subroutine.startBlock != this.subroutineStart) {
                        throw new RuntimeException("ret instruction returns to label " + Hex.u2(subroutine.startBlock) + " expected: " + Hex.u2(this.subroutineStart));
                    }
                    intList = IntList.makeImmutable(this.subroutineSuccessor);
                    n3 = this.subroutineSuccessor;
                } else {
                    int n4 = basicBlock.getPrimarySuccessor();
                    int n5 = intList2.size();
                    intList = new IntList(n5);
                    for (int i = 0; i < n5; ++i) {
                        int n6 = intList2.get(i);
                        int n7 = this.mapOrAllocateLabel(n6);
                        intList.add(n7);
                        if (n4 != n6) continue;
                        n3 = n7;
                    }
                    intList.setImmutable();
                }
            }
            Ropper.this.addBlock(new BasicBlock(n2, Ropper.this.filterMoveReturnAddressInsns(basicBlock.getInsns()), intList, n3), this.labelToSubroutines.get(n2));
        }

        private boolean involvedInSubroutine(int n, int n2) {
            IntList intList = this.labelToSubroutines.get(n);
            return intList != null && intList.size() > 0 && intList.top() == n2;
        }

        private int mapOrAllocateLabel(int n) {
            int n2;
            Integer n3 = this.origLabelToCopiedLabel.get(n);
            if (n3 != null) {
                n2 = n3;
            } else if (!this.involvedInSubroutine(n, this.subroutineStart)) {
                n2 = n;
            } else {
                n2 = this.labelAllocator.getNextLabel();
                this.workList.set(n);
                this.origLabelToCopiedLabel.put(n, n2);
                while (this.labelToSubroutines.size() <= n2) {
                    this.labelToSubroutines.add(null);
                }
                this.labelToSubroutines.set(n2, this.labelToSubroutines.get(n));
            }
            return n2;
        }
    }

    private class ExceptionSetupLabelAllocator
    extends LabelAllocator {
        int maxSetupLabel;

        ExceptionSetupLabelAllocator() {
            super(Ropper.this.maxLabel);
            this.maxSetupLabel = Ropper.this.maxLabel + Ropper.this.method.getCatches().size();
        }

        int getNextLabel() {
            if (this.nextAvailableLabel >= this.maxSetupLabel) {
                throw new IndexOutOfBoundsException();
            }
            return this.nextAvailableLabel++;
        }
    }

    private static class LabelAllocator {
        int nextAvailableLabel;

        LabelAllocator(int n) {
            this.nextAvailableLabel = n;
        }

        int getNextLabel() {
            return this.nextAvailableLabel++;
        }
    }

    private class Subroutine {
        private BitSet callerBlocks;
        private BitSet retBlocks;
        private int startBlock;

        Subroutine(int n) {
            this.startBlock = n;
            this.retBlocks = new BitSet(Ropper.this.maxLabel);
            this.callerBlocks = new BitSet(Ropper.this.maxLabel);
            Ropper.this.hasSubroutines = true;
        }

        Subroutine(int n, int n2) {
            this(n);
            this.addRetBlock(n2);
        }

        int getStartBlock() {
            return this.startBlock;
        }

        void addRetBlock(int n) {
            this.retBlocks.set(n);
        }

        void addCallerBlock(int n) {
            this.callerBlocks.set(n);
        }

        IntList getSuccessors() {
            IntList intList = new IntList(this.callerBlocks.size());
            int n = this.callerBlocks.nextSetBit(0);
            while (n >= 0) {
                BasicBlock basicBlock = Ropper.this.labelToBlock(n);
                intList.add(basicBlock.getSuccessors().get(0));
                n = this.callerBlocks.nextSetBit(n + 1);
            }
            intList.setImmutable();
            return intList;
        }

        void mergeToSuccessors(Frame frame, int[] nArray) {
            int n = this.callerBlocks.nextSetBit(0);
            while (n >= 0) {
                BasicBlock basicBlock = Ropper.this.labelToBlock(n);
                int n2 = basicBlock.getSuccessors().get(0);
                Frame frame2 = frame.subFrameForLabel(this.startBlock, n);
                if (frame2 != null) {
                    Ropper.this.mergeAndWorkAsNecessary(n2, -1, null, frame2, nArray);
                } else {
                    Bits.set(nArray, n);
                }
                n = this.callerBlocks.nextSetBit(n + 1);
            }
        }
    }

    private static class ExceptionHandlerSetup {
        private Type caughtType;
        private int label;

        ExceptionHandlerSetup(Type type, int n) {
            this.caughtType = type;
            this.label = n;
        }

        Type getCaughtType() {
            return this.caughtType;
        }

        public int getLabel() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CatchInfo {
        private final Map<Type, ExceptionHandlerSetup> setups = new HashMap<Type, ExceptionHandlerSetup>();

        private CatchInfo() {
        }

        ExceptionHandlerSetup getSetup(Type type) {
            ExceptionHandlerSetup exceptionHandlerSetup = this.setups.get(type);
            if (exceptionHandlerSetup == null) {
                int n = Ropper.this.exceptionSetupLabelAllocator.getNextLabel();
                exceptionHandlerSetup = new ExceptionHandlerSetup(type, n);
                this.setups.put(type, exceptionHandlerSetup);
            }
            return exceptionHandlerSetup;
        }

        Collection<ExceptionHandlerSetup> getSetups() {
            return this.setups.values();
        }
    }
}

