/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.cf.code.LocalsArray;
import com.android.dx.cf.code.LocalsArraySet;
import com.android.dx.cf.code.Merger;
import com.android.dx.cf.code.SimException;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.util.Hex;

public class OneLocalsArray
extends LocalsArray {
    private final TypeBearer[] locals;

    public OneLocalsArray(int n) {
        super(n != 0);
        this.locals = new TypeBearer[n];
    }

    public OneLocalsArray copy() {
        OneLocalsArray oneLocalsArray = new OneLocalsArray(this.locals.length);
        System.arraycopy(this.locals, 0, oneLocalsArray.locals, 0, this.locals.length);
        return oneLocalsArray;
    }

    public void annotate(ExceptionWithContext exceptionWithContext) {
        for (int i = 0; i < this.locals.length; ++i) {
            TypeBearer typeBearer = this.locals[i];
            String string = typeBearer == null ? "<invalid>" : typeBearer.toString();
            exceptionWithContext.addContext("locals[" + Hex.u2(i) + "]: " + string);
        }
    }

    public String toHuman() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.locals.length; ++i) {
            TypeBearer typeBearer = this.locals[i];
            String string = typeBearer == null ? "<invalid>" : typeBearer.toString();
            stringBuilder.append("locals[" + Hex.u2(i) + "]: " + string + "\n");
        }
        return stringBuilder.toString();
    }

    public void makeInitialized(Type type) {
        int n = this.locals.length;
        if (n == 0) {
            return;
        }
        this.throwIfImmutable();
        Type type2 = type.getInitializedType();
        for (int i = 0; i < n; ++i) {
            if (this.locals[i] != type) continue;
            this.locals[i] = type2;
        }
    }

    public int getMaxLocals() {
        return this.locals.length;
    }

    public void set(int n, TypeBearer typeBearer) {
        TypeBearer typeBearer2;
        this.throwIfImmutable();
        try {
            typeBearer = typeBearer.getFrameType();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("type == null");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("idx < 0");
        }
        if (typeBearer.getType().isCategory2()) {
            this.locals[n + 1] = null;
        }
        this.locals[n] = typeBearer;
        if (n != 0 && (typeBearer2 = this.locals[n - 1]) != null && typeBearer2.getType().isCategory2()) {
            this.locals[n - 1] = null;
        }
    }

    public void set(RegisterSpec registerSpec) {
        this.set(registerSpec.getReg(), registerSpec);
    }

    public void invalidate(int n) {
        this.throwIfImmutable();
        this.locals[n] = null;
    }

    public TypeBearer getOrNull(int n) {
        return this.locals[n];
    }

    public TypeBearer get(int n) {
        TypeBearer typeBearer = this.locals[n];
        if (typeBearer == null) {
            return OneLocalsArray.throwSimException(n, "invalid");
        }
        return typeBearer;
    }

    public TypeBearer getCategory1(int n) {
        TypeBearer typeBearer = this.get(n);
        Type type = typeBearer.getType();
        if (type.isUninitialized()) {
            return OneLocalsArray.throwSimException(n, "uninitialized instance");
        }
        if (type.isCategory2()) {
            return OneLocalsArray.throwSimException(n, "category-2");
        }
        return typeBearer;
    }

    public TypeBearer getCategory2(int n) {
        TypeBearer typeBearer = this.get(n);
        if (typeBearer.getType().isCategory1()) {
            return OneLocalsArray.throwSimException(n, "category-1");
        }
        return typeBearer;
    }

    public LocalsArray merge(LocalsArray localsArray) {
        if (localsArray instanceof OneLocalsArray) {
            return this.merge((OneLocalsArray)localsArray);
        }
        return localsArray.merge(this);
    }

    public OneLocalsArray merge(OneLocalsArray oneLocalsArray) {
        try {
            return Merger.mergeLocals(this, oneLocalsArray);
        }
        catch (SimException simException) {
            simException.addContext("underlay locals:");
            this.annotate(simException);
            simException.addContext("overlay locals:");
            oneLocalsArray.annotate(simException);
            throw simException;
        }
    }

    public LocalsArraySet mergeWithSubroutineCaller(LocalsArray localsArray, int n) {
        LocalsArraySet localsArraySet = new LocalsArraySet(this.getMaxLocals());
        return localsArraySet.mergeWithSubroutineCaller(localsArray, n);
    }

    protected OneLocalsArray getPrimary() {
        return this;
    }

    private static TypeBearer throwSimException(int n, String string) {
        throw new SimException("local " + Hex.u2(n) + ": " + string);
    }
}

