/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.cf.code.LocalsArray;
import com.android.dx.cf.code.OneLocalsArray;
import com.android.dx.cf.code.SimException;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.util.Hex;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalsArraySet
extends LocalsArray {
    private final OneLocalsArray primary;
    private final ArrayList<LocalsArray> secondaries;

    public LocalsArraySet(int n) {
        super(n != 0);
        this.primary = new OneLocalsArray(n);
        this.secondaries = new ArrayList();
    }

    public LocalsArraySet(OneLocalsArray oneLocalsArray, ArrayList<LocalsArray> arrayList) {
        super(oneLocalsArray.getMaxLocals() > 0);
        this.primary = oneLocalsArray;
        this.secondaries = arrayList;
    }

    private LocalsArraySet(LocalsArraySet localsArraySet) {
        super(localsArraySet.getMaxLocals() > 0);
        this.primary = localsArraySet.primary.copy();
        this.secondaries = new ArrayList(localsArraySet.secondaries.size());
        int n = localsArraySet.secondaries.size();
        for (int i = 0; i < n; ++i) {
            LocalsArray localsArray = localsArraySet.secondaries.get(i);
            if (localsArray == null) {
                this.secondaries.add(null);
                continue;
            }
            this.secondaries.add(localsArray.copy());
        }
    }

    @Override
    public void setImmutable() {
        this.primary.setImmutable();
        for (LocalsArray localsArray : this.secondaries) {
            if (localsArray == null) continue;
            localsArray.setImmutable();
        }
        super.setImmutable();
    }

    @Override
    public LocalsArray copy() {
        return new LocalsArraySet(this);
    }

    @Override
    public void annotate(ExceptionWithContext exceptionWithContext) {
        exceptionWithContext.addContext("(locals array set; primary)");
        this.primary.annotate(exceptionWithContext);
        int n = this.secondaries.size();
        for (int i = 0; i < n; ++i) {
            LocalsArray localsArray = this.secondaries.get(i);
            if (localsArray == null) continue;
            exceptionWithContext.addContext("(locals array set: primary for caller " + Hex.u2(i) + ')');
            localsArray.getPrimary().annotate(exceptionWithContext);
        }
    }

    @Override
    public String toHuman() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(locals array set; primary)\n");
        stringBuilder.append(this.getPrimary().toHuman());
        stringBuilder.append('\n');
        int n = this.secondaries.size();
        for (int i = 0; i < n; ++i) {
            LocalsArray localsArray = this.secondaries.get(i);
            if (localsArray == null) continue;
            stringBuilder.append("(locals array set: primary for caller " + Hex.u2(i) + ")\n");
            stringBuilder.append(localsArray.getPrimary().toHuman());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public void makeInitialized(Type type) {
        int n = this.primary.getMaxLocals();
        if (n == 0) {
            return;
        }
        this.throwIfImmutable();
        this.primary.makeInitialized(type);
        for (LocalsArray localsArray : this.secondaries) {
            if (localsArray == null) continue;
            localsArray.makeInitialized(type);
        }
    }

    @Override
    public int getMaxLocals() {
        return this.primary.getMaxLocals();
    }

    @Override
    public void set(int n, TypeBearer typeBearer) {
        this.throwIfImmutable();
        this.primary.set(n, typeBearer);
        for (LocalsArray localsArray : this.secondaries) {
            if (localsArray == null) continue;
            localsArray.set(n, typeBearer);
        }
    }

    @Override
    public void set(RegisterSpec registerSpec) {
        this.set(registerSpec.getReg(), registerSpec);
    }

    @Override
    public void invalidate(int n) {
        this.throwIfImmutable();
        this.primary.invalidate(n);
        for (LocalsArray localsArray : this.secondaries) {
            if (localsArray == null) continue;
            localsArray.invalidate(n);
        }
    }

    @Override
    public TypeBearer getOrNull(int n) {
        return this.primary.getOrNull(n);
    }

    @Override
    public TypeBearer get(int n) {
        return this.primary.get(n);
    }

    @Override
    public TypeBearer getCategory1(int n) {
        return this.primary.getCategory1(n);
    }

    @Override
    public TypeBearer getCategory2(int n) {
        return this.primary.getCategory2(n);
    }

    private LocalsArraySet mergeWithSet(LocalsArraySet localsArraySet) {
        boolean bl = false;
        OneLocalsArray oneLocalsArray = this.primary.merge(localsArraySet.getPrimary());
        int n = this.secondaries.size();
        int n2 = localsArraySet.secondaries.size();
        int n3 = Math.max(n, n2);
        ArrayList<LocalsArray> arrayList = new ArrayList<LocalsArray>(n3);
        for (int i = 0; i < n3; ++i) {
            LocalsArray localsArray = i < n ? this.secondaries.get(i) : null;
            LocalsArray localsArray2 = i < n2 ? localsArraySet.secondaries.get(i) : null;
            LocalsArray localsArray3 = null;
            if (localsArray == localsArray2) {
                localsArray3 = localsArray;
            } else if (localsArray == null) {
                localsArray3 = localsArray2;
            } else if (localsArray2 == null) {
                localsArray3 = localsArray;
            } else {
                try {
                    localsArray3 = localsArray.merge(localsArray2);
                }
                catch (SimException simException) {
                    simException.addContext("Merging locals set for caller block " + Hex.u2(i));
                }
            }
            bl = bl || localsArray != localsArray3;
            arrayList.add(localsArray3);
        }
        if (this.primary == oneLocalsArray && !bl) {
            return this;
        }
        return new LocalsArraySet(oneLocalsArray, arrayList);
    }

    private LocalsArraySet mergeWithOne(OneLocalsArray oneLocalsArray) {
        boolean bl = false;
        OneLocalsArray oneLocalsArray2 = this.primary.merge(oneLocalsArray.getPrimary());
        ArrayList<LocalsArray> arrayList = new ArrayList<LocalsArray>(this.secondaries.size());
        int n = this.secondaries.size();
        for (int i = 0; i < n; ++i) {
            LocalsArray localsArray = this.secondaries.get(i);
            LocalsArray localsArray2 = null;
            if (localsArray != null) {
                try {
                    localsArray2 = localsArray.merge(oneLocalsArray);
                }
                catch (SimException simException) {
                    simException.addContext("Merging one locals against caller block " + Hex.u2(i));
                }
            }
            bl = bl || localsArray != localsArray2;
            arrayList.add(localsArray2);
        }
        if (this.primary == oneLocalsArray2 && !bl) {
            return this;
        }
        return new LocalsArraySet(oneLocalsArray2, arrayList);
    }

    @Override
    public LocalsArraySet merge(LocalsArray localsArray) {
        LocalsArraySet localsArraySet;
        try {
            localsArraySet = localsArray instanceof LocalsArraySet ? this.mergeWithSet((LocalsArraySet)localsArray) : this.mergeWithOne((OneLocalsArray)localsArray);
        }
        catch (SimException simException) {
            simException.addContext("underlay locals:");
            this.annotate(simException);
            simException.addContext("overlay locals:");
            localsArray.annotate(simException);
            throw simException;
        }
        localsArraySet.setImmutable();
        return localsArraySet;
    }

    private LocalsArray getSecondaryForLabel(int n) {
        if (n >= this.secondaries.size()) {
            return null;
        }
        return this.secondaries.get(n);
    }

    @Override
    public LocalsArraySet mergeWithSubroutineCaller(LocalsArray localsArray, int n) {
        LocalsArray localsArray2 = this.getSecondaryForLabel(n);
        OneLocalsArray oneLocalsArray = this.primary.merge(localsArray.getPrimary());
        LocalsArray localsArray3 = localsArray2 == localsArray ? localsArray2 : (localsArray2 == null ? localsArray : localsArray2.merge(localsArray));
        if (localsArray3 == localsArray2 && oneLocalsArray == this.primary) {
            return this;
        }
        oneLocalsArray = null;
        int n2 = this.secondaries.size();
        int n3 = Math.max(n + 1, n2);
        ArrayList<LocalsArray> arrayList = new ArrayList<LocalsArray>(n3);
        for (int i = 0; i < n3; ++i) {
            LocalsArray localsArray4 = null;
            if (i == n) {
                localsArray4 = localsArray3;
            } else if (i < n2) {
                localsArray4 = this.secondaries.get(i);
            }
            if (localsArray4 != null) {
                oneLocalsArray = oneLocalsArray == null ? localsArray4.getPrimary() : oneLocalsArray.merge(localsArray4.getPrimary());
            }
            arrayList.add(localsArray4);
        }
        LocalsArraySet localsArraySet = new LocalsArraySet(oneLocalsArray, arrayList);
        localsArraySet.setImmutable();
        return localsArraySet;
    }

    public LocalsArray subArrayForLabel(int n) {
        LocalsArray localsArray = this.getSecondaryForLabel(n);
        return localsArray;
    }

    @Override
    protected OneLocalsArray getPrimary() {
        return this.primary;
    }
}

