/*
 * Decompiled with CFR 0.152.
 */
package com.android.dex;

import com.android.dex.Annotation;
import com.android.dex.ClassData;
import com.android.dex.ClassDef;
import com.android.dex.Code;
import com.android.dex.DexException;
import com.android.dex.EncodedValue;
import com.android.dex.EncodedValueReader;
import com.android.dex.FieldId;
import com.android.dex.Leb128;
import com.android.dex.MethodId;
import com.android.dex.Mutf8;
import com.android.dex.ProtoId;
import com.android.dex.TableOfContents;
import com.android.dex.TypeList;
import com.android.dex.util.ByteInput;
import com.android.dex.util.ByteOutput;
import com.android.dex.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.zip.Adler32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dex {
    private static final int CHECKSUM_OFFSET = 8;
    private static final int CHECKSUM_SIZE = 4;
    private static final int SIGNATURE_OFFSET = 12;
    private static final int SIGNATURE_SIZE = 20;
    static final short[] EMPTY_SHORT_ARRAY = new short[0];
    private ByteBuffer data;
    private final TableOfContents tableOfContents = new TableOfContents();
    private int nextSectionStart = 0;
    private final StringTable strings = new StringTable();
    private final TypeIndexToDescriptorIndexTable typeIds = new TypeIndexToDescriptorIndexTable();
    private final TypeIndexToDescriptorTable typeNames = new TypeIndexToDescriptorTable();
    private final ProtoIdTable protoIds = new ProtoIdTable();
    private final FieldIdTable fieldIds = new FieldIdTable();
    private final MethodIdTable methodIds = new MethodIdTable();

    public Dex(byte[] byArray) throws IOException {
        this(ByteBuffer.wrap(byArray));
    }

    private Dex(ByteBuffer byteBuffer) throws IOException {
        this.data = byteBuffer;
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.tableOfContents.readFrom(this);
    }

    public Dex(int n) throws IOException {
        this.data = ByteBuffer.wrap(new byte[n]);
        this.data.order(ByteOrder.LITTLE_ENDIAN);
    }

    public Dex(InputStream inputStream) throws IOException {
        this.loadFrom(inputStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Dex(File file) throws IOException {
        if (FileUtils.hasArchiveSuffix(file.getName())) {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("classes.dex");
            if (zipEntry == null) throw new DexException("Expected classes.dex in " + file);
            this.loadFrom(zipFile.getInputStream(zipEntry));
            zipFile.close();
            return;
        } else {
            if (!file.getName().endsWith(".dex")) throw new DexException("unknown output extension: " + file);
            this.loadFrom(new FileInputStream(file));
        }
    }

    public static Dex create(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (byteBuffer.get(0) == 100 && byteBuffer.get(1) == 101 && byteBuffer.get(2) == 121 && byteBuffer.get(3) == 10) {
            byteBuffer.position(8);
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            byteBuffer.position(n);
            byteBuffer.limit(n + n2);
            byteBuffer = byteBuffer.slice();
        }
        return new Dex(byteBuffer);
    }

    private void loadFrom(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        this.data = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.tableOfContents.readFrom(this);
    }

    private static void checkBounds(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("index:" + n + ", length=" + n2);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8192];
        ByteBuffer byteBuffer = this.data.duplicate();
        byteBuffer.clear();
        while (byteBuffer.hasRemaining()) {
            int n = Math.min(byArray.length, byteBuffer.remaining());
            byteBuffer.get(byArray, 0, n);
            outputStream.write(byArray, 0, n);
        }
    }

    public void writeTo(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.writeTo(fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public TableOfContents getTableOfContents() {
        return this.tableOfContents;
    }

    public Section open(int n) {
        if (n < 0 || n >= this.data.capacity()) {
            throw new IllegalArgumentException("position=" + n + " length=" + this.data.capacity());
        }
        ByteBuffer byteBuffer = this.data.duplicate();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(n);
        byteBuffer.limit(this.data.capacity());
        return new Section("section", byteBuffer);
    }

    public Section appendSection(int n, String string) {
        if ((n & 3) != 0) {
            throw new IllegalStateException("Not four byte aligned!");
        }
        int n2 = this.nextSectionStart + n;
        ByteBuffer byteBuffer = this.data.duplicate();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(this.nextSectionStart);
        byteBuffer.limit(n2);
        Section section = new Section(string, byteBuffer);
        this.nextSectionStart = n2;
        return section;
    }

    public int getLength() {
        return this.data.capacity();
    }

    public int getNextSectionStart() {
        return this.nextSectionStart;
    }

    public byte[] getBytes() {
        ByteBuffer byteBuffer = this.data.duplicate();
        byte[] byArray = new byte[byteBuffer.capacity()];
        byteBuffer.position(0);
        byteBuffer.get(byArray);
        return byArray;
    }

    public List<String> strings() {
        return this.strings;
    }

    public List<Integer> typeIds() {
        return this.typeIds;
    }

    public List<String> typeNames() {
        return this.typeNames;
    }

    public List<ProtoId> protoIds() {
        return this.protoIds;
    }

    public List<FieldId> fieldIds() {
        return this.fieldIds;
    }

    public List<MethodId> methodIds() {
        return this.methodIds;
    }

    public Iterable<ClassDef> classDefs() {
        return new ClassDefIterable();
    }

    public TypeList readTypeList(int n) {
        if (n == 0) {
            return TypeList.EMPTY;
        }
        return this.open(n).readTypeList();
    }

    public ClassData readClassData(ClassDef classDef) {
        int n = classDef.getClassDataOffset();
        if (n == 0) {
            throw new IllegalArgumentException("offset == 0");
        }
        return this.open(n).readClassData();
    }

    public Code readCode(ClassData.Method method) {
        int n = method.getCodeOffset();
        if (n == 0) {
            throw new IllegalArgumentException("offset == 0");
        }
        return this.open(n).readCode();
    }

    public byte[] computeSignature() throws IOException {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        byte[] byArray = new byte[8192];
        ByteBuffer byteBuffer = this.data.duplicate();
        byteBuffer.limit(byteBuffer.capacity());
        byteBuffer.position(32);
        while (byteBuffer.hasRemaining()) {
            int n = Math.min(byArray.length, byteBuffer.remaining());
            byteBuffer.get(byArray, 0, n);
            messageDigest.update(byArray, 0, n);
        }
        return messageDigest.digest();
    }

    public int computeChecksum() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byArray = new byte[8192];
        ByteBuffer byteBuffer = this.data.duplicate();
        byteBuffer.limit(byteBuffer.capacity());
        byteBuffer.position(12);
        while (byteBuffer.hasRemaining()) {
            int n = Math.min(byArray.length, byteBuffer.remaining());
            byteBuffer.get(byArray, 0, n);
            adler32.update(byArray, 0, n);
        }
        return (int)adler32.getValue();
    }

    public void writeHashes() throws IOException {
        this.open(12).write(this.computeSignature());
        this.open(8).writeInt(this.computeChecksum());
    }

    public int nameIndexFromFieldIndex(int n) {
        Dex.checkBounds(n, this.tableOfContents.fieldIds.size);
        int n2 = this.tableOfContents.fieldIds.off + 8 * n;
        n2 += 2;
        return this.data.getInt(n2 += 2);
    }

    public int findStringIndex(String string) {
        return Collections.binarySearch(this.strings, string);
    }

    public int findTypeIndex(String string) {
        return Collections.binarySearch(this.typeNames, string);
    }

    public int findFieldIndex(FieldId fieldId) {
        return Collections.binarySearch(this.fieldIds, fieldId);
    }

    public int findMethodIndex(MethodId methodId) {
        return Collections.binarySearch(this.methodIds, methodId);
    }

    public int findClassDefIndexFromTypeIndex(int n) {
        Dex.checkBounds(n, this.tableOfContents.typeIds.size);
        if (!this.tableOfContents.classDefs.exists()) {
            return -1;
        }
        for (int i = 0; i < this.tableOfContents.classDefs.size; ++i) {
            if (this.typeIndexFromClassDefIndex(i) != n) continue;
            return i;
        }
        return -1;
    }

    public int typeIndexFromFieldIndex(int n) {
        Dex.checkBounds(n, this.tableOfContents.fieldIds.size);
        int n2 = this.tableOfContents.fieldIds.off + 8 * n;
        return this.data.getShort(n2 += 2) & 0xFFFF;
    }

    public int declaringClassIndexFromMethodIndex(int n) {
        Dex.checkBounds(n, this.tableOfContents.methodIds.size);
        int n2 = this.tableOfContents.methodIds.off + 8 * n;
        return this.data.getShort(n2) & 0xFFFF;
    }

    public int nameIndexFromMethodIndex(int n) {
        Dex.checkBounds(n, this.tableOfContents.methodIds.size);
        int n2 = this.tableOfContents.methodIds.off + 8 * n;
        n2 += 2;
        return this.data.getInt(n2 += 2);
    }

    public short[] parameterTypeIndicesFromMethodIndex(int n) {
        Dex.checkBounds(n, this.tableOfContents.methodIds.size);
        int n2 = this.tableOfContents.methodIds.off + 8 * n;
        int n3 = this.data.getShort(n2 += 2) & 0xFFFF;
        Dex.checkBounds(n3, this.tableOfContents.protoIds.size);
        n2 = this.tableOfContents.protoIds.off + 12 * n3;
        n2 += 4;
        int n4 = this.data.getInt(n2 += 4);
        if (n4 == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        n2 = n4;
        int n5 = this.data.getInt(n2);
        if (n5 <= 0) {
            throw new AssertionError((Object)("Unexpected parameter type list size: " + n5));
        }
        n2 += 4;
        short[] sArray = new short[n5];
        for (int i = 0; i < n5; ++i) {
            sArray[i] = this.data.getShort(n2);
            n2 += 2;
        }
        return sArray;
    }

    public int returnTypeIndexFromMethodIndex(int n) {
        Dex.checkBounds(n, this.tableOfContents.methodIds.size);
        int n2 = this.tableOfContents.methodIds.off + 8 * n;
        int n3 = this.data.getShort(n2 += 2) & 0xFFFF;
        Dex.checkBounds(n3, this.tableOfContents.protoIds.size);
        n2 = this.tableOfContents.protoIds.off + 12 * n3;
        return this.data.getInt(n2 += 4);
    }

    public int descriptorIndexFromTypeIndex(int n) {
        Dex.checkBounds(n, this.tableOfContents.typeIds.size);
        int n2 = this.tableOfContents.typeIds.off + 4 * n;
        return this.data.getInt(n2);
    }

    public int typeIndexFromClassDefIndex(int n) {
        Dex.checkBounds(n, this.tableOfContents.classDefs.size);
        int n2 = this.tableOfContents.classDefs.off + 32 * n;
        return this.data.getInt(n2);
    }

    public int annotationDirectoryOffsetFromClassDefIndex(int n) {
        Dex.checkBounds(n, this.tableOfContents.classDefs.size);
        int n2 = this.tableOfContents.classDefs.off + 32 * n;
        n2 += 4;
        n2 += 4;
        n2 += 4;
        n2 += 4;
        return this.data.getInt(n2 += 4);
    }

    public short[] interfaceTypeIndicesFromClassDefIndex(int n) {
        Dex.checkBounds(n, this.tableOfContents.classDefs.size);
        int n2 = this.tableOfContents.classDefs.off + 32 * n;
        n2 += 4;
        n2 += 4;
        int n3 = this.data.getInt(n2 += 4);
        if (n3 == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        n2 = n3;
        int n4 = this.data.getInt(n2);
        if (n4 <= 0) {
            throw new AssertionError((Object)("Unexpected interfaces list size: " + n4));
        }
        n2 += 4;
        short[] sArray = new short[n4];
        for (int i = 0; i < n4; ++i) {
            sArray[i] = this.data.getShort(n2);
            n2 += 2;
        }
        return sArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassDefIterable
    implements Iterable<ClassDef> {
        private ClassDefIterable() {
        }

        @Override
        public Iterator<ClassDef> iterator() {
            return !((Dex)Dex.this).tableOfContents.classDefs.exists() ? Collections.emptySet().iterator() : new ClassDefIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassDefIterator
    implements Iterator<ClassDef> {
        private final Section in;
        private int count;

        private ClassDefIterator() {
            this.in = Dex.this.open(((Dex)Dex.this).tableOfContents.classDefs.off);
            this.count = 0;
        }

        @Override
        public boolean hasNext() {
            return this.count < ((Dex)Dex.this).tableOfContents.classDefs.size;
        }

        @Override
        public ClassDef next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            return this.in.readClassDef();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MethodIdTable
    extends AbstractList<MethodId>
    implements RandomAccess {
        private MethodIdTable() {
        }

        @Override
        public MethodId get(int n) {
            Dex.checkBounds(n, ((Dex)Dex.this).tableOfContents.methodIds.size);
            return Dex.this.open(((Dex)Dex.this).tableOfContents.methodIds.off + 8 * n).readMethodId();
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.methodIds.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FieldIdTable
    extends AbstractList<FieldId>
    implements RandomAccess {
        private FieldIdTable() {
        }

        @Override
        public FieldId get(int n) {
            Dex.checkBounds(n, ((Dex)Dex.this).tableOfContents.fieldIds.size);
            return Dex.this.open(((Dex)Dex.this).tableOfContents.fieldIds.off + 8 * n).readFieldId();
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.fieldIds.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProtoIdTable
    extends AbstractList<ProtoId>
    implements RandomAccess {
        private ProtoIdTable() {
        }

        @Override
        public ProtoId get(int n) {
            Dex.checkBounds(n, ((Dex)Dex.this).tableOfContents.protoIds.size);
            return Dex.this.open(((Dex)Dex.this).tableOfContents.protoIds.off + 12 * n).readProtoId();
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.protoIds.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TypeIndexToDescriptorTable
    extends AbstractList<String>
    implements RandomAccess {
        private TypeIndexToDescriptorTable() {
        }

        @Override
        public String get(int n) {
            return Dex.this.strings.get(Dex.this.descriptorIndexFromTypeIndex(n));
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.typeIds.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TypeIndexToDescriptorIndexTable
    extends AbstractList<Integer>
    implements RandomAccess {
        private TypeIndexToDescriptorIndexTable() {
        }

        @Override
        public Integer get(int n) {
            return Dex.this.descriptorIndexFromTypeIndex(n);
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.typeIds.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class StringTable
    extends AbstractList<String>
    implements RandomAccess {
        private StringTable() {
        }

        @Override
        public String get(int n) {
            Dex.checkBounds(n, ((Dex)Dex.this).tableOfContents.stringIds.size);
            return Dex.this.open(((Dex)Dex.this).tableOfContents.stringIds.off + n * 4).readString();
        }

        @Override
        public int size() {
            return ((Dex)Dex.this).tableOfContents.stringIds.size;
        }
    }

    public final class Section
    implements ByteInput,
    ByteOutput {
        private final String name;
        private final ByteBuffer data;
        private final int initialPosition;

        private Section(String string, ByteBuffer byteBuffer) {
            this.name = string;
            this.data = byteBuffer;
            this.initialPosition = byteBuffer.position();
        }

        public int getPosition() {
            return this.data.position();
        }

        public int readInt() {
            return this.data.getInt();
        }

        public short readShort() {
            return this.data.getShort();
        }

        public int readUnsignedShort() {
            return this.readShort() & 0xFFFF;
        }

        public byte readByte() {
            return this.data.get();
        }

        public byte[] readByteArray(int n) {
            byte[] byArray = new byte[n];
            this.data.get(byArray);
            return byArray;
        }

        public short[] readShortArray(int n) {
            if (n == 0) {
                return EMPTY_SHORT_ARRAY;
            }
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = this.readShort();
            }
            return sArray;
        }

        public int readUleb128() {
            return Leb128.readUnsignedLeb128(this);
        }

        public int readUleb128p1() {
            return Leb128.readUnsignedLeb128(this) - 1;
        }

        public int readSleb128() {
            return Leb128.readSignedLeb128(this);
        }

        public void writeUleb128p1(int n) {
            this.writeUleb128(n + 1);
        }

        public TypeList readTypeList() {
            int n = this.readInt();
            short[] sArray = this.readShortArray(n);
            this.alignToFourBytes();
            return new TypeList(Dex.this, sArray);
        }

        public String readString() {
            int n = this.readInt();
            int n2 = this.data.position();
            int n3 = this.data.limit();
            this.data.position(n);
            this.data.limit(this.data.capacity());
            try {
                int n4 = this.readUleb128();
                String string = Mutf8.decode(this, new char[n4]);
                if (string.length() != n4) {
                    throw new DexException("Declared length " + n4 + " doesn't match decoded length of " + string.length());
                }
                String string2 = string;
                return string2;
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                throw new DexException(uTFDataFormatException);
            }
            finally {
                this.data.position(n2);
                this.data.limit(n3);
            }
        }

        public FieldId readFieldId() {
            int n = this.readUnsignedShort();
            int n2 = this.readUnsignedShort();
            int n3 = this.readInt();
            return new FieldId(Dex.this, n, n2, n3);
        }

        public MethodId readMethodId() {
            int n = this.readUnsignedShort();
            int n2 = this.readUnsignedShort();
            int n3 = this.readInt();
            return new MethodId(Dex.this, n, n2, n3);
        }

        public ProtoId readProtoId() {
            int n = this.readInt();
            int n2 = this.readInt();
            int n3 = this.readInt();
            return new ProtoId(Dex.this, n, n2, n3);
        }

        public ClassDef readClassDef() {
            int n = this.getPosition();
            int n2 = this.readInt();
            int n3 = this.readInt();
            int n4 = this.readInt();
            int n5 = this.readInt();
            int n6 = this.readInt();
            int n7 = this.readInt();
            int n8 = this.readInt();
            int n9 = this.readInt();
            return new ClassDef(Dex.this, n, n2, n3, n4, n5, n6, n7, n8, n9);
        }

        private Code readCode() {
            Code.Try[] tryArray;
            Code.CatchHandler[] catchHandlerArray;
            int n = this.readUnsignedShort();
            int n2 = this.readUnsignedShort();
            int n3 = this.readUnsignedShort();
            int n4 = this.readUnsignedShort();
            int n5 = this.readInt();
            int n6 = this.readInt();
            short[] sArray = this.readShortArray(n6);
            if (n4 > 0) {
                if (sArray.length % 2 == 1) {
                    this.readShort();
                }
                Section section = Dex.this.open(this.data.position());
                this.skip(n4 * 8);
                catchHandlerArray = this.readCatchHandlers();
                tryArray = section.readTries(n4, catchHandlerArray);
            } else {
                tryArray = new Code.Try[]{};
                catchHandlerArray = new Code.CatchHandler[]{};
            }
            return new Code(n, n2, n3, n5, sArray, tryArray, catchHandlerArray);
        }

        private Code.CatchHandler[] readCatchHandlers() {
            int n = this.data.position();
            int n2 = this.readUleb128();
            Code.CatchHandler[] catchHandlerArray = new Code.CatchHandler[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = this.data.position() - n;
                catchHandlerArray[i] = this.readCatchHandler(n3);
            }
            return catchHandlerArray;
        }

        private Code.Try[] readTries(int n, Code.CatchHandler[] catchHandlerArray) {
            Code.Try[] tryArray = new Code.Try[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.readInt();
                int n3 = this.readUnsignedShort();
                int n4 = this.readUnsignedShort();
                int n5 = this.findCatchHandlerIndex(catchHandlerArray, n4);
                tryArray[i] = new Code.Try(n2, n3, n5);
            }
            return tryArray;
        }

        private int findCatchHandlerIndex(Code.CatchHandler[] catchHandlerArray, int n) {
            for (int i = 0; i < catchHandlerArray.length; ++i) {
                Code.CatchHandler catchHandler = catchHandlerArray[i];
                if (catchHandler.getOffset() != n) continue;
                return i;
            }
            throw new IllegalArgumentException();
        }

        private Code.CatchHandler readCatchHandler(int n) {
            int n2;
            int n3 = this.readSleb128();
            int n4 = Math.abs(n3);
            int[] nArray = new int[n4];
            int[] nArray2 = new int[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                nArray[n2] = this.readUleb128();
                nArray2[n2] = this.readUleb128();
            }
            n2 = n3 <= 0 ? this.readUleb128() : -1;
            return new Code.CatchHandler(nArray, nArray2, n2, n);
        }

        private ClassData readClassData() {
            int n = this.readUleb128();
            int n2 = this.readUleb128();
            int n3 = this.readUleb128();
            int n4 = this.readUleb128();
            ClassData.Field[] fieldArray = this.readFields(n);
            ClassData.Field[] fieldArray2 = this.readFields(n2);
            ClassData.Method[] methodArray = this.readMethods(n3);
            ClassData.Method[] methodArray2 = this.readMethods(n4);
            return new ClassData(fieldArray, fieldArray2, methodArray, methodArray2);
        }

        private ClassData.Field[] readFields(int n) {
            ClassData.Field[] fieldArray = new ClassData.Field[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = this.readUleb128();
                fieldArray[i] = new ClassData.Field(n2 += this.readUleb128(), n3);
            }
            return fieldArray;
        }

        private ClassData.Method[] readMethods(int n) {
            ClassData.Method[] methodArray = new ClassData.Method[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = this.readUleb128();
                int n4 = this.readUleb128();
                methodArray[i] = new ClassData.Method(n2 += this.readUleb128(), n3, n4);
            }
            return methodArray;
        }

        private byte[] getBytesFrom(int n) {
            int n2 = this.data.position();
            byte[] byArray = new byte[n2 - n];
            this.data.position(n);
            this.data.get(byArray);
            return byArray;
        }

        public Annotation readAnnotation() {
            byte by = this.readByte();
            int n = this.data.position();
            new EncodedValueReader(this, 29).skipValue();
            return new Annotation(Dex.this, by, new EncodedValue(this.getBytesFrom(n)));
        }

        public EncodedValue readEncodedArray() {
            int n = this.data.position();
            new EncodedValueReader(this, 28).skipValue();
            return new EncodedValue(this.getBytesFrom(n));
        }

        public void skip(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.data.position(this.data.position() + n);
        }

        public void alignToFourBytes() {
            this.data.position(this.data.position() + 3 & 0xFFFFFFFC);
        }

        public void alignToFourBytesWithZeroFill() {
            while ((this.data.position() & 3) != 0) {
                this.data.put((byte)0);
            }
        }

        public void assertFourByteAligned() {
            if ((this.data.position() & 3) != 0) {
                throw new IllegalStateException("Not four byte aligned!");
            }
        }

        public void write(byte[] byArray) {
            this.data.put(byArray);
        }

        public void writeByte(int n) {
            this.data.put((byte)n);
        }

        public void writeShort(short s) {
            this.data.putShort(s);
        }

        public void writeUnsignedShort(int n) {
            short s = (short)n;
            if (n != (s & 0xFFFF)) {
                throw new IllegalArgumentException("Expected an unsigned short: " + n);
            }
            this.writeShort(s);
        }

        public void write(short[] sArray) {
            for (short s : sArray) {
                this.writeShort(s);
            }
        }

        public void writeInt(int n) {
            this.data.putInt(n);
        }

        public void writeUleb128(int n) {
            try {
                Leb128.writeUnsignedLeb128(this, n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new DexException("Section limit " + this.data.limit() + " exceeded by " + this.name);
            }
        }

        public void writeSleb128(int n) {
            try {
                Leb128.writeSignedLeb128(this, n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new DexException("Section limit " + this.data.limit() + " exceeded by " + this.name);
            }
        }

        public void writeStringData(String string) {
            try {
                int n = string.length();
                this.writeUleb128(n);
                this.write(Mutf8.encode(string));
                this.writeByte(0);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                throw new AssertionError();
            }
        }

        public void writeTypeList(TypeList typeList) {
            short[] sArray = typeList.getTypes();
            this.writeInt(sArray.length);
            for (short s : sArray) {
                this.writeShort(s);
            }
            this.alignToFourBytesWithZeroFill();
        }

        public int remaining() {
            return this.data.remaining();
        }

        public int used() {
            return this.data.position() - this.initialPosition;
        }
    }
}

