/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.signedness;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.checkerframework.checker.signedness.qual.Unsigned;

public final class SignednessUtil {
    private SignednessUtil() {
        throw new Error("Do not instantiate");
    }

    public static ByteBuffer wrapUnsigned(@Unsigned byte[] array) {
        return ByteBuffer.wrap(array);
    }

    public static ByteBuffer wrapUnsigned(@Unsigned byte[] array, int offset, int length) {
        return ByteBuffer.wrap(array, offset, length);
    }

    public static @Unsigned int getUnsignedInt(ByteBuffer b4) {
        return b4.getInt();
    }

    public static @Unsigned short getUnsignedShort(ByteBuffer b4) {
        return b4.getShort();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer b4) {
        return b4.get();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer b4, int i4) {
        return b4.get(i4);
    }

    public static ByteBuffer getUnsigned(ByteBuffer b4, byte[] bs, int i4, int l4) {
        return b4.get(bs, i4, l4);
    }

    public static ByteBuffer putUnsigned(ByteBuffer b4, @Unsigned byte ubyte) {
        return b4.put(ubyte);
    }

    public static ByteBuffer putUnsigned(ByteBuffer b4, int i4, @Unsigned byte ubyte) {
        return b4.put(i4, ubyte);
    }

    public static IntBuffer putUnsigned(IntBuffer b4, @Unsigned int uint) {
        return b4.put(uint);
    }

    public static IntBuffer putUnsigned(IntBuffer b4, int i4, @Unsigned int uint) {
        return b4.put(i4, uint);
    }

    public static IntBuffer putUnsigned(IntBuffer b4, @Unsigned int[] uints) {
        return b4.put(uints);
    }

    public static IntBuffer putUnsigned(IntBuffer b4, @Unsigned int[] uints, int i4, int l4) {
        return b4.put(uints, i4, l4);
    }

    public static @Unsigned int getUnsigned(IntBuffer b4, int i4) {
        return b4.get(i4);
    }

    public static ByteBuffer putUnsignedShort(ByteBuffer b4, @Unsigned short ushort) {
        return b4.putShort(ushort);
    }

    public static ByteBuffer putUnsignedShort(ByteBuffer b4, int i4, @Unsigned short ushort) {
        return b4.putShort(i4, ushort);
    }

    public static ByteBuffer putUnsignedInt(ByteBuffer b4, @Unsigned int uint) {
        return b4.putInt(uint);
    }

    public static ByteBuffer putUnsignedInt(ByteBuffer b4, int i4, @Unsigned int uint) {
        return b4.putInt(i4, uint);
    }

    public static ByteBuffer putUnsignedLong(ByteBuffer b4, int i4, @Unsigned long ulong) {
        return b4.putLong(i4, ulong);
    }

    public static @Unsigned char readUnsignedChar(RandomAccessFile f4) throws IOException {
        return f4.readChar();
    }

    public static @Unsigned int readUnsignedInt(RandomAccessFile f4) throws IOException {
        return f4.readInt();
    }

    public static @Unsigned long readUnsignedLong(RandomAccessFile f4) throws IOException {
        return f4.readLong();
    }

    public static int readUnsigned(RandomAccessFile f4, @Unsigned byte[] b4, int off, int len) throws IOException {
        return f4.read(b4, off, len);
    }

    public static void readFullyUnsigned(RandomAccessFile f4, @Unsigned byte[] b4) throws IOException {
        f4.readFully(b4);
    }

    public static void writeUnsigned(RandomAccessFile f4, @Unsigned byte[] bs, int off, int len) throws IOException {
        f4.write(bs, off, len);
    }

    public static void writeUnsignedByte(RandomAccessFile f4, @Unsigned byte b4) throws IOException {
        f4.writeByte(Byte.toUnsignedInt(b4));
    }

    public static void writeUnsignedChar(RandomAccessFile f4, @Unsigned char c4) throws IOException {
        f4.writeChar(SignednessUtil.toUnsignedInt(c4));
    }

    public static void writeUnsignedShort(RandomAccessFile f4, @Unsigned short s4) throws IOException {
        f4.writeShort(Short.toUnsignedInt(s4));
    }

    public static void writeUnsignedInt(RandomAccessFile f4, @Unsigned int i4) throws IOException {
        f4.writeInt(i4);
    }

    public static void writeUnsignedLong(RandomAccessFile f4, @Unsigned long l4) throws IOException {
        f4.writeLong(l4);
    }

    public static void getUnsigned(ByteBuffer b4, @Unsigned byte[] bs) {
        b4.get(bs);
    }

    public static int compareUnsigned(@Unsigned short x4, @Unsigned short y4) {
        return Integer.compareUnsigned(Short.toUnsignedInt(x4), Short.toUnsignedInt(y4));
    }

    public static int compareUnsigned(@Unsigned byte x4, @Unsigned byte y4) {
        return Integer.compareUnsigned(Byte.toUnsignedInt(x4), Byte.toUnsignedInt(y4));
    }

    public static String toUnsignedString(@Unsigned short s4) {
        return Long.toString(Short.toUnsignedLong(s4));
    }

    public static String toUnsignedString(@Unsigned short s4, int radix) {
        return Integer.toUnsignedString(Short.toUnsignedInt(s4), radix);
    }

    public static String toUnsignedString(@Unsigned byte b4) {
        return Integer.toUnsignedString(Byte.toUnsignedInt(b4));
    }

    public static String toUnsignedString(@Unsigned byte b4, int radix) {
        return Integer.toUnsignedString(Byte.toUnsignedInt(b4), radix);
    }

    private static @Unsigned BigInteger toUnsignedBigInteger(@Unsigned long l4) {
        if (l4 >= 0L) {
            return BigInteger.valueOf(l4);
        }
        int upper = (int)(l4 >>> 32);
        int lower = (int)l4;
        return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
    }

    public static @Unsigned short toUnsignedShort(@Unsigned byte b4) {
        return (short)(b4 & 0xFF);
    }

    public static @Unsigned long toUnsignedLong(@Unsigned char c4) {
        return (long)c4 & 0xFFL;
    }

    public static @Unsigned int toUnsignedInt(@Unsigned char c4) {
        return c4 & 0xFF;
    }

    public static @Unsigned short toUnsignedShort(@Unsigned char c4) {
        return (short)(c4 & 0xFF);
    }

    public static float toFloat(@Unsigned byte b4) {
        return SignednessUtil.toUnsignedBigInteger(Byte.toUnsignedLong(b4)).floatValue();
    }

    public static float toFloat(@Unsigned short s4) {
        return SignednessUtil.toUnsignedBigInteger(Short.toUnsignedLong(s4)).floatValue();
    }

    public static float toFloat(@Unsigned int i4) {
        return SignednessUtil.toUnsignedBigInteger(Integer.toUnsignedLong(i4)).floatValue();
    }

    public static float toFloat(@Unsigned long l4) {
        return SignednessUtil.toUnsignedBigInteger(l4).floatValue();
    }

    public static double toDouble(@Unsigned byte b4) {
        return SignednessUtil.toUnsignedBigInteger(Byte.toUnsignedLong(b4)).doubleValue();
    }

    public static double toDouble(@Unsigned short s4) {
        return SignednessUtil.toUnsignedBigInteger(Short.toUnsignedLong(s4)).doubleValue();
    }

    public static double toDouble(@Unsigned int i4) {
        return SignednessUtil.toUnsignedBigInteger(Integer.toUnsignedLong(i4)).doubleValue();
    }

    public static double toDouble(@Unsigned long l4) {
        return SignednessUtil.toUnsignedBigInteger(l4).doubleValue();
    }

    public static @Unsigned byte byteFromFloat(float f4) {
        assert (f4 >= 0.0f);
        return (byte)f4;
    }

    public static @Unsigned short shortFromFloat(float f4) {
        assert (f4 >= 0.0f);
        return (short)f4;
    }

    public static @Unsigned int intFromFloat(float f4) {
        assert (f4 >= 0.0f);
        return (int)f4;
    }

    public static @Unsigned long longFromFloat(float f4) {
        assert (f4 >= 0.0f);
        return (long)f4;
    }

    public static @Unsigned byte byteFromDouble(double d4) {
        assert (d4 >= 0.0);
        return (byte)d4;
    }

    public static @Unsigned short shortFromDouble(double d4) {
        assert (d4 >= 0.0);
        return (short)d4;
    }

    public static @Unsigned int intFromDouble(double d4) {
        assert (d4 >= 0.0);
        return (int)d4;
    }

    public static @Unsigned long longFromDouble(double d4) {
        assert (d4 >= 0.0);
        return (long)d4;
    }
}

