/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatException;
import java.util.MissingFormatArgumentException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.formatter.qual.ConversionCategory;
import org.checkerframework.checker.formatter.qual.ReturnsFormat;

public class FormatUtil {
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    @ReturnsFormat
    public static String asFormat(String format, ConversionCategory ... cc) throws IllegalFormatException {
        ConversionCategory[] fcc = FormatUtil.formatParameterCategories(format);
        if (fcc.length != cc.length) {
            throw new ExcessiveOrMissingFormatArgumentException(cc.length, fcc.length);
        }
        for (int i4 = 0; i4 < cc.length; ++i4) {
            if (cc[i4] == fcc[i4]) continue;
            throw new IllegalFormatConversionCategoryException(cc[i4], fcc[i4]);
        }
        return format;
    }

    public static void tryFormatSatisfiability(String format) throws IllegalFormatException {
        String unused = String.format(format, (Object[])null);
    }

    public static ConversionCategory[] formatParameterCategories(String format) throws IllegalFormatException {
        FormatUtil.tryFormatSatisfiability(format);
        int last = -1;
        int lasto = -1;
        int maxindex = -1;
        Conversion[] cs = FormatUtil.parse(format);
        HashMap<Integer, ConversionCategory> conv = new HashMap<Integer, ConversionCategory>();
        for (Conversion c4 : cs) {
            int index = c4.index();
            switch (index) {
                case -1: {
                    break;
                }
                case 0: {
                    last = ++lasto;
                    break;
                }
                default: {
                    last = index - 1;
                }
            }
            maxindex = Math.max(maxindex, last);
            conv.put(last, ConversionCategory.intersect(conv.containsKey(last) ? (ConversionCategory)((Object)conv.get(last)) : ConversionCategory.UNUSED, c4.category()));
        }
        ConversionCategory[] res = new ConversionCategory[maxindex + 1];
        for (int i4 = 0; i4 <= maxindex; ++i4) {
            res[i4] = conv.containsKey(i4) ? (ConversionCategory)((Object)conv.get(i4)) : ConversionCategory.UNUSED;
        }
        return res;
    }

    private static int indexFromFormat(Matcher m4) {
        String s4 = m4.group(1);
        int index = s4 != null ? Integer.parseInt(s4.substring(0, s4.length() - 1)) : (m4.group(2) != null && m4.group(2).contains(String.valueOf('<')) ? -1 : 0);
        return index;
    }

    private static char conversionCharFromFormat(Matcher m4) {
        String dt = m4.group(5);
        if (dt == null) {
            return m4.group(6).charAt(0);
        }
        return dt.charAt(0);
    }

    private static Conversion[] parse(String format) {
        ArrayList<Conversion> cs = new ArrayList<Conversion>();
        Matcher m4 = fsPattern.matcher(format);
        block3: while (m4.find()) {
            char c4 = FormatUtil.conversionCharFromFormat(m4);
            switch (c4) {
                case '%': 
                case 'n': {
                    continue block3;
                }
            }
            cs.add(new Conversion(c4, FormatUtil.indexFromFormat(m4)));
        }
        return cs.toArray(new Conversion[cs.size()]);
    }

    public static class IllegalFormatConversionCategoryException
    extends IllegalFormatConversionException {
        private static final long serialVersionUID = 17000126L;
        private final ConversionCategory expected;
        private final ConversionCategory found;

        public IllegalFormatConversionCategoryException(ConversionCategory expected, ConversionCategory found) {
            super(expected.chars.length() == 0 ? (char)'-' : (char)expected.chars.charAt(0), found.types == null ? Object.class : found.types[0]);
            this.expected = expected;
            this.found = found;
        }

        public ConversionCategory getExpected() {
            return this.expected;
        }

        public ConversionCategory getFound() {
            return this.found;
        }

        @Override
        public String getMessage() {
            return String.format("Expected category %s but found %s.", new Object[]{this.expected, this.found});
        }
    }

    public static class ExcessiveOrMissingFormatArgumentException
    extends MissingFormatArgumentException {
        private static final long serialVersionUID = 17000126L;
        private final int expected;
        private final int found;

        public ExcessiveOrMissingFormatArgumentException(int expected, int found) {
            super("-");
            this.expected = expected;
            this.found = found;
        }

        public int getExpected() {
            return this.expected;
        }

        public int getFound() {
            return this.found;
        }

        @Override
        public String getMessage() {
            return String.format("Expected %d arguments but found %d.", this.expected, this.found);
        }
    }

    private static class Conversion {
        private final int index;
        private final ConversionCategory cath;

        public Conversion(char c4, int index) {
            this.index = index;
            this.cath = ConversionCategory.fromConversionChar(c4);
        }

        int index() {
            return this.index;
        }

        ConversionCategory category() {
            return this.cath;
        }
    }
}

