/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders;

import org.bouncycastle.util.encoders.Translator;

public class BufferedDecoder {
    protected byte[] buf;
    protected int bufOff;
    protected Translator translator;

    public BufferedDecoder(Translator translator, int n4) {
        this.translator = translator;
        if (n4 % translator.getEncodedBlockSize() != 0) {
            throw new IllegalArgumentException("buffer size not multiple of input block size");
        }
        this.buf = new byte[n4];
        this.bufOff = 0;
    }

    public int processByte(byte by, byte[] byArray, int n4) {
        int n5 = 0;
        this.buf[this.bufOff++] = by;
        if (this.bufOff == this.buf.length) {
            n5 = this.translator.decode(this.buf, 0, this.buf.length, byArray, n4);
            this.bufOff = 0;
        }
        return n5;
    }

    public int processBytes(byte[] byArray, int n4, int n5, byte[] byArray2, int n6) {
        if (n5 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n7 = 0;
        int n8 = this.buf.length - this.bufOff;
        if (n5 > n8) {
            System.arraycopy(byArray, n4, this.buf, this.bufOff, n8);
            n7 += this.translator.decode(this.buf, 0, this.buf.length, byArray2, n6);
            this.bufOff = 0;
            n6 += n7;
            int n9 = (n5 -= n8) - n5 % this.buf.length;
            n7 += this.translator.decode(byArray, n4 += n8, n9, byArray2, n6);
            n5 -= n9;
            n4 += n9;
        }
        if (n5 != 0) {
            System.arraycopy(byArray, n4, this.buf, this.bufOff, n5);
            this.bufOff += n5;
        }
        return n7;
    }
}

