/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.encoders.Encoder;

public class Base64Encoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    protected byte padding = (byte)61;
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int n4;
        for (n4 = 0; n4 < this.decodingTable.length; ++n4) {
            this.decodingTable[n4] = -1;
        }
        for (n4 = 0; n4 < this.encodingTable.length; ++n4) {
            this.decodingTable[this.encodingTable[n4]] = (byte)n4;
        }
    }

    public Base64Encoder() {
        this.initialiseDecodingTable();
    }

    public int encode(byte[] byArray, int n4, int n5, OutputStream outputStream) throws IOException {
        int n6;
        int n7 = n5 % 3;
        int n8 = n5 - n7;
        for (n6 = n4; n6 < n4 + n8; n6 += 3) {
            int n9 = byArray[n6] & 0xFF;
            int n10 = byArray[n6 + 1] & 0xFF;
            int n11 = byArray[n6 + 2] & 0xFF;
            outputStream.write(this.encodingTable[n9 >>> 2 & 0x3F]);
            outputStream.write(this.encodingTable[(n9 << 4 | n10 >>> 4) & 0x3F]);
            outputStream.write(this.encodingTable[(n10 << 2 | n11 >>> 6) & 0x3F]);
            outputStream.write(this.encodingTable[n11 & 0x3F]);
        }
        switch (n7) {
            case 0: {
                break;
            }
            case 1: {
                int n12 = byArray[n4 + n8] & 0xFF;
                n6 = n12 >>> 2 & 0x3F;
                int n13 = n12 << 4 & 0x3F;
                outputStream.write(this.encodingTable[n6]);
                outputStream.write(this.encodingTable[n13]);
                outputStream.write(this.padding);
                outputStream.write(this.padding);
                break;
            }
            case 2: {
                int n14 = byArray[n4 + n8] & 0xFF;
                int n15 = byArray[n4 + n8 + 1] & 0xFF;
                n6 = n14 >>> 2 & 0x3F;
                int n16 = (n14 << 4 | n15 >>> 4) & 0x3F;
                int n17 = n15 << 2 & 0x3F;
                outputStream.write(this.encodingTable[n6]);
                outputStream.write(this.encodingTable[n16]);
                outputStream.write(this.encodingTable[n17]);
                outputStream.write(this.padding);
            }
        }
        return n8 / 3 * 4 + (n7 == 0 ? 0 : 4);
    }

    private boolean ignore(char c4) {
        return c4 == '\n' || c4 == '\r' || c4 == '\t' || c4 == ' ';
    }

    public int decode(byte[] byArray, int n4, int n5, OutputStream outputStream) throws IOException {
        int n6;
        int n7 = 0;
        for (n6 = n4 + n5; n6 > n4 && this.ignore((char)byArray[n6 - 1]); --n6) {
        }
        int n8 = n4;
        int n9 = n6 - 4;
        n8 = this.nextI(byArray, n8, n9);
        while (n8 < n9) {
            byte by;
            byte by2 = this.decodingTable[byArray[n8++]];
            n8 = this.nextI(byArray, n8, n9);
            byte by3 = this.decodingTable[byArray[n8++]];
            n8 = this.nextI(byArray, n8, n9);
            byte by4 = this.decodingTable[byArray[n8++]];
            n8 = this.nextI(byArray, n8, n9);
            if ((by2 | by3 | by4 | (by = this.decodingTable[byArray[n8++]])) < 0) {
                throw new IOException("invalid characters encountered in base64 data");
            }
            outputStream.write(by2 << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by4 >> 2);
            outputStream.write(by4 << 6 | by);
            n7 += 3;
            n8 = this.nextI(byArray, n8, n9);
        }
        return n7 += this.decodeLastBlock(outputStream, (char)byArray[n6 - 4], (char)byArray[n6 - 3], (char)byArray[n6 - 2], (char)byArray[n6 - 1]);
    }

    private int nextI(byte[] byArray, int n4, int n5) {
        while (n4 < n5 && this.ignore((char)byArray[n4])) {
            ++n4;
        }
        return n4;
    }

    public int decode(String string, OutputStream outputStream) throws IOException {
        int n4;
        int n5 = 0;
        for (n4 = string.length(); n4 > 0 && this.ignore(string.charAt(n4 - 1)); --n4) {
        }
        int n6 = 0;
        int n7 = n4 - 4;
        n6 = this.nextI(string, n6, n7);
        while (n6 < n7) {
            byte by;
            byte by2 = this.decodingTable[string.charAt(n6++)];
            n6 = this.nextI(string, n6, n7);
            byte by3 = this.decodingTable[string.charAt(n6++)];
            n6 = this.nextI(string, n6, n7);
            byte by4 = this.decodingTable[string.charAt(n6++)];
            n6 = this.nextI(string, n6, n7);
            if ((by2 | by3 | by4 | (by = this.decodingTable[string.charAt(n6++)])) < 0) {
                throw new IOException("invalid characters encountered in base64 data");
            }
            outputStream.write(by2 << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by4 >> 2);
            outputStream.write(by4 << 6 | by);
            n5 += 3;
            n6 = this.nextI(string, n6, n7);
        }
        return n5 += this.decodeLastBlock(outputStream, string.charAt(n4 - 4), string.charAt(n4 - 3), string.charAt(n4 - 2), string.charAt(n4 - 1));
    }

    private int decodeLastBlock(OutputStream outputStream, char c4, char c5, char c6, char c7) throws IOException {
        if (c6 == this.padding) {
            byte by = this.decodingTable[c4];
            byte by2 = this.decodingTable[c5];
            if ((by | by2) < 0) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            outputStream.write(by << 2 | by2 >> 4);
            return 1;
        }
        if (c7 == this.padding) {
            byte by = this.decodingTable[c4];
            byte by3 = this.decodingTable[c5];
            byte by4 = this.decodingTable[c6];
            if ((by | by3 | by4) < 0) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            outputStream.write(by << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by4 >> 2);
            return 2;
        }
        byte by = this.decodingTable[c4];
        byte by5 = this.decodingTable[c5];
        byte by6 = this.decodingTable[c6];
        byte by7 = this.decodingTable[c7];
        if ((by | by5 | by6 | by7) < 0) {
            throw new IOException("invalid characters encountered at end of base64 data");
        }
        outputStream.write(by << 2 | by5 >> 4);
        outputStream.write(by5 << 4 | by6 >> 2);
        outputStream.write(by6 << 6 | by7);
        return 3;
    }

    private int nextI(String string, int n4, int n5) {
        while (n4 < n5 && this.ignore(string.charAt(n4))) {
            ++n4;
        }
        return n4;
    }
}

