/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.BigEndianConversions;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public final class IntUtils {
    private IntUtils() {
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        boolean bl = true;
        for (int i4 = nArray.length - 1; i4 >= 0; --i4) {
            bl &= nArray[i4] == nArray2[i4];
        }
        return bl;
    }

    public static int[] clone(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static void fill(int[] nArray, int n4) {
        for (int i4 = nArray.length - 1; i4 >= 0; --i4) {
            nArray[i4] = n4;
        }
    }

    public static void quicksort(int[] nArray) {
        IntUtils.quicksort(nArray, 0, nArray.length - 1);
    }

    public static void quicksort(int[] nArray, int n4, int n5) {
        if (n5 > n4) {
            int n6 = IntUtils.partition(nArray, n4, n5, n5);
            IntUtils.quicksort(nArray, n4, n6 - 1);
            IntUtils.quicksort(nArray, n6 + 1, n5);
        }
    }

    private static int partition(int[] nArray, int n4, int n5, int n6) {
        int n7;
        int n8 = nArray[n6];
        nArray[n6] = nArray[n5];
        nArray[n5] = n8;
        int n9 = n4;
        for (n7 = n4; n7 < n5; ++n7) {
            if (nArray[n7] > n8) continue;
            int n10 = nArray[n9];
            nArray[n9] = nArray[n7];
            nArray[n7] = n10;
            ++n9;
        }
        n7 = nArray[n9];
        nArray[n9] = nArray[n5];
        nArray[n5] = n7;
        return n9;
    }

    public static int[] subArray(int[] nArray, int n4, int n5) {
        int[] nArray2 = new int[n5 - n4];
        System.arraycopy(nArray, n4, nArray2, 0, n5 - n4);
        return nArray2;
    }

    public static String toString(int[] nArray) {
        String string = "";
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            string = string + nArray[i4] + " ";
        }
        return string;
    }

    public static String toHexString(int[] nArray) {
        return ByteUtils.toHexString(BigEndianConversions.toByteArray(nArray));
    }
}

