/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialField;

public abstract class GF2nField {
    protected final SecureRandom random;
    protected int mDegree;
    protected GF2Polynomial fieldPolynomial;
    protected Vector fields;
    protected Vector matrices;

    protected GF2nField(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    public final int getDegree() {
        return this.mDegree;
    }

    public final GF2Polynomial getFieldPolynomial() {
        if (this.fieldPolynomial == null) {
            this.computeFieldPolynomial();
        }
        return new GF2Polynomial(this.fieldPolynomial);
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof GF2nField)) {
            return false;
        }
        GF2nField gF2nField = (GF2nField)object;
        if (gF2nField.mDegree != this.mDegree) {
            return false;
        }
        if (!this.fieldPolynomial.equals(gF2nField.fieldPolynomial)) {
            return false;
        }
        if (this instanceof GF2nPolynomialField && !(gF2nField instanceof GF2nPolynomialField)) {
            return false;
        }
        return !(this instanceof GF2nONBField) || gF2nField instanceof GF2nONBField;
    }

    public int hashCode() {
        return this.mDegree + this.fieldPolynomial.hashCode();
    }

    protected abstract GF2nElement getRandomRoot(GF2Polynomial var1);

    protected abstract void computeCOBMatrix(GF2nField var1);

    protected abstract void computeFieldPolynomial();

    protected final GF2Polynomial[] invertMatrix(GF2Polynomial[] gF2PolynomialArray) {
        int n4;
        int n5;
        GF2Polynomial[] gF2PolynomialArray2 = new GF2Polynomial[gF2PolynomialArray.length];
        GF2Polynomial[] gF2PolynomialArray3 = new GF2Polynomial[gF2PolynomialArray.length];
        for (n5 = 0; n5 < this.mDegree; ++n5) {
            try {
                gF2PolynomialArray2[n5] = new GF2Polynomial(gF2PolynomialArray[n5]);
                gF2PolynomialArray3[n5] = new GF2Polynomial(this.mDegree);
                gF2PolynomialArray3[n5].setBit(this.mDegree - 1 - n5);
                continue;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        for (n5 = 0; n5 < this.mDegree - 1; ++n5) {
            for (n4 = n5; n4 < this.mDegree && !gF2PolynomialArray2[n4].testBit(this.mDegree - 1 - n5); ++n4) {
            }
            if (n4 >= this.mDegree) {
                throw new RuntimeException("GF2nField.invertMatrix: Matrix cannot be inverted!");
            }
            if (n5 != n4) {
                GF2Polynomial gF2Polynomial = gF2PolynomialArray2[n5];
                gF2PolynomialArray2[n5] = gF2PolynomialArray2[n4];
                gF2PolynomialArray2[n4] = gF2Polynomial;
                gF2Polynomial = gF2PolynomialArray3[n5];
                gF2PolynomialArray3[n5] = gF2PolynomialArray3[n4];
                gF2PolynomialArray3[n4] = gF2Polynomial;
            }
            for (n4 = n5 + 1; n4 < this.mDegree; ++n4) {
                if (!gF2PolynomialArray2[n4].testBit(this.mDegree - 1 - n5)) continue;
                gF2PolynomialArray2[n4].addToThis(gF2PolynomialArray2[n5]);
                gF2PolynomialArray3[n4].addToThis(gF2PolynomialArray3[n5]);
            }
        }
        for (n5 = this.mDegree - 1; n5 > 0; --n5) {
            for (n4 = n5 - 1; n4 >= 0; --n4) {
                if (!gF2PolynomialArray2[n4].testBit(this.mDegree - 1 - n5)) continue;
                gF2PolynomialArray2[n4].addToThis(gF2PolynomialArray2[n5]);
                gF2PolynomialArray3[n4].addToThis(gF2PolynomialArray3[n5]);
            }
        }
        return gF2PolynomialArray3;
    }

    public final GF2nElement convert(GF2nElement gF2nElement, GF2nField gF2nField) throws RuntimeException {
        if (gF2nField == this) {
            return (GF2nElement)gF2nElement.clone();
        }
        if (this.fieldPolynomial.equals(gF2nField.fieldPolynomial)) {
            return (GF2nElement)gF2nElement.clone();
        }
        if (this.mDegree != gF2nField.mDegree) {
            throw new RuntimeException("GF2nField.convert: B1 has a different degree and thus cannot be coverted to!");
        }
        int n4 = this.fields.indexOf(gF2nField);
        if (n4 == -1) {
            this.computeCOBMatrix(gF2nField);
            n4 = this.fields.indexOf(gF2nField);
        }
        GF2Polynomial[] gF2PolynomialArray = (GF2Polynomial[])this.matrices.elementAt(n4);
        GF2nElement gF2nElement2 = (GF2nElement)gF2nElement.clone();
        if (gF2nElement2 instanceof GF2nONBElement) {
            ((GF2nONBElement)gF2nElement2).reverseOrder();
        }
        GF2Polynomial gF2Polynomial = new GF2Polynomial(this.mDegree, gF2nElement2.toFlexiBigInt());
        gF2Polynomial.expandN(this.mDegree);
        GF2Polynomial gF2Polynomial2 = new GF2Polynomial(this.mDegree);
        for (n4 = 0; n4 < this.mDegree; ++n4) {
            if (!gF2Polynomial.vectorMult(gF2PolynomialArray[n4])) continue;
            gF2Polynomial2.setBit(this.mDegree - 1 - n4);
        }
        if (gF2nField instanceof GF2nPolynomialField) {
            return new GF2nPolynomialElement((GF2nPolynomialField)gF2nField, gF2Polynomial2);
        }
        if (gF2nField instanceof GF2nONBField) {
            GF2nONBElement gF2nONBElement = new GF2nONBElement((GF2nONBField)gF2nField, gF2Polynomial2.toFlexiBigInt());
            gF2nONBElement.reverseOrder();
            return gF2nONBElement;
        }
        throw new RuntimeException("GF2nField.convert: B1 must be an instance of GF2nPolynomialField or GF2nONBField!");
    }
}

