/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.Matrix;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2mMatrix
extends Matrix {
    protected GF2mField field;
    protected int[][] matrix;

    public GF2mMatrix(GF2mField gF2mField, byte[] byArray) {
        int n4;
        this.field = gF2mField;
        int n5 = 1;
        for (n4 = 8; gF2mField.getDegree() > n4; n4 += 8) {
            ++n5;
        }
        if (byArray.length < 5) {
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        this.numRows = (byArray[3] & 0xFF) << 24 ^ (byArray[2] & 0xFF) << 16 ^ (byArray[1] & 0xFF) << 8 ^ byArray[0] & 0xFF;
        int n6 = n5 * this.numRows;
        if (this.numRows <= 0 || (byArray.length - 4) % n6 != 0) {
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        this.numColumns = (byArray.length - 4) / n6;
        this.matrix = new int[this.numRows][this.numColumns];
        n5 = 4;
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            for (int i5 = 0; i5 < this.numColumns; ++i5) {
                for (int i6 = 0; i6 < n4; i6 += 8) {
                    int[] nArray = this.matrix[i4];
                    int n7 = i5;
                    nArray[n7] = nArray[n7] ^ (byArray[n5++] & 0xFF) << i6;
                }
                if (this.field.isElementOfThisField(this.matrix[i4][i5])) continue;
                throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
            }
        }
    }

    public GF2mMatrix(GF2mMatrix gF2mMatrix) {
        this.numRows = gF2mMatrix.numRows;
        this.numColumns = gF2mMatrix.numColumns;
        this.field = gF2mMatrix.field;
        this.matrix = new int[this.numRows][];
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            this.matrix[i4] = IntUtils.clone(gF2mMatrix.matrix[i4]);
        }
    }

    protected GF2mMatrix(GF2mField gF2mField, int[][] nArray) {
        this.field = gF2mField;
        this.matrix = nArray;
        this.numRows = nArray.length;
        this.numColumns = nArray[0].length;
    }

    public byte[] getEncoded() {
        int n4;
        int n5 = 1;
        for (n4 = 8; this.field.getDegree() > n4; n4 += 8) {
            ++n5;
        }
        byte[] byArray = new byte[this.numRows * this.numColumns * n5 + 4];
        byArray[0] = (byte)(this.numRows & 0xFF);
        byArray[1] = (byte)(this.numRows >>> 8 & 0xFF);
        byArray[2] = (byte)(this.numRows >>> 16 & 0xFF);
        byArray[3] = (byte)(this.numRows >>> 24 & 0xFF);
        n5 = 4;
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            for (int i5 = 0; i5 < this.numColumns; ++i5) {
                for (int i6 = 0; i6 < n4; i6 += 8) {
                    byArray[n5++] = (byte)(this.matrix[i4][i5] >>> i6);
                }
            }
        }
        return byArray;
    }

    public boolean isZero() {
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            for (int i5 = 0; i5 < this.numColumns; ++i5) {
                if (this.matrix[i4][i5] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public Matrix computeInverse() {
        int n4;
        if (this.numRows != this.numColumns) {
            throw new ArithmeticException("Matrix is not invertible.");
        }
        int[][] nArray = new int[this.numRows][this.numRows];
        for (int i4 = this.numRows - 1; i4 >= 0; --i4) {
            nArray[i4] = IntUtils.clone(this.matrix[i4]);
        }
        int[][] nArray2 = new int[this.numRows][this.numRows];
        for (n4 = this.numRows - 1; n4 >= 0; --n4) {
            nArray2[n4][n4] = 1;
        }
        for (n4 = 0; n4 < this.numRows; ++n4) {
            int n5;
            int n6;
            if (nArray[n4][n4] == 0) {
                n6 = 0;
                for (n5 = n4 + 1; n5 < this.numRows; ++n5) {
                    if (nArray[n5][n4] == 0) continue;
                    n6 = 1;
                    GF2mMatrix.swapColumns(nArray, n4, n5);
                    GF2mMatrix.swapColumns(nArray2, n4, n5);
                    n5 = this.numRows;
                }
                if (n6 == 0) {
                    throw new ArithmeticException("Matrix is not invertible.");
                }
            }
            n6 = nArray[n4][n4];
            n5 = this.field.inverse(n6);
            this.multRowWithElementThis(nArray[n4], n5);
            this.multRowWithElementThis(nArray2[n4], n5);
            for (int i5 = 0; i5 < this.numRows; ++i5) {
                if (i5 == n4 || (n6 = nArray[i5][n4]) == 0) continue;
                int[] nArray3 = this.multRowWithElement(nArray[n4], n6);
                int[] nArray4 = this.multRowWithElement(nArray2[n4], n6);
                this.addToRow(nArray3, nArray[i5]);
                this.addToRow(nArray4, nArray2[i5]);
            }
        }
        return new GF2mMatrix(this.field, nArray2);
    }

    private static void swapColumns(int[][] nArray, int n4, int n5) {
        int[] nArray2 = nArray[n4];
        nArray[n4] = nArray[n5];
        nArray[n5] = nArray2;
    }

    private void multRowWithElementThis(int[] nArray, int n4) {
        for (int i4 = nArray.length - 1; i4 >= 0; --i4) {
            nArray[i4] = this.field.mult(nArray[i4], n4);
        }
    }

    private int[] multRowWithElement(int[] nArray, int n4) {
        int[] nArray2 = new int[nArray.length];
        for (int i4 = nArray.length - 1; i4 >= 0; --i4) {
            nArray2[i4] = this.field.mult(nArray[i4], n4);
        }
        return nArray2;
    }

    private void addToRow(int[] nArray, int[] nArray2) {
        for (int i4 = nArray2.length - 1; i4 >= 0; --i4) {
            nArray2[i4] = this.field.add(nArray[i4], nArray2[i4]);
        }
    }

    public Matrix rightMultiply(Matrix matrix) {
        throw new RuntimeException("Not implemented.");
    }

    public Matrix rightMultiply(Permutation permutation) {
        throw new RuntimeException("Not implemented.");
    }

    public Vector leftMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    public Vector rightMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GF2mMatrix)) {
            return false;
        }
        GF2mMatrix gF2mMatrix = (GF2mMatrix)object;
        if (!this.field.equals(gF2mMatrix.field) || gF2mMatrix.numRows != this.numColumns || gF2mMatrix.numColumns != this.numColumns) {
            return false;
        }
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            for (int i5 = 0; i5 < this.numColumns; ++i5) {
                if (this.matrix[i4][i5] == gF2mMatrix.matrix[i4][i5]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n4 = (this.field.hashCode() * 31 + this.numRows) * 31 + this.numColumns;
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            for (int i5 = 0; i5 < this.numColumns; ++i5) {
                n4 = n4 * 31 + this.matrix[i4][i5];
            }
        }
        return n4;
    }

    public String toString() {
        String string = this.numRows + " x " + this.numColumns + " Matrix over " + this.field.toString() + ": \n";
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            for (int i5 = 0; i5 < this.numColumns; ++i5) {
                string = string + this.field.elementToStr(this.matrix[i4][i5]) + " : ";
            }
            string = string + "\n";
        }
        return string;
    }
}

