/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.rainbow.Layer;
import org.bouncycastle.pqc.crypto.rainbow.RainbowKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import org.bouncycastle.pqc.crypto.rainbow.util.ComputeInField;
import org.bouncycastle.pqc.crypto.rainbow.util.GF2Field;

public class RainbowSigner
implements MessageSigner {
    private SecureRandom random;
    int signableDocumentLength;
    private short[] x;
    private ComputeInField cf = new ComputeInField();
    RainbowKeyParameters key;

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.random = parametersWithRandom.getRandom();
                this.key = (RainbowPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (RainbowPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.key = (RainbowPublicKeyParameters)cipherParameters;
        }
        this.signableDocumentLength = this.key.getDocLength();
    }

    private short[] initSign(Layer[] layerArray, short[] sArray) {
        short[] sArray2 = new short[sArray.length];
        sArray2 = this.cf.addVect(((RainbowPrivateKeyParameters)this.key).getB1(), sArray);
        short[] sArray3 = this.cf.multiplyMatrix(((RainbowPrivateKeyParameters)this.key).getInvA1(), sArray2);
        for (int i4 = 0; i4 < layerArray[0].getVi(); ++i4) {
            this.x[i4] = (short)this.random.nextInt();
            this.x[i4] = (short)(this.x[i4] & 0xFF);
        }
        return sArray3;
    }

    public byte[] generateSignature(byte[] byArray) {
        boolean bl;
        Layer[] layerArray = ((RainbowPrivateKeyParameters)this.key).getLayers();
        int n4 = layerArray.length;
        this.x = new short[((RainbowPrivateKeyParameters)this.key).getInvA2().length];
        byte[] byArray2 = new byte[layerArray[n4 - 1].getViNext()];
        short[] sArray = this.makeMessageRepresentative(byArray);
        do {
            bl = true;
            int n5 = 0;
            try {
                int n6;
                short[] sArray2 = this.initSign(layerArray, sArray);
                for (n6 = 0; n6 < n4; ++n6) {
                    int n7;
                    short[] sArray3 = new short[layerArray[n6].getOi()];
                    short[] sArray4 = new short[layerArray[n6].getOi()];
                    for (n7 = 0; n7 < layerArray[n6].getOi(); ++n7) {
                        sArray3[n7] = sArray2[n5];
                        ++n5;
                    }
                    sArray4 = this.cf.solveEquation(layerArray[n6].plugInVinegars(this.x), sArray3);
                    if (sArray4 == null) {
                        throw new Exception("LES is not solveable!");
                    }
                    for (n7 = 0; n7 < sArray4.length; ++n7) {
                        this.x[layerArray[n6].getVi() + n7] = sArray4[n7];
                    }
                }
                short[] sArray5 = this.cf.addVect(((RainbowPrivateKeyParameters)this.key).getB2(), this.x);
                short[] sArray6 = this.cf.multiplyMatrix(((RainbowPrivateKeyParameters)this.key).getInvA2(), sArray5);
                for (n6 = 0; n6 < byArray2.length; ++n6) {
                    byArray2[n6] = (byte)sArray6[n6];
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        } while (!bl);
        return byArray2;
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        short[] sArray = new short[byArray2.length];
        for (int i4 = 0; i4 < byArray2.length; ++i4) {
            short s4 = byArray2[i4];
            sArray[i4] = s4 = (short)(s4 & 0xFF);
        }
        short[] sArray2 = this.makeMessageRepresentative(byArray);
        short[] sArray3 = this.verifySignatureIntern(sArray);
        boolean bl = true;
        if (sArray2.length != sArray3.length) {
            return false;
        }
        for (int i5 = 0; i5 < sArray2.length; ++i5) {
            bl = bl && sArray2[i5] == sArray3[i5];
        }
        return bl;
    }

    private short[] verifySignatureIntern(short[] sArray) {
        short[][] sArray2 = ((RainbowPublicKeyParameters)this.key).getCoeffQuadratic();
        short[][] sArray3 = ((RainbowPublicKeyParameters)this.key).getCoeffSingular();
        short[] sArray4 = ((RainbowPublicKeyParameters)this.key).getCoeffScalar();
        short[] sArray5 = new short[sArray2.length];
        int n4 = sArray3[0].length;
        int n5 = 0;
        short s4 = 0;
        for (int i4 = 0; i4 < sArray2.length; ++i4) {
            n5 = 0;
            for (int i5 = 0; i5 < n4; ++i5) {
                for (int i6 = i5; i6 < n4; ++i6) {
                    s4 = GF2Field.multElem(sArray2[i4][n5], GF2Field.multElem(sArray[i5], sArray[i6]));
                    sArray5[i4] = GF2Field.addElem(sArray5[i4], s4);
                    ++n5;
                }
                s4 = GF2Field.multElem(sArray3[i4][i5], sArray[i5]);
                sArray5[i4] = GF2Field.addElem(sArray5[i4], s4);
            }
            sArray5[i4] = GF2Field.addElem(sArray5[i4], sArray4[i4]);
        }
        return sArray5;
    }

    private short[] makeMessageRepresentative(byte[] byArray) {
        short[] sArray = new short[this.signableDocumentLength];
        int n4 = 0;
        int n5 = 0;
        while (n5 < byArray.length) {
            sArray[n5] = byArray[n4];
            int n6 = n5++;
            sArray[n6] = (short)(sArray[n6] & 0xFF);
            ++n4;
            if (n5 < sArray.length) continue;
        }
        return sArray;
    }
}

