/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.raw;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.util.Pack;

public abstract class Nat128 {
    private static final long M = 0xFFFFFFFFL;

    public static int add(int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        nArray3[0] = (int)(l4 += ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[1] = (int)(l4 += ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[2] = (int)(l4 += ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[3] = (int)(l4 += ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int addBothTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        nArray3[0] = (int)(l4 += ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)nArray3[0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[1] = (int)(l4 += ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + ((long)nArray3[1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[2] = (int)(l4 += ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + ((long)nArray3[2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray3[3] = (int)(l4 += ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + ((long)nArray3[3] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int addTo(int[] nArray, int[] nArray2) {
        long l4 = 0L;
        nArray2[0] = (int)(l4 += ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[1] = (int)(l4 += ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[2] = (int)(l4 += ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[3] = (int)(l4 += ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int addTo(int[] nArray, int n4, int[] nArray2, int n5, int n6) {
        long l4 = (long)n6 & 0xFFFFFFFFL;
        nArray2[n5 + 0] = (int)(l4 += ((long)nArray[n4 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n5 + 1] = (int)(l4 += ((long)nArray[n4 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n5 + 2] = (int)(l4 += ((long)nArray[n4 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n5 + 3] = (int)(l4 += ((long)nArray[n4 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 3] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int addToEachOther(int[] nArray, int n4, int[] nArray2, int n5) {
        long l4 = 0L;
        nArray[n4 + 0] = (int)(l4 += ((long)nArray[n4 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 0] & 0xFFFFFFFFL));
        nArray2[n5 + 0] = (int)l4;
        l4 >>>= 32;
        nArray[n4 + 1] = (int)(l4 += ((long)nArray[n4 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 1] & 0xFFFFFFFFL));
        nArray2[n5 + 1] = (int)l4;
        l4 >>>= 32;
        nArray[n4 + 2] = (int)(l4 += ((long)nArray[n4 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 2] & 0xFFFFFFFFL));
        nArray2[n5 + 2] = (int)l4;
        l4 >>>= 32;
        nArray[n4 + 3] = (int)(l4 += ((long)nArray[n4 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n5 + 3] & 0xFFFFFFFFL));
        nArray2[n5 + 3] = (int)l4;
        return (int)(l4 >>>= 32);
    }

    public static void copy(int[] nArray, int[] nArray2) {
        nArray2[0] = nArray[0];
        nArray2[1] = nArray[1];
        nArray2[2] = nArray[2];
        nArray2[3] = nArray[3];
    }

    public static void copy64(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0];
        lArray2[1] = lArray[1];
    }

    public static int[] create() {
        return new int[4];
    }

    public static long[] create64() {
        return new long[2];
    }

    public static int[] createExt() {
        return new int[8];
    }

    public static long[] createExt64() {
        return new long[4];
    }

    public static boolean diff(int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        boolean bl = Nat128.gte(nArray, n4, nArray2, n5);
        if (bl) {
            Nat128.sub(nArray, n4, nArray2, n5, nArray3, n6);
        } else {
            Nat128.sub(nArray2, n5, nArray, n4, nArray3, n6);
        }
        return bl;
    }

    public static boolean eq(int[] nArray, int[] nArray2) {
        for (int i4 = 3; i4 >= 0; --i4) {
            if (nArray[i4] == nArray2[i4]) continue;
            return false;
        }
        return true;
    }

    public static boolean eq64(long[] lArray, long[] lArray2) {
        for (int i4 = 1; i4 >= 0; --i4) {
            if (lArray[i4] == lArray2[i4]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.bitLength() > 128) {
            throw new IllegalArgumentException();
        }
        int[] nArray = Nat128.create();
        int n4 = 0;
        while (bigInteger.signum() != 0) {
            nArray[n4++] = bigInteger.intValue();
            bigInteger = bigInteger.shiftRight(32);
        }
        return nArray;
    }

    public static long[] fromBigInteger64(BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.bitLength() > 128) {
            throw new IllegalArgumentException();
        }
        long[] lArray = Nat128.create64();
        int n4 = 0;
        while (bigInteger.signum() != 0) {
            lArray[n4++] = bigInteger.longValue();
            bigInteger = bigInteger.shiftRight(64);
        }
        return lArray;
    }

    public static int getBit(int[] nArray, int n4) {
        if (n4 == 0) {
            return nArray[0] & 1;
        }
        int n5 = n4 >> 5;
        if (n5 < 0 || n5 >= 4) {
            return 0;
        }
        int n6 = n4 & 0x1F;
        return nArray[n5] >>> n6 & 1;
    }

    public static boolean gte(int[] nArray, int[] nArray2) {
        for (int i4 = 3; i4 >= 0; --i4) {
            int n4 = nArray[i4] ^ Integer.MIN_VALUE;
            int n5 = nArray2[i4] ^ Integer.MIN_VALUE;
            if (n4 < n5) {
                return false;
            }
            if (n4 <= n5) continue;
            return true;
        }
        return true;
    }

    public static boolean gte(int[] nArray, int n4, int[] nArray2, int n5) {
        for (int i4 = 3; i4 >= 0; --i4) {
            int n6 = nArray[n4 + i4] ^ Integer.MIN_VALUE;
            int n7 = nArray2[n5 + i4] ^ Integer.MIN_VALUE;
            if (n6 < n7) {
                return false;
            }
            if (n6 <= n7) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] nArray) {
        if (nArray[0] != 1) {
            return false;
        }
        for (int i4 = 1; i4 < 4; ++i4) {
            if (nArray[i4] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isOne64(long[] lArray) {
        if (lArray[0] != 1L) {
            return false;
        }
        for (int i4 = 1; i4 < 2; ++i4) {
            if (lArray[i4] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] nArray) {
        for (int i4 = 0; i4 < 4; ++i4) {
            if (nArray[i4] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] lArray) {
        for (int i4 = 0; i4 < 2; ++i4) {
            if (lArray[i4] == 0L) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = (long)nArray2[0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l8 = 0L;
        long l9 = (long)nArray[0] & 0xFFFFFFFFL;
        nArray3[0] = (int)(l8 += l9 * l4);
        l8 >>>= 32;
        nArray3[1] = (int)(l8 += l9 * l5);
        l8 >>>= 32;
        nArray3[2] = (int)(l8 += l9 * l6);
        l8 >>>= 32;
        nArray3[3] = (int)(l8 += l9 * l7);
        nArray3[4] = (int)(l8 >>>= 32);
        for (int i4 = 1; i4 < 4; ++i4) {
            long l10 = 0L;
            long l11 = (long)nArray[i4] & 0xFFFFFFFFL;
            nArray3[i4 + 0] = (int)(l10 += l11 * l4 + ((long)nArray3[i4 + 0] & 0xFFFFFFFFL));
            l10 >>>= 32;
            nArray3[i4 + 1] = (int)(l10 += l11 * l5 + ((long)nArray3[i4 + 1] & 0xFFFFFFFFL));
            l10 >>>= 32;
            nArray3[i4 + 2] = (int)(l10 += l11 * l6 + ((long)nArray3[i4 + 2] & 0xFFFFFFFFL));
            l10 >>>= 32;
            nArray3[i4 + 3] = (int)(l10 += l11 * l7 + ((long)nArray3[i4 + 3] & 0xFFFFFFFFL));
            nArray3[i4 + 4] = (int)(l10 >>>= 32);
        }
    }

    public static void mul(int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l4 = (long)nArray2[n5 + 0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[n5 + 1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[n5 + 2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[n5 + 3] & 0xFFFFFFFFL;
        long l8 = 0L;
        long l9 = (long)nArray[n4 + 0] & 0xFFFFFFFFL;
        nArray3[n6 + 0] = (int)(l8 += l9 * l4);
        l8 >>>= 32;
        nArray3[n6 + 1] = (int)(l8 += l9 * l5);
        l8 >>>= 32;
        nArray3[n6 + 2] = (int)(l8 += l9 * l6);
        l8 >>>= 32;
        nArray3[n6 + 3] = (int)(l8 += l9 * l7);
        nArray3[n6 + 4] = (int)(l8 >>>= 32);
        for (int i4 = 1; i4 < 4; ++i4) {
            long l10 = 0L;
            long l11 = (long)nArray[n4 + i4] & 0xFFFFFFFFL;
            nArray3[n6 + 0] = (int)(l10 += l11 * l4 + ((long)nArray3[++n6 + 0] & 0xFFFFFFFFL));
            l10 >>>= 32;
            nArray3[n6 + 1] = (int)(l10 += l11 * l5 + ((long)nArray3[n6 + 1] & 0xFFFFFFFFL));
            l10 >>>= 32;
            nArray3[n6 + 2] = (int)(l10 += l11 * l6 + ((long)nArray3[n6 + 2] & 0xFFFFFFFFL));
            l10 >>>= 32;
            nArray3[n6 + 3] = (int)(l10 += l11 * l7 + ((long)nArray3[n6 + 3] & 0xFFFFFFFFL));
            nArray3[n6 + 4] = (int)(l10 >>>= 32);
        }
    }

    public static int mulAddTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = (long)nArray2[0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l8 = 0L;
        for (int i4 = 0; i4 < 4; ++i4) {
            long l9 = 0L;
            long l10 = (long)nArray[i4] & 0xFFFFFFFFL;
            nArray3[i4 + 0] = (int)(l9 += l10 * l4 + ((long)nArray3[i4 + 0] & 0xFFFFFFFFL));
            l9 >>>= 32;
            nArray3[i4 + 1] = (int)(l9 += l10 * l5 + ((long)nArray3[i4 + 1] & 0xFFFFFFFFL));
            l9 >>>= 32;
            nArray3[i4 + 2] = (int)(l9 += l10 * l6 + ((long)nArray3[i4 + 2] & 0xFFFFFFFFL));
            l9 >>>= 32;
            nArray3[i4 + 3] = (int)(l9 += l10 * l7 + ((long)nArray3[i4 + 3] & 0xFFFFFFFFL));
            l9 >>>= 32;
            nArray3[i4 + 4] = (int)(l9 += l8 + ((long)nArray3[i4 + 4] & 0xFFFFFFFFL));
            l8 = l9 >>> 32;
        }
        return (int)l8;
    }

    public static int mulAddTo(int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l4 = (long)nArray2[n5 + 0] & 0xFFFFFFFFL;
        long l5 = (long)nArray2[n5 + 1] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[n5 + 2] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[n5 + 3] & 0xFFFFFFFFL;
        long l8 = 0L;
        for (int i4 = 0; i4 < 4; ++i4) {
            long l9 = 0L;
            long l10 = (long)nArray[n4 + i4] & 0xFFFFFFFFL;
            nArray3[n6 + 0] = (int)(l9 += l10 * l4 + ((long)nArray3[n6 + 0] & 0xFFFFFFFFL));
            l9 >>>= 32;
            nArray3[n6 + 1] = (int)(l9 += l10 * l5 + ((long)nArray3[n6 + 1] & 0xFFFFFFFFL));
            l9 >>>= 32;
            nArray3[n6 + 2] = (int)(l9 += l10 * l6 + ((long)nArray3[n6 + 2] & 0xFFFFFFFFL));
            l9 >>>= 32;
            nArray3[n6 + 3] = (int)(l9 += l10 * l7 + ((long)nArray3[n6 + 3] & 0xFFFFFFFFL));
            l9 >>>= 32;
            nArray3[n6 + 4] = (int)(l9 += l8 + ((long)nArray3[n6 + 4] & 0xFFFFFFFFL));
            l8 = l9 >>> 32;
            ++n6;
        }
        return (int)l8;
    }

    public static long mul33Add(int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7) {
        long l4 = 0L;
        long l5 = (long)n4 & 0xFFFFFFFFL;
        long l6 = (long)nArray[n5 + 0] & 0xFFFFFFFFL;
        nArray3[n7 + 0] = (int)(l4 += l5 * l6 + ((long)nArray2[n6 + 0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        long l7 = (long)nArray[n5 + 1] & 0xFFFFFFFFL;
        nArray3[n7 + 1] = (int)(l4 += l5 * l7 + l6 + ((long)nArray2[n6 + 1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        long l8 = (long)nArray[n5 + 2] & 0xFFFFFFFFL;
        nArray3[n7 + 2] = (int)(l4 += l5 * l8 + l7 + ((long)nArray2[n6 + 2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        long l9 = (long)nArray[n5 + 3] & 0xFFFFFFFFL;
        nArray3[n7 + 3] = (int)(l4 += l5 * l9 + l8 + ((long)nArray2[n6 + 3] & 0xFFFFFFFFL));
        l4 >>>= 32;
        return l4 += l9;
    }

    public static int mulWordAddExt(int n4, int[] nArray, int n5, int[] nArray2, int n6) {
        long l4 = 0L;
        long l5 = (long)n4 & 0xFFFFFFFFL;
        nArray2[n6 + 0] = (int)(l4 += l5 * ((long)nArray[n5 + 0] & 0xFFFFFFFFL) + ((long)nArray2[n6 + 0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n6 + 1] = (int)(l4 += l5 * ((long)nArray[n5 + 1] & 0xFFFFFFFFL) + ((long)nArray2[n6 + 1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n6 + 2] = (int)(l4 += l5 * ((long)nArray[n5 + 2] & 0xFFFFFFFFL) + ((long)nArray2[n6 + 2] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray2[n6 + 3] = (int)(l4 += l5 * ((long)nArray[n5 + 3] & 0xFFFFFFFFL) + ((long)nArray2[n6 + 3] & 0xFFFFFFFFL));
        return (int)(l4 >>>= 32);
    }

    public static int mul33DWordAdd(int n4, long l4, int[] nArray, int n5) {
        long l5 = 0L;
        long l6 = (long)n4 & 0xFFFFFFFFL;
        long l7 = l4 & 0xFFFFFFFFL;
        nArray[n5 + 0] = (int)(l5 += l6 * l7 + ((long)nArray[n5 + 0] & 0xFFFFFFFFL));
        l5 >>>= 32;
        long l8 = l4 >>> 32;
        nArray[n5 + 1] = (int)(l5 += l6 * l8 + l7 + ((long)nArray[n5 + 1] & 0xFFFFFFFFL));
        l5 >>>= 32;
        nArray[n5 + 2] = (int)(l5 += l8 + ((long)nArray[n5 + 2] & 0xFFFFFFFFL));
        l5 >>>= 32;
        nArray[n5 + 3] = (int)(l5 += (long)nArray[n5 + 3] & 0xFFFFFFFFL);
        return (int)(l5 >>>= 32);
    }

    public static int mul33WordAdd(int n4, int n5, int[] nArray, int n6) {
        long l4 = 0L;
        long l5 = (long)n4 & 0xFFFFFFFFL;
        long l6 = (long)n5 & 0xFFFFFFFFL;
        nArray[n6 + 0] = (int)(l4 += l6 * l5 + ((long)nArray[n6 + 0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray[n6 + 1] = (int)(l4 += l6 + ((long)nArray[n6 + 1] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray[n6 + 2] = (int)(l4 += (long)nArray[n6 + 2] & 0xFFFFFFFFL);
        return (l4 >>>= 32) == 0L ? 0 : Nat.incAt(4, nArray, n6, 3);
    }

    public static int mulWordDwordAdd(int n4, long l4, int[] nArray, int n5) {
        long l5 = 0L;
        long l6 = (long)n4 & 0xFFFFFFFFL;
        nArray[n5 + 0] = (int)(l5 += l6 * (l4 & 0xFFFFFFFFL) + ((long)nArray[n5 + 0] & 0xFFFFFFFFL));
        l5 >>>= 32;
        nArray[n5 + 1] = (int)(l5 += l6 * (l4 >>> 32) + ((long)nArray[n5 + 1] & 0xFFFFFFFFL));
        l5 >>>= 32;
        nArray[n5 + 2] = (int)(l5 += (long)nArray[n5 + 2] & 0xFFFFFFFFL);
        return (l5 >>>= 32) == 0L ? 0 : Nat.incAt(4, nArray, n5, 3);
    }

    public static int mulWordsAdd(int n4, int n5, int[] nArray, int n6) {
        long l4 = 0L;
        long l5 = (long)n4 & 0xFFFFFFFFL;
        long l6 = (long)n5 & 0xFFFFFFFFL;
        nArray[n6 + 0] = (int)(l4 += l6 * l5 + ((long)nArray[n6 + 0] & 0xFFFFFFFFL));
        l4 >>>= 32;
        nArray[n6 + 1] = (int)(l4 += (long)nArray[n6 + 1] & 0xFFFFFFFFL);
        return (l4 >>>= 32) == 0L ? 0 : Nat.incAt(4, nArray, n6, 2);
    }

    public static int mulWord(int n4, int[] nArray, int[] nArray2, int n5) {
        long l4 = 0L;
        long l5 = (long)n4 & 0xFFFFFFFFL;
        int n6 = 0;
        do {
            nArray2[n5 + n6] = (int)(l4 += l5 * ((long)nArray[n6] & 0xFFFFFFFFL));
            l4 >>>= 32;
        } while (++n6 < 4);
        return (int)l4;
    }

    public static void square(int[] nArray, int[] nArray2) {
        long l4;
        long l5;
        long l6 = (long)nArray[0] & 0xFFFFFFFFL;
        int n4 = 0;
        int n5 = 3;
        int n6 = 8;
        do {
            l5 = (long)nArray[n5--] & 0xFFFFFFFFL;
            l4 = l5 * l5;
            nArray2[--n6] = n4 << 31 | (int)(l4 >>> 33);
            nArray2[--n6] = (int)(l4 >>> 1);
            n4 = (int)l4;
        } while (n5 > 0);
        l5 = l6 * l6;
        long l7 = (long)(n4 << 31) & 0xFFFFFFFFL | l5 >>> 33;
        nArray2[0] = (int)l5;
        n4 = (int)(l5 >>> 32) & 1;
        long l8 = (long)nArray[1] & 0xFFFFFFFFL;
        l5 = (long)nArray2[2] & 0xFFFFFFFFL;
        int n7 = (int)(l7 += l8 * l6);
        nArray2[1] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        l5 += l7 >>> 32;
        l4 = (long)nArray[2] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[4] & 0xFFFFFFFFL;
        n7 = (int)(l5 += l4 * l6);
        nArray2[2] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        l9 &= 0xFFFFFFFFL;
        long l11 = (long)nArray[3] & 0xFFFFFFFFL;
        long l12 = ((long)nArray2[5] & 0xFFFFFFFFL) + ((l10 += (l9 += (l5 >>> 32) + l4 * l8) >>> 32) >>> 32);
        l10 &= 0xFFFFFFFFL;
        long l13 = ((long)nArray2[6] & 0xFFFFFFFFL) + (l12 >>> 32);
        l12 &= 0xFFFFFFFFL;
        n7 = (int)(l9 += l11 * l6);
        nArray2[3] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        l13 += (l12 += ((l10 += (l9 >>> 32) + l11 * l8) >>> 32) + l11 * l4) >>> 32;
        n7 = (int)l10;
        nArray2[4] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        n7 = (int)(l12 &= 0xFFFFFFFFL);
        nArray2[5] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        n7 = (int)l13;
        nArray2[6] = n7 << 1 | n4;
        n4 = n7 >>> 31;
        n7 = nArray2[7] + (int)(l13 >>> 32);
        nArray2[7] = n7 << 1 | n4;
    }

    public static void square(int[] nArray, int n4, int[] nArray2, int n5) {
        long l4;
        long l5;
        long l6 = (long)nArray[n4 + 0] & 0xFFFFFFFFL;
        int n6 = 0;
        int n7 = 3;
        int n8 = 8;
        do {
            l5 = (long)nArray[n4 + n7--] & 0xFFFFFFFFL;
            l4 = l5 * l5;
            nArray2[n5 + --n8] = n6 << 31 | (int)(l4 >>> 33);
            nArray2[n5 + --n8] = (int)(l4 >>> 1);
            n6 = (int)l4;
        } while (n7 > 0);
        l5 = l6 * l6;
        long l7 = (long)(n6 << 31) & 0xFFFFFFFFL | l5 >>> 33;
        nArray2[n5 + 0] = (int)l5;
        n6 = (int)(l5 >>> 32) & 1;
        long l8 = (long)nArray[n4 + 1] & 0xFFFFFFFFL;
        l5 = (long)nArray2[n5 + 2] & 0xFFFFFFFFL;
        int n9 = (int)(l7 += l8 * l6);
        nArray2[n5 + 1] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        l5 += l7 >>> 32;
        l4 = (long)nArray[n4 + 2] & 0xFFFFFFFFL;
        long l9 = (long)nArray2[n5 + 3] & 0xFFFFFFFFL;
        long l10 = (long)nArray2[n5 + 4] & 0xFFFFFFFFL;
        n9 = (int)(l5 += l4 * l6);
        nArray2[n5 + 2] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        l9 &= 0xFFFFFFFFL;
        long l11 = (long)nArray[n4 + 3] & 0xFFFFFFFFL;
        long l12 = ((long)nArray2[n5 + 5] & 0xFFFFFFFFL) + ((l10 += (l9 += (l5 >>> 32) + l4 * l8) >>> 32) >>> 32);
        l10 &= 0xFFFFFFFFL;
        long l13 = ((long)nArray2[n5 + 6] & 0xFFFFFFFFL) + (l12 >>> 32);
        l12 &= 0xFFFFFFFFL;
        n9 = (int)(l9 += l11 * l6);
        nArray2[n5 + 3] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        l13 += (l12 += ((l10 += (l9 >>> 32) + l11 * l8) >>> 32) + l11 * l4) >>> 32;
        n9 = (int)l10;
        nArray2[n5 + 4] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        n9 = (int)l12;
        nArray2[n5 + 5] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        n9 = (int)l13;
        nArray2[n5 + 6] = n9 << 1 | n6;
        n6 = n9 >>> 31;
        n9 = nArray2[n5 + 7] + (int)(l13 >>> 32);
        nArray2[n5 + 7] = n9 << 1 | n6;
    }

    public static int sub(int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        nArray3[0] = (int)(l4 += ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[1] = (int)(l4 += ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[2] = (int)(l4 += ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[3] = (int)(l4 += ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL));
        return (int)(l4 >>= 32);
    }

    public static int sub(int[] nArray, int n4, int[] nArray2, int n5, int[] nArray3, int n6) {
        long l4 = 0L;
        nArray3[n6 + 0] = (int)(l4 += ((long)nArray[n4 + 0] & 0xFFFFFFFFL) - ((long)nArray2[n5 + 0] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[n6 + 1] = (int)(l4 += ((long)nArray[n4 + 1] & 0xFFFFFFFFL) - ((long)nArray2[n5 + 1] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[n6 + 2] = (int)(l4 += ((long)nArray[n4 + 2] & 0xFFFFFFFFL) - ((long)nArray2[n5 + 2] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[n6 + 3] = (int)(l4 += ((long)nArray[n4 + 3] & 0xFFFFFFFFL) - ((long)nArray2[n5 + 3] & 0xFFFFFFFFL));
        return (int)(l4 >>= 32);
    }

    public static int subBothFrom(int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = 0L;
        nArray3[0] = (int)(l4 += ((long)nArray3[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[1] = (int)(l4 += ((long)nArray3[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[2] = (int)(l4 += ((long)nArray3[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray3[3] = (int)(l4 += ((long)nArray3[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL));
        return (int)(l4 >>= 32);
    }

    public static int subFrom(int[] nArray, int[] nArray2) {
        long l4 = 0L;
        nArray2[0] = (int)(l4 += ((long)nArray2[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[1] = (int)(l4 += ((long)nArray2[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[2] = (int)(l4 += ((long)nArray2[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[3] = (int)(l4 += ((long)nArray2[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL));
        return (int)(l4 >>= 32);
    }

    public static int subFrom(int[] nArray, int n4, int[] nArray2, int n5) {
        long l4 = 0L;
        nArray2[n5 + 0] = (int)(l4 += ((long)nArray2[n5 + 0] & 0xFFFFFFFFL) - ((long)nArray[n4 + 0] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[n5 + 1] = (int)(l4 += ((long)nArray2[n5 + 1] & 0xFFFFFFFFL) - ((long)nArray[n4 + 1] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[n5 + 2] = (int)(l4 += ((long)nArray2[n5 + 2] & 0xFFFFFFFFL) - ((long)nArray[n4 + 2] & 0xFFFFFFFFL));
        l4 >>= 32;
        nArray2[n5 + 3] = (int)(l4 += ((long)nArray2[n5 + 3] & 0xFFFFFFFFL) - ((long)nArray[n4 + 3] & 0xFFFFFFFFL));
        return (int)(l4 >>= 32);
    }

    public static BigInteger toBigInteger(int[] nArray) {
        byte[] byArray = new byte[16];
        for (int i4 = 0; i4 < 4; ++i4) {
            int n4 = nArray[i4];
            if (n4 == 0) continue;
            Pack.intToBigEndian(n4, byArray, 3 - i4 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static BigInteger toBigInteger64(long[] lArray) {
        byte[] byArray = new byte[16];
        for (int i4 = 0; i4 < 2; ++i4) {
            long l4 = lArray[i4];
            if (l4 == 0L) continue;
            Pack.longToBigEndian(l4, byArray, 1 - i4 << 3);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int[] nArray) {
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
    }
}

