/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Nat256;

public class SecT193Field {
    private static final long M01 = 1L;
    private static final long M49 = 0x1FFFFFFFFFFFFL;

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
        lArray3[4] = lArray[4] ^ lArray2[4];
        lArray3[5] = lArray[5] ^ lArray2[5];
        lArray3[6] = lArray[6] ^ lArray2[6];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0] ^ 1L;
        lArray2[1] = lArray[1];
        lArray2[2] = lArray[2];
        lArray2[3] = lArray[3];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        long[] lArray = Nat256.fromBigInteger64(bigInteger);
        SecT193Field.reduce63(lArray, 0);
        return lArray;
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (Nat256.isZero64(lArray)) {
            throw new IllegalStateException();
        }
        long[] lArray3 = Nat256.create64();
        long[] lArray4 = Nat256.create64();
        SecT193Field.square(lArray, lArray3);
        SecT193Field.squareN(lArray3, 1, lArray4);
        SecT193Field.multiply(lArray3, lArray4, lArray3);
        SecT193Field.squareN(lArray4, 1, lArray4);
        SecT193Field.multiply(lArray3, lArray4, lArray3);
        SecT193Field.squareN(lArray3, 3, lArray4);
        SecT193Field.multiply(lArray3, lArray4, lArray3);
        SecT193Field.squareN(lArray3, 6, lArray4);
        SecT193Field.multiply(lArray3, lArray4, lArray3);
        SecT193Field.squareN(lArray3, 12, lArray4);
        SecT193Field.multiply(lArray3, lArray4, lArray3);
        SecT193Field.squareN(lArray3, 24, lArray4);
        SecT193Field.multiply(lArray3, lArray4, lArray3);
        SecT193Field.squareN(lArray3, 48, lArray4);
        SecT193Field.multiply(lArray3, lArray4, lArray3);
        SecT193Field.squareN(lArray3, 96, lArray4);
        SecT193Field.multiply(lArray3, lArray4, lArray2);
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat256.createExt64();
        SecT193Field.implMultiply(lArray, lArray2, lArray4);
        SecT193Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat256.createExt64();
        SecT193Field.implMultiply(lArray, lArray2, lArray4);
        SecT193Field.addExt(lArray3, lArray4, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        long l10 = lArray[6];
        l6 ^= l10 << 63;
        l7 ^= l10 >>> 1 ^ l10 << 14;
        l5 ^= l9 << 63;
        l6 ^= l9 >>> 1 ^ l9 << 14;
        long l11 = (l7 ^= l9 >>> 50) >>> 1;
        lArray2[0] = (l4 ^= (l8 ^= l10 >>> 50) << 63) ^ l11 ^ l11 << 15;
        lArray2[1] = (l5 ^= l8 >>> 1 ^ l8 << 14) ^ l11 >>> 49;
        lArray2[2] = l6 ^= l8 >>> 50;
        lArray2[3] = l7 & 1L;
    }

    public static void reduce63(long[] lArray, int n4) {
        long l4 = lArray[n4 + 3];
        long l5 = l4 >>> 1;
        int n5 = n4;
        lArray[n5] = lArray[n5] ^ (l5 ^ l5 << 15);
        int n6 = n4 + 1;
        lArray[n6] = lArray[n6] ^ l5 >>> 49;
        lArray[n4 + 3] = l4 & 1L;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l4 = Interleave.unshuffle(lArray[0]);
        long l5 = Interleave.unshuffle(lArray[1]);
        long l6 = l4 & 0xFFFFFFFFL | l5 << 32;
        long l7 = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        l4 = Interleave.unshuffle(lArray[2]);
        long l8 = l4 & 0xFFFFFFFFL ^ lArray[3] << 32;
        long l9 = l4 >>> 32;
        lArray2[0] = l6 ^ l7 << 8;
        lArray2[1] = l8 ^ l9 << 8 ^ l7 >>> 56 ^ l7 << 33;
        lArray2[2] = l9 >>> 56 ^ l9 << 33 ^ l7 >>> 31;
        lArray2[3] = l9 >>> 31;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT193Field.implSquare(lArray, lArray3);
        SecT193Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT193Field.implSquare(lArray, lArray3);
        SecT193Field.addExt(lArray2, lArray3, lArray2);
    }

    public static void squareN(long[] lArray, int n4, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT193Field.implSquare(lArray, lArray3);
        SecT193Field.reduce(lArray3, lArray2);
        while (--n4 > 0) {
            SecT193Field.implSquare(lArray2, lArray3);
            SecT193Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)lArray[0] & 1;
    }

    protected static void implCompactExt(long[] lArray) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        long l10 = lArray[6];
        long l11 = lArray[7];
        lArray[0] = l4 ^ l5 << 49;
        lArray[1] = l5 >>> 15 ^ l6 << 34;
        lArray[2] = l6 >>> 30 ^ l7 << 19;
        lArray[3] = l7 >>> 45 ^ l8 << 4 ^ l9 << 53;
        lArray[4] = l8 >>> 60 ^ l10 << 38 ^ l9 >>> 11;
        lArray[5] = l10 >>> 26 ^ l11 << 23;
        lArray[6] = l11 >>> 41;
        lArray[7] = 0L;
    }

    protected static void implExpand(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        lArray2[0] = l4 & 0x1FFFFFFFFFFFFL;
        lArray2[1] = (l4 >>> 49 ^ l5 << 15) & 0x1FFFFFFFFFFFFL;
        lArray2[2] = (l5 >>> 34 ^ l6 << 30) & 0x1FFFFFFFFFFFFL;
        lArray2[3] = l6 >>> 19 ^ l7 << 45;
    }

    protected static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        int n4;
        long[] lArray4 = new long[4];
        long[] lArray5 = new long[4];
        SecT193Field.implExpand(lArray, lArray4);
        SecT193Field.implExpand(lArray2, lArray5);
        SecT193Field.implMulwAcc(lArray4[0], lArray5[0], lArray3, 0);
        SecT193Field.implMulwAcc(lArray4[1], lArray5[1], lArray3, 1);
        SecT193Field.implMulwAcc(lArray4[2], lArray5[2], lArray3, 2);
        SecT193Field.implMulwAcc(lArray4[3], lArray5[3], lArray3, 3);
        for (n4 = 5; n4 > 0; --n4) {
            int n5 = n4;
            lArray3[n5] = lArray3[n5] ^ lArray3[n4 - 1];
        }
        SecT193Field.implMulwAcc(lArray4[0] ^ lArray4[1], lArray5[0] ^ lArray5[1], lArray3, 1);
        SecT193Field.implMulwAcc(lArray4[2] ^ lArray4[3], lArray5[2] ^ lArray5[3], lArray3, 3);
        for (n4 = 7; n4 > 1; --n4) {
            int n6 = n4;
            lArray3[n6] = lArray3[n6] ^ lArray3[n4 - 2];
        }
        long l4 = lArray4[0] ^ lArray4[2];
        long l5 = lArray4[1] ^ lArray4[3];
        long l6 = lArray5[0] ^ lArray5[2];
        long l7 = lArray5[1] ^ lArray5[3];
        SecT193Field.implMulwAcc(l4 ^ l5, l6 ^ l7, lArray3, 3);
        long[] lArray6 = new long[3];
        SecT193Field.implMulwAcc(l4, l6, lArray6, 0);
        SecT193Field.implMulwAcc(l5, l7, lArray6, 1);
        long l8 = lArray6[0];
        long l9 = lArray6[1];
        long l10 = lArray6[2];
        lArray3[2] = lArray3[2] ^ l8;
        lArray3[3] = lArray3[3] ^ (l8 ^ l9);
        lArray3[4] = lArray3[4] ^ (l10 ^ l9);
        lArray3[5] = lArray3[5] ^ l10;
        SecT193Field.implCompactExt(lArray3);
    }

    protected static void implMulwAcc(long l4, long l5, long[] lArray, int n4) {
        long[] lArray2 = new long[8];
        lArray2[1] = l5;
        lArray2[2] = lArray2[1] << 1;
        lArray2[3] = lArray2[2] ^ l5;
        lArray2[4] = lArray2[2] << 1;
        lArray2[5] = lArray2[4] ^ l5;
        lArray2[6] = lArray2[3] << 1;
        lArray2[7] = lArray2[6] ^ l5;
        int n5 = (int)l4;
        long l6 = 0L;
        long l7 = lArray2[n5 & 7] ^ lArray2[n5 >>> 3 & 7] << 3;
        int n6 = 36;
        do {
            n5 = (int)(l4 >>> n6);
            long l8 = lArray2[n5 & 7] ^ lArray2[n5 >>> 3 & 7] << 3 ^ lArray2[n5 >>> 6 & 7] << 6 ^ lArray2[n5 >>> 9 & 7] << 9 ^ lArray2[n5 >>> 12 & 7] << 12;
            l7 ^= l8 << n6;
            l6 ^= l8 >>> -n6;
        } while ((n6 -= 15) > 0);
        int n7 = n4;
        lArray[n7] = lArray[n7] ^ l7 & 0x1FFFFFFFFFFFFL;
        int n8 = n4 + 1;
        lArray[n8] = lArray[n8] ^ (l7 >>> 49 ^ l6 << 15);
    }

    protected static void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray[0], lArray2, 0);
        Interleave.expand64To128(lArray[1], lArray2, 2);
        Interleave.expand64To128(lArray[2], lArray2, 4);
        lArray2[6] = lArray[3] & 1L;
    }
}

