/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Nat192;

public class SecT163Field {
    private static final long M35 = 0x7FFFFFFFFL;
    private static final long M55 = 0x7FFFFFFFFFFFFFL;
    private static final long[] ROOT_Z = new long[]{-5270498306774157648L, 5270498306774195053L, 0x492492492L};

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
        lArray3[4] = lArray[4] ^ lArray2[4];
        lArray3[5] = lArray[5] ^ lArray2[5];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0] ^ 1L;
        lArray2[1] = lArray[1];
        lArray2[2] = lArray[2];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        long[] lArray = Nat192.fromBigInteger64(bigInteger);
        SecT163Field.reduce29(lArray, 0);
        return lArray;
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (Nat192.isZero64(lArray)) {
            throw new IllegalStateException();
        }
        long[] lArray3 = Nat192.create64();
        long[] lArray4 = Nat192.create64();
        SecT163Field.square(lArray, lArray3);
        SecT163Field.squareN(lArray3, 1, lArray4);
        SecT163Field.multiply(lArray3, lArray4, lArray3);
        SecT163Field.squareN(lArray4, 1, lArray4);
        SecT163Field.multiply(lArray3, lArray4, lArray3);
        SecT163Field.squareN(lArray3, 3, lArray4);
        SecT163Field.multiply(lArray3, lArray4, lArray3);
        SecT163Field.squareN(lArray4, 3, lArray4);
        SecT163Field.multiply(lArray3, lArray4, lArray3);
        SecT163Field.squareN(lArray3, 9, lArray4);
        SecT163Field.multiply(lArray3, lArray4, lArray3);
        SecT163Field.squareN(lArray4, 9, lArray4);
        SecT163Field.multiply(lArray3, lArray4, lArray3);
        SecT163Field.squareN(lArray3, 27, lArray4);
        SecT163Field.multiply(lArray3, lArray4, lArray3);
        SecT163Field.squareN(lArray4, 27, lArray4);
        SecT163Field.multiply(lArray3, lArray4, lArray3);
        SecT163Field.squareN(lArray3, 81, lArray4);
        SecT163Field.multiply(lArray3, lArray4, lArray2);
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat192.createExt64();
        SecT163Field.implMultiply(lArray, lArray2, lArray4);
        SecT163Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat192.createExt64();
        SecT163Field.implMultiply(lArray, lArray2, lArray4);
        SecT163Field.addExt(lArray3, lArray4, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        l6 ^= l9 << 29 ^ l9 << 32 ^ l9 << 35 ^ l9 << 36;
        l5 ^= l8 << 29 ^ l8 << 32 ^ l8 << 35 ^ l8 << 36;
        long l10 = (l6 ^= l8 >>> 35 ^ l8 >>> 32 ^ l8 >>> 29 ^ l8 >>> 28) >>> 35;
        lArray2[0] = (l4 ^= (l7 ^= l9 >>> 35 ^ l9 >>> 32 ^ l9 >>> 29 ^ l9 >>> 28) << 29 ^ l7 << 32 ^ l7 << 35 ^ l7 << 36) ^ l10 ^ l10 << 3 ^ l10 << 6 ^ l10 << 7;
        lArray2[1] = l5 ^= l7 >>> 35 ^ l7 >>> 32 ^ l7 >>> 29 ^ l7 >>> 28;
        lArray2[2] = l6 & 0x7FFFFFFFFL;
    }

    public static void reduce29(long[] lArray, int n4) {
        long l4 = lArray[n4 + 2];
        long l5 = l4 >>> 35;
        int n5 = n4;
        lArray[n5] = lArray[n5] ^ (l5 ^ l5 << 3 ^ l5 << 6 ^ l5 << 7);
        lArray[n4 + 2] = l4 & 0x7FFFFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat192.create64();
        long l4 = Interleave.unshuffle(lArray[0]);
        long l5 = Interleave.unshuffle(lArray[1]);
        long l6 = l4 & 0xFFFFFFFFL | l5 << 32;
        lArray3[0] = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        l4 = Interleave.unshuffle(lArray[2]);
        long l7 = l4 & 0xFFFFFFFFL;
        lArray3[1] = l4 >>> 32;
        SecT163Field.multiply(lArray3, ROOT_Z, lArray2);
        lArray2[0] = lArray2[0] ^ l6;
        lArray2[1] = lArray2[1] ^ l7;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat192.createExt64();
        SecT163Field.implSquare(lArray, lArray3);
        SecT163Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat192.createExt64();
        SecT163Field.implSquare(lArray, lArray3);
        SecT163Field.addExt(lArray2, lArray3, lArray2);
    }

    public static void squareN(long[] lArray, int n4, long[] lArray2) {
        long[] lArray3 = Nat192.createExt64();
        SecT163Field.implSquare(lArray, lArray3);
        SecT163Field.reduce(lArray3, lArray2);
        while (--n4 > 0) {
            SecT163Field.implSquare(lArray2, lArray3);
            SecT163Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)(lArray[0] ^ lArray[2] >>> 29) & 1;
    }

    protected static void implCompactExt(long[] lArray) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        lArray[0] = l4 ^ l5 << 55;
        lArray[1] = l5 >>> 9 ^ l6 << 46;
        lArray[2] = l6 >>> 18 ^ l7 << 37;
        lArray[3] = l7 >>> 27 ^ l8 << 28;
        lArray[4] = l8 >>> 36 ^ l9 << 19;
        lArray[5] = l9 >>> 45;
    }

    protected static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        l6 = l5 >>> 46 ^ l6 << 18;
        l5 = (l4 >>> 55 ^ l5 << 9) & 0x7FFFFFFFFFFFFFL;
        l4 &= 0x7FFFFFFFFFFFFFL;
        long l7 = lArray2[0];
        long l8 = lArray2[1];
        long l9 = lArray2[2];
        l9 = l8 >>> 46 ^ l9 << 18;
        l8 = (l7 >>> 55 ^ l8 << 9) & 0x7FFFFFFFFFFFFFL;
        long[] lArray4 = new long[10];
        SecT163Field.implMulw(l4, l7 &= 0x7FFFFFFFFFFFFFL, lArray4, 0);
        SecT163Field.implMulw(l6, l9, lArray4, 2);
        long l10 = l4 ^ l5 ^ l6;
        long l11 = l7 ^ l8 ^ l9;
        SecT163Field.implMulw(l10, l11, lArray4, 4);
        long l12 = l5 << 1 ^ l6 << 2;
        long l13 = l8 << 1 ^ l9 << 2;
        SecT163Field.implMulw(l4 ^ l12, l7 ^ l13, lArray4, 6);
        SecT163Field.implMulw(l10 ^ l12, l11 ^ l13, lArray4, 8);
        long l14 = lArray4[6] ^ lArray4[8];
        long l15 = lArray4[7] ^ lArray4[9];
        long l16 = l14 << 1 ^ lArray4[6];
        long l17 = l14 ^ l15 << 1 ^ lArray4[7];
        long l18 = l15;
        long l19 = lArray4[0];
        long l20 = lArray4[1] ^ lArray4[0] ^ lArray4[4];
        long l21 = lArray4[1] ^ lArray4[5];
        long l22 = l19 ^ l16 ^ lArray4[2] << 4 ^ lArray4[2] << 1;
        long l23 = l20 ^ l17 ^ lArray4[3] << 4 ^ lArray4[3] << 1;
        long l24 = l21 ^ l18;
        l23 ^= l22 >>> 55;
        l22 &= 0x7FFFFFFFFFFFFFL;
        l24 ^= l23 >>> 55;
        l22 = l22 >>> 1 ^ ((l23 &= 0x7FFFFFFFFFFFFFL) & 1L) << 54;
        l23 = l23 >>> 1 ^ (l24 & 1L) << 54;
        l24 >>>= 1;
        l22 ^= l22 << 1;
        l22 ^= l22 << 2;
        l22 ^= l22 << 4;
        l22 ^= l22 << 8;
        l22 ^= l22 << 16;
        l22 ^= l22 << 32;
        l23 ^= (l22 &= 0x7FFFFFFFFFFFFFL) >>> 54;
        l23 ^= l23 << 1;
        l23 ^= l23 << 2;
        l23 ^= l23 << 4;
        l23 ^= l23 << 8;
        l23 ^= l23 << 16;
        l23 ^= l23 << 32;
        l24 ^= (l23 &= 0x7FFFFFFFFFFFFFL) >>> 54;
        l24 ^= l24 << 1;
        l24 ^= l24 << 2;
        l24 ^= l24 << 4;
        l24 ^= l24 << 8;
        l24 ^= l24 << 16;
        l24 ^= l24 << 32;
        lArray3[0] = l19;
        lArray3[1] = l20 ^ l22 ^ lArray4[2];
        lArray3[2] = l21 ^ l23 ^ l22 ^ lArray4[3];
        lArray3[3] = l24 ^ l23;
        lArray3[4] = l24 ^ lArray4[2];
        lArray3[5] = lArray4[3];
        SecT163Field.implCompactExt(lArray3);
    }

    protected static void implMulw(long l4, long l5, long[] lArray, int n4) {
        long[] lArray2 = new long[8];
        lArray2[1] = l5;
        lArray2[2] = lArray2[1] << 1;
        lArray2[3] = lArray2[2] ^ l5;
        lArray2[4] = lArray2[2] << 1;
        lArray2[5] = lArray2[4] ^ l5;
        lArray2[6] = lArray2[3] << 1;
        lArray2[7] = lArray2[6] ^ l5;
        int n5 = (int)l4;
        long l6 = 0L;
        long l7 = lArray2[n5 & 3];
        int n6 = 47;
        do {
            n5 = (int)(l4 >>> n6);
            long l8 = lArray2[n5 & 7] ^ lArray2[n5 >>> 3 & 7] << 3 ^ lArray2[n5 >>> 6 & 7] << 6;
            l7 ^= l8 << n6;
            l6 ^= l8 >>> -n6;
        } while ((n6 -= 9) > 0);
        lArray[n4] = l7 & 0x7FFFFFFFFFFFFFL;
        lArray[n4 + 1] = l7 >>> 55 ^ l6 << 9;
    }

    protected static void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray[0], lArray2, 0);
        Interleave.expand64To128(lArray[1], lArray2, 2);
        long l4 = lArray[2];
        lArray2[4] = Interleave.expand32to64((int)l4);
        lArray2[5] = (long)Interleave.expand8to16((int)(l4 >>> 32)) & 0xFFFFFFFFL;
    }
}

