/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.math.raw.Nat192;

public class SecT131Field {
    private static final long M03 = 7L;
    private static final long M44 = 0xFFFFFFFFFFFL;
    private static final long[] ROOT_Z = new long[]{2791191049453778211L, 2791191049453778402L, 6L};

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
        lArray3[4] = lArray[4] ^ lArray2[4];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0] ^ 1L;
        lArray2[1] = lArray[1];
        lArray2[2] = lArray[2];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        long[] lArray = Nat192.fromBigInteger64(bigInteger);
        SecT131Field.reduce61(lArray, 0);
        return lArray;
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (Nat192.isZero64(lArray)) {
            throw new IllegalStateException();
        }
        long[] lArray3 = Nat192.create64();
        long[] lArray4 = Nat192.create64();
        SecT131Field.square(lArray, lArray3);
        SecT131Field.multiply(lArray3, lArray, lArray3);
        SecT131Field.squareN(lArray3, 2, lArray4);
        SecT131Field.multiply(lArray4, lArray3, lArray4);
        SecT131Field.squareN(lArray4, 4, lArray3);
        SecT131Field.multiply(lArray3, lArray4, lArray3);
        SecT131Field.squareN(lArray3, 8, lArray4);
        SecT131Field.multiply(lArray4, lArray3, lArray4);
        SecT131Field.squareN(lArray4, 16, lArray3);
        SecT131Field.multiply(lArray3, lArray4, lArray3);
        SecT131Field.squareN(lArray3, 32, lArray4);
        SecT131Field.multiply(lArray4, lArray3, lArray4);
        SecT131Field.square(lArray4, lArray4);
        SecT131Field.multiply(lArray4, lArray, lArray4);
        SecT131Field.squareN(lArray4, 65, lArray3);
        SecT131Field.multiply(lArray3, lArray4, lArray3);
        SecT131Field.square(lArray3, lArray2);
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat192.createExt64();
        SecT131Field.implMultiply(lArray, lArray2, lArray4);
        SecT131Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat192.createExt64();
        SecT131Field.implMultiply(lArray, lArray2, lArray4);
        SecT131Field.addExt(lArray3, lArray4, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        l5 ^= l8 << 61 ^ l8 << 63;
        l6 ^= l8 >>> 3 ^ l8 >>> 1 ^ l8 ^ l8 << 5;
        long l9 = (l6 ^= l7 >>> 59) >>> 3;
        lArray2[0] = (l4 ^= (l7 ^= l8 >>> 59) << 61 ^ l7 << 63) ^ l9 ^ l9 << 2 ^ l9 << 3 ^ l9 << 8;
        lArray2[1] = (l5 ^= l7 >>> 3 ^ l7 >>> 1 ^ l7 ^ l7 << 5) ^ l9 >>> 56;
        lArray2[2] = l6 & 7L;
    }

    public static void reduce61(long[] lArray, int n4) {
        long l4 = lArray[n4 + 2];
        long l5 = l4 >>> 3;
        int n5 = n4;
        lArray[n5] = lArray[n5] ^ (l5 ^ l5 << 2 ^ l5 << 3 ^ l5 << 8);
        int n6 = n4 + 1;
        lArray[n6] = lArray[n6] ^ l5 >>> 56;
        lArray[n4 + 2] = l4 & 7L;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat192.create64();
        long l4 = Interleave.unshuffle(lArray[0]);
        long l5 = Interleave.unshuffle(lArray[1]);
        long l6 = l4 & 0xFFFFFFFFL | l5 << 32;
        lArray3[0] = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        l4 = Interleave.unshuffle(lArray[2]);
        long l7 = l4 & 0xFFFFFFFFL;
        lArray3[1] = l4 >>> 32;
        SecT131Field.multiply(lArray3, ROOT_Z, lArray2);
        lArray2[0] = lArray2[0] ^ l6;
        lArray2[1] = lArray2[1] ^ l7;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat.create64(5);
        SecT131Field.implSquare(lArray, lArray3);
        SecT131Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat.create64(5);
        SecT131Field.implSquare(lArray, lArray3);
        SecT131Field.addExt(lArray2, lArray3, lArray2);
    }

    public static void squareN(long[] lArray, int n4, long[] lArray2) {
        long[] lArray3 = Nat.create64(5);
        SecT131Field.implSquare(lArray, lArray3);
        SecT131Field.reduce(lArray3, lArray2);
        while (--n4 > 0) {
            SecT131Field.implSquare(lArray2, lArray3);
            SecT131Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)(lArray[0] ^ lArray[1] >>> 59 ^ lArray[2] >>> 1) & 1;
    }

    protected static void implCompactExt(long[] lArray) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        lArray[0] = l4 ^ l5 << 44;
        lArray[1] = l5 >>> 20 ^ l6 << 24;
        lArray[2] = l6 >>> 40 ^ l7 << 4 ^ l8 << 48;
        lArray[3] = l7 >>> 60 ^ l9 << 28 ^ l8 >>> 16;
        lArray[4] = l9 >>> 36;
        lArray[5] = 0L;
    }

    protected static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        l6 = (l5 >>> 24 ^ l6 << 40) & 0xFFFFFFFFFFFL;
        l5 = (l4 >>> 44 ^ l5 << 20) & 0xFFFFFFFFFFFL;
        l4 &= 0xFFFFFFFFFFFL;
        long l7 = lArray2[0];
        long l8 = lArray2[1];
        long l9 = lArray2[2];
        l9 = (l8 >>> 24 ^ l9 << 40) & 0xFFFFFFFFFFFL;
        l8 = (l7 >>> 44 ^ l8 << 20) & 0xFFFFFFFFFFFL;
        long[] lArray4 = new long[10];
        SecT131Field.implMulw(l4, l7 &= 0xFFFFFFFFFFFL, lArray4, 0);
        SecT131Field.implMulw(l6, l9, lArray4, 2);
        long l10 = l4 ^ l5 ^ l6;
        long l11 = l7 ^ l8 ^ l9;
        SecT131Field.implMulw(l10, l11, lArray4, 4);
        long l12 = l5 << 1 ^ l6 << 2;
        long l13 = l8 << 1 ^ l9 << 2;
        SecT131Field.implMulw(l4 ^ l12, l7 ^ l13, lArray4, 6);
        SecT131Field.implMulw(l10 ^ l12, l11 ^ l13, lArray4, 8);
        long l14 = lArray4[6] ^ lArray4[8];
        long l15 = lArray4[7] ^ lArray4[9];
        long l16 = l14 << 1 ^ lArray4[6];
        long l17 = l14 ^ l15 << 1 ^ lArray4[7];
        long l18 = l15;
        long l19 = lArray4[0];
        long l20 = lArray4[1] ^ lArray4[0] ^ lArray4[4];
        long l21 = lArray4[1] ^ lArray4[5];
        long l22 = l19 ^ l16 ^ lArray4[2] << 4 ^ lArray4[2] << 1;
        long l23 = l20 ^ l17 ^ lArray4[3] << 4 ^ lArray4[3] << 1;
        long l24 = l21 ^ l18;
        l23 ^= l22 >>> 44;
        l22 &= 0xFFFFFFFFFFFL;
        l24 ^= l23 >>> 44;
        l22 = l22 >>> 1 ^ ((l23 &= 0xFFFFFFFFFFFL) & 1L) << 43;
        l23 = l23 >>> 1 ^ (l24 & 1L) << 43;
        l24 >>>= 1;
        l22 ^= l22 << 1;
        l22 ^= l22 << 2;
        l22 ^= l22 << 4;
        l22 ^= l22 << 8;
        l22 ^= l22 << 16;
        l22 ^= l22 << 32;
        l23 ^= (l22 &= 0xFFFFFFFFFFFL) >>> 43;
        l23 ^= l23 << 1;
        l23 ^= l23 << 2;
        l23 ^= l23 << 4;
        l23 ^= l23 << 8;
        l23 ^= l23 << 16;
        l23 ^= l23 << 32;
        l24 ^= (l23 &= 0xFFFFFFFFFFFL) >>> 43;
        l24 ^= l24 << 1;
        l24 ^= l24 << 2;
        l24 ^= l24 << 4;
        l24 ^= l24 << 8;
        l24 ^= l24 << 16;
        l24 ^= l24 << 32;
        lArray3[0] = l19;
        lArray3[1] = l20 ^ l22 ^ lArray4[2];
        lArray3[2] = l21 ^ l23 ^ l22 ^ lArray4[3];
        lArray3[3] = l24 ^ l23;
        lArray3[4] = l24 ^ lArray4[2];
        lArray3[5] = lArray4[3];
        SecT131Field.implCompactExt(lArray3);
    }

    protected static void implMulw(long l4, long l5, long[] lArray, int n4) {
        long[] lArray2 = new long[8];
        lArray2[1] = l5;
        lArray2[2] = lArray2[1] << 1;
        lArray2[3] = lArray2[2] ^ l5;
        lArray2[4] = lArray2[2] << 1;
        lArray2[5] = lArray2[4] ^ l5;
        lArray2[6] = lArray2[3] << 1;
        lArray2[7] = lArray2[6] ^ l5;
        int n5 = (int)l4;
        long l6 = 0L;
        long l7 = lArray2[n5 & 7] ^ lArray2[n5 >>> 3 & 7] << 3 ^ lArray2[n5 >>> 6 & 7] << 6;
        int n6 = 33;
        do {
            n5 = (int)(l4 >>> n6);
            long l8 = lArray2[n5 & 7] ^ lArray2[n5 >>> 3 & 7] << 3 ^ lArray2[n5 >>> 6 & 7] << 6 ^ lArray2[n5 >>> 9 & 7] << 9;
            l7 ^= l8 << n6;
            l6 ^= l8 >>> -n6;
        } while ((n6 -= 12) > 0);
        lArray[n4] = l7 & 0xFFFFFFFFFFFL;
        lArray[n4 + 1] = l7 >>> 44 ^ l6 << 20;
    }

    protected static void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray[0], lArray2, 0);
        Interleave.expand64To128(lArray[1], lArray2, 2);
        lArray2[4] = (long)Interleave.expand8to16((int)lArray[2]) & 0xFFFFFFFFL;
    }
}

