/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.AbstractECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.LongArray;
import org.bouncycastle.math.ec.WNafPreCompInfo;
import org.bouncycastle.math.ec.WNafUtil;

public class WNafL2RMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        ECPoint[] eCPointArray;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = Math.max(2, Math.min(16, this.getWindowSize(bigInteger.bitLength())));
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n8, true);
        ECPoint[] eCPointArray2 = wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray3 = wNafPreCompInfo.getPreCompNeg();
        int[] nArray = WNafUtil.generateCompactWindowNaf(n8, bigInteger);
        ECPoint eCPoint2 = eCPoint.getCurve().getInfinity();
        int n9 = nArray.length;
        if (n9 > 1) {
            n7 = nArray[--n9];
            n6 = n7 >> 16;
            n5 = n7 & 0xFFFF;
            n4 = Math.abs(n6);
            ECPoint[] eCPointArray4 = eCPointArray = n6 < 0 ? eCPointArray3 : eCPointArray2;
            if (n4 << 2 < 1 << n8) {
                byte by = LongArray.bitLengths[n4];
                int n10 = n8 - by;
                int n11 = n4 ^ 1 << by - 1;
                int n12 = (1 << n8 - 1) - 1;
                int n13 = (n11 << n10) + 1;
                eCPoint2 = eCPointArray[n12 >>> 1].add(eCPointArray[n13 >>> 1]);
                n5 -= n10;
            } else {
                eCPoint2 = eCPointArray[n4 >>> 1];
            }
            eCPoint2 = eCPoint2.timesPow2(n5);
        }
        while (n9 > 0) {
            n7 = nArray[--n9];
            n6 = n7 >> 16;
            n5 = n7 & 0xFFFF;
            n4 = Math.abs(n6);
            eCPointArray = n6 < 0 ? eCPointArray3 : eCPointArray2;
            ECPoint eCPoint3 = eCPointArray[n4 >>> 1];
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
            eCPoint2 = eCPoint2.timesPow2(n5);
        }
        return eCPoint2;
    }

    protected int getWindowSize(int n4) {
        return WNafUtil.getWindowSize(n4);
    }
}

