/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.ECPointMap;
import org.bouncycastle.math.ec.WNafPreCompInfo;
import org.bouncycastle.math.ec.WNafUtil;
import org.bouncycastle.math.ec.endo.ECEndomorphism;
import org.bouncycastle.math.ec.endo.GLVEndomorphism;
import org.bouncycastle.math.field.FiniteField;
import org.bouncycastle.math.field.PolynomialExtensionField;

public class ECAlgorithms {
    public static boolean isF2mCurve(ECCurve eCCurve) {
        return ECAlgorithms.isF2mField(eCCurve.getField());
    }

    public static boolean isF2mField(FiniteField finiteField) {
        return finiteField.getDimension() > 1 && finiteField.getCharacteristic().equals(ECConstants.TWO) && finiteField instanceof PolynomialExtensionField;
    }

    public static boolean isFpCurve(ECCurve eCCurve) {
        return ECAlgorithms.isFpField(eCCurve.getField());
    }

    public static boolean isFpField(FiniteField finiteField) {
        return finiteField.getDimension() == 1;
    }

    public static ECPoint sumOfMultiplies(ECPoint[] eCPointArray, BigInteger[] bigIntegerArray) {
        if (eCPointArray == null || bigIntegerArray == null || eCPointArray.length != bigIntegerArray.length || eCPointArray.length < 1) {
            throw new IllegalArgumentException("point and scalar arrays should be non-null, and of equal, non-zero, length");
        }
        int n4 = eCPointArray.length;
        switch (n4) {
            case 1: {
                return eCPointArray[0].multiply(bigIntegerArray[0]);
            }
            case 2: {
                return ECAlgorithms.sumOfTwoMultiplies(eCPointArray[0], bigIntegerArray[0], eCPointArray[1], bigIntegerArray[1]);
            }
        }
        ECPoint eCPoint = eCPointArray[0];
        ECCurve eCCurve = eCPoint.getCurve();
        ECPoint[] eCPointArray2 = new ECPoint[n4];
        eCPointArray2[0] = eCPoint;
        for (int i4 = 1; i4 < n4; ++i4) {
            eCPointArray2[i4] = ECAlgorithms.importPoint(eCCurve, eCPointArray[i4]);
        }
        ECEndomorphism eCEndomorphism = eCCurve.getEndomorphism();
        if (eCEndomorphism instanceof GLVEndomorphism) {
            return ECAlgorithms.validatePoint(ECAlgorithms.implSumOfMultipliesGLV(eCPointArray2, bigIntegerArray, (GLVEndomorphism)eCEndomorphism));
        }
        return ECAlgorithms.validatePoint(ECAlgorithms.implSumOfMultiplies(eCPointArray2, bigIntegerArray));
    }

    public static ECPoint sumOfTwoMultiplies(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        Object object;
        ECCurve eCCurve = eCPoint.getCurve();
        eCPoint2 = ECAlgorithms.importPoint(eCCurve, eCPoint2);
        if (eCCurve instanceof ECCurve.AbstractF2m && ((ECCurve.AbstractF2m)(object = (ECCurve.AbstractF2m)eCCurve)).isKoblitz()) {
            return ECAlgorithms.validatePoint(eCPoint.multiply(bigInteger).add(eCPoint2.multiply(bigInteger2)));
        }
        object = eCCurve.getEndomorphism();
        if (object instanceof GLVEndomorphism) {
            return ECAlgorithms.validatePoint(ECAlgorithms.implSumOfMultipliesGLV(new ECPoint[]{eCPoint, eCPoint2}, new BigInteger[]{bigInteger, bigInteger2}, (GLVEndomorphism)object));
        }
        return ECAlgorithms.validatePoint(ECAlgorithms.implShamirsTrickWNaf(eCPoint, bigInteger, eCPoint2, bigInteger2));
    }

    public static ECPoint shamirsTrick(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        ECCurve eCCurve = eCPoint.getCurve();
        eCPoint2 = ECAlgorithms.importPoint(eCCurve, eCPoint2);
        return ECAlgorithms.validatePoint(ECAlgorithms.implShamirsTrickJsf(eCPoint, bigInteger, eCPoint2, bigInteger2));
    }

    public static ECPoint importPoint(ECCurve eCCurve, ECPoint eCPoint) {
        ECCurve eCCurve2 = eCPoint.getCurve();
        if (!eCCurve.equals(eCCurve2)) {
            throw new IllegalArgumentException("Point must be on the same curve");
        }
        return eCCurve.importPoint(eCPoint);
    }

    public static void montgomeryTrick(ECFieldElement[] eCFieldElementArray, int n4, int n5) {
        ECAlgorithms.montgomeryTrick(eCFieldElementArray, n4, n5, null);
    }

    public static void montgomeryTrick(ECFieldElement[] eCFieldElementArray, int n4, int n5, ECFieldElement eCFieldElement) {
        ECFieldElement[] eCFieldElementArray2 = new ECFieldElement[n5];
        eCFieldElementArray2[0] = eCFieldElementArray[n4];
        int n6 = 0;
        while (++n6 < n5) {
            eCFieldElementArray2[n6] = eCFieldElementArray2[n6 - 1].multiply(eCFieldElementArray[n4 + n6]);
        }
        --n6;
        if (eCFieldElement != null) {
            eCFieldElementArray2[n6] = eCFieldElementArray2[n6].multiply(eCFieldElement);
        }
        ECFieldElement eCFieldElement2 = eCFieldElementArray2[n6].invert();
        while (n6 > 0) {
            int n7 = n4 + n6--;
            ECFieldElement eCFieldElement3 = eCFieldElementArray[n7];
            eCFieldElementArray[n7] = eCFieldElementArray2[n6].multiply(eCFieldElement2);
            eCFieldElement2 = eCFieldElement2.multiply(eCFieldElement3);
        }
        eCFieldElementArray[n4] = eCFieldElement2;
    }

    public static ECPoint referenceMultiply(ECPoint eCPoint, BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger.abs();
        ECPoint eCPoint2 = eCPoint.getCurve().getInfinity();
        int n4 = bigInteger2.bitLength();
        if (n4 > 0) {
            if (bigInteger2.testBit(0)) {
                eCPoint2 = eCPoint;
            }
            for (int i4 = 1; i4 < n4; ++i4) {
                eCPoint = eCPoint.twice();
                if (!bigInteger2.testBit(i4)) continue;
                eCPoint2 = eCPoint2.add(eCPoint);
            }
        }
        return bigInteger.signum() < 0 ? eCPoint2.negate() : eCPoint2;
    }

    public static ECPoint validatePoint(ECPoint eCPoint) {
        if (!eCPoint.isValid()) {
            throw new IllegalArgumentException("Invalid point");
        }
        return eCPoint;
    }

    static ECPoint implShamirsTrickJsf(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        ECCurve eCCurve = eCPoint.getCurve();
        ECPoint eCPoint3 = eCCurve.getInfinity();
        ECPoint eCPoint4 = eCPoint.add(eCPoint2);
        ECPoint eCPoint5 = eCPoint.subtract(eCPoint2);
        ECPoint[] eCPointArray = new ECPoint[]{eCPoint2, eCPoint5, eCPoint, eCPoint4};
        eCCurve.normalizeAll(eCPointArray);
        ECPoint[] eCPointArray2 = new ECPoint[]{eCPointArray[3].negate(), eCPointArray[2].negate(), eCPointArray[1].negate(), eCPointArray[0].negate(), eCPoint3, eCPointArray[0], eCPointArray[1], eCPointArray[2], eCPointArray[3]};
        byte[] byArray = WNafUtil.generateJSF(bigInteger, bigInteger2);
        ECPoint eCPoint6 = eCPoint3;
        int n4 = byArray.length;
        while (--n4 >= 0) {
            byte by = byArray[n4];
            int n5 = by << 24 >> 28;
            int n6 = by << 28 >> 28;
            int n7 = 4 + n5 * 3 + n6;
            eCPoint6 = eCPoint6.twicePlus(eCPointArray2[n7]);
        }
        return eCPoint6;
    }

    static ECPoint implShamirsTrickWNaf(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        boolean bl = bigInteger.signum() < 0;
        boolean bl2 = bigInteger2.signum() < 0;
        bigInteger = bigInteger.abs();
        bigInteger2 = bigInteger2.abs();
        int n4 = Math.max(2, Math.min(16, WNafUtil.getWindowSize(bigInteger.bitLength())));
        int n5 = Math.max(2, Math.min(16, WNafUtil.getWindowSize(bigInteger2.bitLength())));
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n4, true);
        WNafPreCompInfo wNafPreCompInfo2 = WNafUtil.precompute(eCPoint2, n5, true);
        ECPoint[] eCPointArray = bl ? wNafPreCompInfo.getPreCompNeg() : wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray2 = bl2 ? wNafPreCompInfo2.getPreCompNeg() : wNafPreCompInfo2.getPreComp();
        ECPoint[] eCPointArray3 = bl ? wNafPreCompInfo.getPreComp() : wNafPreCompInfo.getPreCompNeg();
        ECPoint[] eCPointArray4 = bl2 ? wNafPreCompInfo2.getPreComp() : wNafPreCompInfo2.getPreCompNeg();
        byte[] byArray = WNafUtil.generateWindowNaf(n4, bigInteger);
        byte[] byArray2 = WNafUtil.generateWindowNaf(n5, bigInteger2);
        return ECAlgorithms.implShamirsTrickWNaf(eCPointArray, eCPointArray3, byArray, eCPointArray2, eCPointArray4, byArray2);
    }

    static ECPoint implShamirsTrickWNaf(ECPoint eCPoint, BigInteger bigInteger, ECPointMap eCPointMap, BigInteger bigInteger2) {
        boolean bl = bigInteger.signum() < 0;
        boolean bl2 = bigInteger2.signum() < 0;
        bigInteger = bigInteger.abs();
        bigInteger2 = bigInteger2.abs();
        int n4 = Math.max(2, Math.min(16, WNafUtil.getWindowSize(Math.max(bigInteger.bitLength(), bigInteger2.bitLength()))));
        ECPoint eCPoint2 = WNafUtil.mapPointWithPrecomp(eCPoint, n4, true, eCPointMap);
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.getWNafPreCompInfo(eCPoint);
        WNafPreCompInfo wNafPreCompInfo2 = WNafUtil.getWNafPreCompInfo(eCPoint2);
        ECPoint[] eCPointArray = bl ? wNafPreCompInfo.getPreCompNeg() : wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray2 = bl2 ? wNafPreCompInfo2.getPreCompNeg() : wNafPreCompInfo2.getPreComp();
        ECPoint[] eCPointArray3 = bl ? wNafPreCompInfo.getPreComp() : wNafPreCompInfo.getPreCompNeg();
        ECPoint[] eCPointArray4 = bl2 ? wNafPreCompInfo2.getPreComp() : wNafPreCompInfo2.getPreCompNeg();
        byte[] byArray = WNafUtil.generateWindowNaf(n4, bigInteger);
        byte[] byArray2 = WNafUtil.generateWindowNaf(n4, bigInteger2);
        return ECAlgorithms.implShamirsTrickWNaf(eCPointArray, eCPointArray3, byArray, eCPointArray2, eCPointArray4, byArray2);
    }

    private static ECPoint implShamirsTrickWNaf(ECPoint[] eCPointArray, ECPoint[] eCPointArray2, byte[] byArray, ECPoint[] eCPointArray3, ECPoint[] eCPointArray4, byte[] byArray2) {
        ECPoint eCPoint;
        int n4 = Math.max(byArray.length, byArray2.length);
        ECCurve eCCurve = eCPointArray[0].getCurve();
        ECPoint eCPoint2 = eCPoint = eCCurve.getInfinity();
        int n5 = 0;
        for (int i4 = n4 - 1; i4 >= 0; --i4) {
            ECPoint[] eCPointArray5;
            int n6;
            byte by;
            byte by2 = i4 < byArray.length ? byArray[i4] : (byte)0;
            byte by3 = by = i4 < byArray2.length ? byArray2[i4] : (byte)0;
            if ((by2 | by) == 0) {
                ++n5;
                continue;
            }
            ECPoint eCPoint3 = eCPoint;
            if (by2 != 0) {
                n6 = Math.abs(by2);
                eCPointArray5 = by2 < 0 ? eCPointArray2 : eCPointArray;
                eCPoint3 = eCPoint3.add(eCPointArray5[n6 >>> 1]);
            }
            if (by != 0) {
                n6 = Math.abs(by);
                eCPointArray5 = by < 0 ? eCPointArray4 : eCPointArray3;
                eCPoint3 = eCPoint3.add(eCPointArray5[n6 >>> 1]);
            }
            if (n5 > 0) {
                eCPoint2 = eCPoint2.timesPow2(n5);
                n5 = 0;
            }
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
        }
        if (n5 > 0) {
            eCPoint2 = eCPoint2.timesPow2(n5);
        }
        return eCPoint2;
    }

    static ECPoint implSumOfMultiplies(ECPoint[] eCPointArray, BigInteger[] bigIntegerArray) {
        int n4 = eCPointArray.length;
        boolean[] blArray = new boolean[n4];
        WNafPreCompInfo[] wNafPreCompInfoArray = new WNafPreCompInfo[n4];
        byte[][] byArrayArray = new byte[n4][];
        for (int i4 = 0; i4 < n4; ++i4) {
            BigInteger bigInteger = bigIntegerArray[i4];
            blArray[i4] = bigInteger.signum() < 0;
            bigInteger = bigInteger.abs();
            int n5 = Math.max(2, Math.min(16, WNafUtil.getWindowSize(bigInteger.bitLength())));
            wNafPreCompInfoArray[i4] = WNafUtil.precompute(eCPointArray[i4], n5, true);
            byArrayArray[i4] = WNafUtil.generateWindowNaf(n5, bigInteger);
        }
        return ECAlgorithms.implSumOfMultiplies(blArray, wNafPreCompInfoArray, byArrayArray);
    }

    static ECPoint implSumOfMultipliesGLV(ECPoint[] eCPointArray, BigInteger[] bigIntegerArray, GLVEndomorphism gLVEndomorphism) {
        BigInteger bigInteger = eCPointArray[0].getCurve().getOrder();
        int n4 = eCPointArray.length;
        BigInteger[] bigIntegerArray2 = new BigInteger[n4 << 1];
        int n5 = 0;
        for (int i4 = 0; i4 < n4; ++i4) {
            BigInteger[] bigIntegerArray3 = gLVEndomorphism.decomposeScalar(bigIntegerArray[i4].mod(bigInteger));
            bigIntegerArray2[n5++] = bigIntegerArray3[0];
            bigIntegerArray2[n5++] = bigIntegerArray3[1];
        }
        ECPointMap eCPointMap = gLVEndomorphism.getPointMap();
        if (gLVEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.implSumOfMultiplies(eCPointArray, eCPointMap, bigIntegerArray2);
        }
        ECPoint[] eCPointArray2 = new ECPoint[n4 << 1];
        int n6 = 0;
        for (int i5 = 0; i5 < n4; ++i5) {
            ECPoint eCPoint = eCPointArray[i5];
            ECPoint eCPoint2 = eCPointMap.map(eCPoint);
            eCPointArray2[n6++] = eCPoint;
            eCPointArray2[n6++] = eCPoint2;
        }
        return ECAlgorithms.implSumOfMultiplies(eCPointArray2, bigIntegerArray2);
    }

    static ECPoint implSumOfMultiplies(ECPoint[] eCPointArray, ECPointMap eCPointMap, BigInteger[] bigIntegerArray) {
        int n4 = eCPointArray.length;
        int n5 = n4 << 1;
        boolean[] blArray = new boolean[n5];
        WNafPreCompInfo[] wNafPreCompInfoArray = new WNafPreCompInfo[n5];
        byte[][] byArrayArray = new byte[n5][];
        for (int i4 = 0; i4 < n4; ++i4) {
            int n6 = i4 << 1;
            int n7 = n6 + 1;
            BigInteger bigInteger = bigIntegerArray[n6];
            blArray[n6] = bigInteger.signum() < 0;
            bigInteger = bigInteger.abs();
            BigInteger bigInteger2 = bigIntegerArray[n7];
            blArray[n7] = bigInteger2.signum() < 0;
            bigInteger2 = bigInteger2.abs();
            int n8 = Math.max(2, Math.min(16, WNafUtil.getWindowSize(Math.max(bigInteger.bitLength(), bigInteger2.bitLength()))));
            ECPoint eCPoint = eCPointArray[i4];
            ECPoint eCPoint2 = WNafUtil.mapPointWithPrecomp(eCPoint, n8, true, eCPointMap);
            wNafPreCompInfoArray[n6] = WNafUtil.getWNafPreCompInfo(eCPoint);
            wNafPreCompInfoArray[n7] = WNafUtil.getWNafPreCompInfo(eCPoint2);
            byArrayArray[n6] = WNafUtil.generateWindowNaf(n8, bigInteger);
            byArrayArray[n7] = WNafUtil.generateWindowNaf(n8, bigInteger2);
        }
        return ECAlgorithms.implSumOfMultiplies(blArray, wNafPreCompInfoArray, byArrayArray);
    }

    private static ECPoint implSumOfMultiplies(boolean[] blArray, WNafPreCompInfo[] wNafPreCompInfoArray, byte[][] byArray) {
        ECPoint eCPoint;
        int n4 = 0;
        int n5 = byArray.length;
        for (int i4 = 0; i4 < n5; ++i4) {
            n4 = Math.max(n4, byArray[i4].length);
        }
        ECCurve eCCurve = wNafPreCompInfoArray[0].getPreComp()[0].getCurve();
        ECPoint eCPoint2 = eCPoint = eCCurve.getInfinity();
        int n6 = 0;
        for (int i5 = n4 - 1; i5 >= 0; --i5) {
            ECPoint eCPoint3 = eCPoint;
            for (int i6 = 0; i6 < n5; ++i6) {
                byte by;
                byte[] byArray2 = byArray[i6];
                byte by2 = by = i5 < byArray2.length ? byArray2[i5] : (byte)0;
                if (by == 0) continue;
                int n7 = Math.abs(by);
                WNafPreCompInfo wNafPreCompInfo = wNafPreCompInfoArray[i6];
                ECPoint[] eCPointArray = by < 0 == blArray[i6] ? wNafPreCompInfo.getPreComp() : wNafPreCompInfo.getPreCompNeg();
                eCPoint3 = eCPoint3.add(eCPointArray[n7 >>> 1]);
            }
            if (eCPoint3 == eCPoint) {
                ++n6;
                continue;
            }
            if (n6 > 0) {
                eCPoint2 = eCPoint2.timesPow2(n6);
                n6 = 0;
            }
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
        }
        if (n6 > 0) {
            eCPoint2 = eCPoint2.timesPow2(n6);
        }
        return eCPoint2;
    }
}

