/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsStreamCipher
implements TlsCipher {
    protected TlsContext context;
    protected StreamCipher encryptCipher;
    protected StreamCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;
    protected boolean usesNonce;

    public TlsStreamCipher(TlsContext tlsContext, StreamCipher streamCipher, StreamCipher streamCipher2, Digest digest, Digest digest2, int n4, boolean bl) throws IOException {
        CipherParameters cipherParameters;
        CipherParameters cipherParameters2;
        boolean bl2 = tlsContext.isServer();
        this.context = tlsContext;
        this.usesNonce = bl;
        this.encryptCipher = streamCipher;
        this.decryptCipher = streamCipher2;
        int n5 = 2 * n4 + digest.getDigestSize() + digest2.getDigestSize();
        byte[] byArray = TlsUtils.calculateKeyBlock(tlsContext, n5);
        int n6 = 0;
        TlsMac tlsMac = new TlsMac(tlsContext, digest, byArray, n6, digest.getDigestSize());
        TlsMac tlsMac2 = new TlsMac(tlsContext, digest2, byArray, n6 += digest.getDigestSize(), digest2.getDigestSize());
        KeyParameter keyParameter = new KeyParameter(byArray, n6 += digest2.getDigestSize(), n4);
        KeyParameter keyParameter2 = new KeyParameter(byArray, n6 += n4, n4);
        if ((n6 += n4) != n5) {
            throw new TlsFatalAlert(80);
        }
        if (bl2) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
            this.encryptCipher = streamCipher2;
            this.decryptCipher = streamCipher;
            cipherParameters2 = keyParameter2;
            cipherParameters = keyParameter;
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
            this.encryptCipher = streamCipher;
            this.decryptCipher = streamCipher2;
            cipherParameters2 = keyParameter;
            cipherParameters = keyParameter2;
        }
        if (bl) {
            byte[] byArray2 = new byte[8];
            cipherParameters2 = new ParametersWithIV(cipherParameters2, byArray2);
            cipherParameters = new ParametersWithIV(cipherParameters, byArray2);
        }
        this.encryptCipher.init(true, cipherParameters2);
        this.decryptCipher.init(false, cipherParameters);
    }

    public int getPlaintextLimit(int n4) {
        return n4 - this.writeMac.getSize();
    }

    public byte[] encodePlaintext(long l4, short s4, byte[] byArray, int n4, int n5) {
        if (this.usesNonce) {
            this.updateIV(this.encryptCipher, true, l4);
        }
        byte[] byArray2 = new byte[n5 + this.writeMac.getSize()];
        this.encryptCipher.processBytes(byArray, n4, n5, byArray2, 0);
        byte[] byArray3 = this.writeMac.calculateMac(l4, s4, byArray, n4, n5);
        this.encryptCipher.processBytes(byArray3, 0, byArray3.length, byArray2, n5);
        return byArray2;
    }

    public byte[] decodeCiphertext(long l4, short s4, byte[] byArray, int n4, int n5) throws IOException {
        int n6;
        if (this.usesNonce) {
            this.updateIV(this.decryptCipher, false, l4);
        }
        if (n5 < (n6 = this.readMac.getSize())) {
            throw new TlsFatalAlert(50);
        }
        int n7 = n5 - n6;
        byte[] byArray2 = new byte[n5];
        this.decryptCipher.processBytes(byArray, n4, n5, byArray2, 0);
        this.checkMAC(l4, s4, byArray2, n7, n5, byArray2, 0, n7);
        return Arrays.copyOfRange(byArray2, 0, n7);
    }

    protected void checkMAC(long l4, short s4, byte[] byArray, int n4, int n5, byte[] byArray2, int n6, int n7) throws IOException {
        byte[] byArray3;
        byte[] byArray4 = Arrays.copyOfRange(byArray, n4, n5);
        if (!Arrays.constantTimeAreEqual(byArray4, byArray3 = this.readMac.calculateMac(l4, s4, byArray2, n6, n7))) {
            throw new TlsFatalAlert(20);
        }
    }

    protected void updateIV(StreamCipher streamCipher, boolean bl, long l4) {
        byte[] byArray = new byte[8];
        TlsUtils.writeUint64(l4, byArray, 0);
        streamCipher.init(bl, new ParametersWithIV(null, byArray));
    }
}

