/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

public class ByteQueue {
    private static final int DEFAULT_CAPACITY = 1024;
    private byte[] databuf;
    private int skipped = 0;
    private int available = 0;

    public static int nextTwoPow(int n4) {
        n4 |= n4 >> 1;
        n4 |= n4 >> 2;
        n4 |= n4 >> 4;
        n4 |= n4 >> 8;
        n4 |= n4 >> 16;
        return n4 + 1;
    }

    public ByteQueue() {
        this(1024);
    }

    public ByteQueue(int n4) {
        this.databuf = new byte[n4];
    }

    public void read(byte[] byArray, int n4, int n5, int n6) {
        if (byArray.length - n4 < n5) {
            throw new IllegalArgumentException("Buffer size of " + byArray.length + " is too small for a read of " + n5 + " bytes");
        }
        if (this.available - n6 < n5) {
            throw new IllegalStateException("Not enough data to read");
        }
        System.arraycopy(this.databuf, this.skipped + n6, byArray, n4, n5);
    }

    public void addData(byte[] byArray, int n4, int n5) {
        if (this.skipped + this.available + n5 > this.databuf.length) {
            int n6 = ByteQueue.nextTwoPow(this.available + n5);
            if (n6 > this.databuf.length) {
                byte[] byArray2 = new byte[n6];
                System.arraycopy(this.databuf, this.skipped, byArray2, 0, this.available);
                this.databuf = byArray2;
            } else {
                System.arraycopy(this.databuf, this.skipped, this.databuf, 0, this.available);
            }
            this.skipped = 0;
        }
        System.arraycopy(byArray, n4, this.databuf, this.skipped + this.available, n5);
        this.available += n5;
    }

    public void removeData(int n4) {
        if (n4 > this.available) {
            throw new IllegalStateException("Cannot remove " + n4 + " bytes, only got " + this.available);
        }
        this.available -= n4;
        this.skipped += n4;
    }

    public void removeData(byte[] byArray, int n4, int n5, int n6) {
        this.read(byArray, n4, n5, n6);
        this.removeData(n6 + n5);
    }

    public byte[] removeData(int n4, int n5) {
        byte[] byArray = new byte[n4];
        this.removeData(byArray, 0, n4, n5);
        return byArray;
    }

    public int size() {
        return this.available;
    }

    public int available() {
        return this.available;
    }
}

