/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.SignerWithRecovery;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.ISOTrailers;
import org.bouncycastle.util.Arrays;

public class ISO9796d2Signer
implements SignerWithRecovery {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    public static final int TRAILER_SHA256 = 13516;
    public static final int TRAILER_SHA512 = 13772;
    public static final int TRAILER_SHA384 = 14028;
    public static final int TRAILER_WHIRLPOOL = 14284;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private int trailer;
    private int keyBits;
    private byte[] block;
    private byte[] mBuf;
    private int messageLength;
    private boolean fullMessage;
    private byte[] recoveredMessage;
    private byte[] preSig;
    private byte[] preBlock;

    public ISO9796d2Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, boolean bl) {
        this.cipher = asymmetricBlockCipher;
        this.digest = digest;
        if (bl) {
            this.trailer = 188;
        } else {
            Integer n4 = ISOTrailers.getTrailer(digest);
            if (n4 != null) {
                this.trailer = n4;
            } else {
                throw new IllegalArgumentException("no valid trailer for digest: " + digest.getAlgorithmName());
            }
        }
    }

    public ISO9796d2Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, false);
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)cipherParameters;
        this.cipher.init(bl, rSAKeyParameters);
        this.keyBits = rSAKeyParameters.getModulus().bitLength();
        this.block = new byte[(this.keyBits + 7) / 8];
        this.mBuf = this.trailer == 188 ? new byte[this.block.length - this.digest.getDigestSize() - 2] : new byte[this.block.length - this.digest.getDigestSize() - 3];
        this.reset();
    }

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        if (this.messageLength > this.mBuf.length) {
            if (this.mBuf.length > byArray2.length) {
                bl = false;
            }
            for (int i4 = 0; i4 != this.mBuf.length; ++i4) {
                if (byArray[i4] == byArray2[i4]) continue;
                bl = false;
            }
        } else {
            if (this.messageLength != byArray2.length) {
                bl = false;
            }
            for (int i5 = 0; i5 != byArray2.length; ++i5) {
                if (byArray[i5] == byArray2[i5]) continue;
                bl = false;
            }
        }
        return bl;
    }

    private void clearBlock(byte[] byArray) {
        for (int i4 = 0; i4 != byArray.length; ++i4) {
            byArray[i4] = 0;
        }
    }

    public void updateWithRecoveredMessage(byte[] byArray) throws InvalidCipherTextException {
        int n4;
        byte[] byArray2 = this.cipher.processBlock(byArray, 0, byArray.length);
        if ((byArray2[0] & 0xC0 ^ 0x40) != 0) {
            throw new InvalidCipherTextException("malformed signature");
        }
        if ((byArray2[byArray2.length - 1] & 0xF ^ 0xC) != 0) {
            throw new InvalidCipherTextException("malformed signature");
        }
        int n5 = 0;
        if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) == 0) {
            n5 = 1;
        } else {
            n4 = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
            Integer n6 = ISOTrailers.getTrailer(this.digest);
            if (n6 != null) {
                if (n4 != n6) {
                    throw new IllegalStateException("signer initialised with wrong digest for trailer " + n4);
                }
            } else {
                throw new IllegalArgumentException("unrecognised hash in signature");
            }
            n5 = 2;
        }
        n4 = 0;
        for (n4 = 0; n4 != byArray2.length && (byArray2[n4] & 0xF ^ 0xA) != 0; ++n4) {
        }
        int n7 = byArray2.length - n5 - this.digest.getDigestSize();
        if (n7 - ++n4 <= 0) {
            throw new InvalidCipherTextException("malformed block");
        }
        if ((byArray2[0] & 0x20) == 0) {
            this.fullMessage = true;
            this.recoveredMessage = new byte[n7 - n4];
            System.arraycopy(byArray2, n4, this.recoveredMessage, 0, this.recoveredMessage.length);
        } else {
            this.fullMessage = false;
            this.recoveredMessage = new byte[n7 - n4];
            System.arraycopy(byArray2, n4, this.recoveredMessage, 0, this.recoveredMessage.length);
        }
        this.preSig = byArray;
        this.preBlock = byArray2;
        this.digest.update(this.recoveredMessage, 0, this.recoveredMessage.length);
        this.messageLength = this.recoveredMessage.length;
        System.arraycopy(this.recoveredMessage, 0, this.mBuf, 0, this.recoveredMessage.length);
    }

    public void update(byte by) {
        this.digest.update(by);
        if (this.messageLength < this.mBuf.length) {
            this.mBuf[this.messageLength] = by;
        }
        ++this.messageLength;
    }

    public void update(byte[] byArray, int n4, int n5) {
        while (n5 > 0 && this.messageLength < this.mBuf.length) {
            this.update(byArray[n4]);
            ++n4;
            --n5;
        }
        this.digest.update(byArray, n4, n5);
        this.messageLength += n5;
    }

    public void reset() {
        this.digest.reset();
        this.messageLength = 0;
        this.clearBlock(this.mBuf);
        if (this.recoveredMessage != null) {
            this.clearBlock(this.recoveredMessage);
        }
        this.recoveredMessage = null;
        this.fullMessage = false;
        if (this.preSig != null) {
            this.preSig = null;
            this.clearBlock(this.preBlock);
            this.preBlock = null;
        }
    }

    public byte[] generateSignature() throws CryptoException {
        int n4;
        int n5 = this.digest.getDigestSize();
        int n6 = 0;
        int n7 = 0;
        if (this.trailer == 188) {
            n6 = 8;
            n7 = this.block.length - n5 - 1;
            this.digest.doFinal(this.block, n7);
            this.block[this.block.length - 1] = -68;
        } else {
            n6 = 16;
            n7 = this.block.length - n5 - 2;
            this.digest.doFinal(this.block, n7);
            this.block[this.block.length - 2] = (byte)(this.trailer >>> 8);
            this.block[this.block.length - 1] = (byte)this.trailer;
        }
        int n8 = 0;
        int n9 = (n5 + this.messageLength) * 8 + n6 + 4 - this.keyBits;
        if (n9 > 0) {
            n4 = this.messageLength - (n9 + 7) / 8;
            n8 = 96;
            System.arraycopy(this.mBuf, 0, this.block, n7 -= n4, n4);
            this.recoveredMessage = new byte[n4];
        } else {
            n8 = 64;
            System.arraycopy(this.mBuf, 0, this.block, n7 -= this.messageLength, this.messageLength);
            this.recoveredMessage = new byte[this.messageLength];
        }
        if (n7 - 1 > 0) {
            for (n4 = n7 - 1; n4 != 0; --n4) {
                this.block[n4] = -69;
            }
            int n10 = n7 - 1;
            this.block[n10] = (byte)(this.block[n10] ^ 1);
            this.block[0] = 11;
            this.block[0] = (byte)(this.block[0] | n8);
        } else {
            this.block[0] = 10;
            this.block[0] = (byte)(this.block[0] | n8);
        }
        byte[] byArray = this.cipher.processBlock(this.block, 0, this.block.length);
        this.fullMessage = (n8 & 0x20) == 0;
        System.arraycopy(this.mBuf, 0, this.recoveredMessage, 0, this.recoveredMessage.length);
        this.clearBlock(this.mBuf);
        this.clearBlock(this.block);
        return byArray;
    }

    public boolean verifySignature(byte[] byArray) {
        Object object;
        int n4;
        byte[] byArray2 = null;
        if (this.preSig == null) {
            try {
                byArray2 = this.cipher.processBlock(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            if (!Arrays.areEqual(this.preSig, byArray)) {
                throw new IllegalStateException("updateWithRecoveredMessage called on different signature");
            }
            byArray2 = this.preBlock;
            this.preSig = null;
            this.preBlock = null;
        }
        if ((byArray2[0] & 0xC0 ^ 0x40) != 0) {
            return this.returnFalse(byArray2);
        }
        if ((byArray2[byArray2.length - 1] & 0xF ^ 0xC) != 0) {
            return this.returnFalse(byArray2);
        }
        int n5 = 0;
        if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) == 0) {
            n5 = 1;
        } else {
            n4 = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
            object = ISOTrailers.getTrailer(this.digest);
            if (object != null) {
                if (n4 != object.intValue()) {
                    throw new IllegalStateException("signer initialised with wrong digest for trailer " + n4);
                }
            } else {
                throw new IllegalArgumentException("unrecognised hash in signature");
            }
            n5 = 2;
        }
        n4 = 0;
        for (n4 = 0; n4 != byArray2.length && (byArray2[n4] & 0xF ^ 0xA) != 0; ++n4) {
        }
        object = new byte[this.digest.getDigestSize()];
        int n6 = byArray2.length - n5 - ((byte[])object).length;
        if (n6 - ++n4 <= 0) {
            return this.returnFalse(byArray2);
        }
        if ((byArray2[0] & 0x20) == 0) {
            this.fullMessage = true;
            if (this.messageLength > n6 - n4) {
                return this.returnFalse(byArray2);
            }
            this.digest.reset();
            this.digest.update(byArray2, n4, n6 - n4);
            this.digest.doFinal((byte[])object, 0);
            boolean bl = true;
            for (int i4 = 0; i4 != ((Object)object).length; ++i4) {
                int n7 = n6 + i4;
                byArray2[n7] = (byte)(byArray2[n7] ^ object[i4]);
                if (byArray2[n6 + i4] == 0) continue;
                bl = false;
            }
            if (!bl) {
                return this.returnFalse(byArray2);
            }
            this.recoveredMessage = new byte[n6 - n4];
            System.arraycopy(byArray2, n4, this.recoveredMessage, 0, this.recoveredMessage.length);
        } else {
            this.fullMessage = false;
            this.digest.doFinal((byte[])object, 0);
            boolean bl = true;
            for (int i5 = 0; i5 != ((Object)object).length; ++i5) {
                int n8 = n6 + i5;
                byArray2[n8] = (byte)(byArray2[n8] ^ object[i5]);
                if (byArray2[n6 + i5] == 0) continue;
                bl = false;
            }
            if (!bl) {
                return this.returnFalse(byArray2);
            }
            this.recoveredMessage = new byte[n6 - n4];
            System.arraycopy(byArray2, n4, this.recoveredMessage, 0, this.recoveredMessage.length);
        }
        if (this.messageLength != 0 && !this.isSameAs(this.mBuf, this.recoveredMessage)) {
            return this.returnFalse(byArray2);
        }
        this.clearBlock(this.mBuf);
        this.clearBlock(byArray2);
        return true;
    }

    private boolean returnFalse(byte[] byArray) {
        this.clearBlock(this.mBuf);
        this.clearBlock(byArray);
        return false;
    }

    public boolean hasFullMessage() {
        return this.fullMessage;
    }

    public byte[] getRecoveredMessage() {
        return this.recoveredMessage;
    }
}

