/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class SCrypt {
    public static byte[] generate(byte[] byArray, byte[] byArray2, int n4, int n5, int n6, int n7) {
        if (byArray == null) {
            throw new IllegalArgumentException("Passphrase P must be provided.");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("Salt S must be provided.");
        }
        if (n4 <= 1) {
            throw new IllegalArgumentException("Cost parameter N must be > 1.");
        }
        if (n5 == 1 && n4 > 65536) {
            throw new IllegalArgumentException("Cost parameter N must be > 1 and < 65536.");
        }
        if (n5 < 1) {
            throw new IllegalArgumentException("Block size r must be >= 1.");
        }
        int n8 = Integer.MAX_VALUE / (128 * n5 * 8);
        if (n6 < 1 || n6 > n8) {
            throw new IllegalArgumentException("Parallelisation parameter p must be >= 1 and <= " + n8 + " (based on block size r of " + n5 + ")");
        }
        if (n7 < 1) {
            throw new IllegalArgumentException("Generated key length dkLen must be >= 1.");
        }
        return SCrypt.MFcrypt(byArray, byArray2, n4, n5, n6, n7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] MFcrypt(byte[] byArray, byte[] byArray2, int n4, int n5, int n6, int n7) {
        byte[] byArray3;
        int n8 = n5 * 128;
        byte[] byArray4 = SCrypt.SingleIterationPBKDF2(byArray, byArray2, n6 * n8);
        int[] nArray = null;
        try {
            int n9 = byArray4.length >>> 2;
            nArray = new int[n9];
            Pack.littleEndianToInt(byArray4, 0, nArray);
            int n10 = n8 >>> 2;
            for (int i4 = 0; i4 < n9; i4 += n10) {
                SCrypt.SMix(nArray, i4, n4, n5);
            }
            Pack.intToLittleEndian(nArray, byArray4, 0);
            byArray3 = SCrypt.SingleIterationPBKDF2(byArray, byArray4, n7);
        }
        catch (Throwable throwable) {
            SCrypt.Clear(byArray4);
            SCrypt.Clear(nArray);
            throw throwable;
        }
        SCrypt.Clear(byArray4);
        SCrypt.Clear(nArray);
        return byArray3;
    }

    private static byte[] SingleIterationPBKDF2(byte[] byArray, byte[] byArray2, int n4) {
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(new SHA256Digest());
        pKCS5S2ParametersGenerator.init(byArray, byArray2, 1);
        KeyParameter keyParameter = (KeyParameter)((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedMacParameters(n4 * 8);
        return keyParameter.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void SMix(int[] nArray, int n4, int n5, int n6) {
        int n7 = n6 * 32;
        int[] nArray2 = new int[16];
        int[] nArray3 = new int[16];
        int[] nArray4 = new int[n7];
        int[] nArray5 = new int[n7];
        int[][] nArrayArray = new int[n5][];
        try {
            int n8;
            System.arraycopy(nArray, n4, nArray5, 0, n7);
            for (n8 = 0; n8 < n5; ++n8) {
                nArrayArray[n8] = Arrays.clone(nArray5);
                SCrypt.BlockMix(nArray5, nArray2, nArray3, nArray4, n6);
            }
            n8 = n5 - 1;
            for (int i4 = 0; i4 < n5; ++i4) {
                int n9 = nArray5[n7 - 16] & n8;
                SCrypt.Xor(nArray5, nArrayArray[n9], 0, nArray5);
                SCrypt.BlockMix(nArray5, nArray2, nArray3, nArray4, n6);
            }
            System.arraycopy(nArray5, 0, nArray, n4, n7);
        }
        catch (Throwable throwable) {
            SCrypt.ClearAll(nArrayArray);
            SCrypt.ClearAll(new int[][]{nArray5, nArray2, nArray3, nArray4});
            throw throwable;
        }
        SCrypt.ClearAll(nArrayArray);
        SCrypt.ClearAll(new int[][]{nArray5, nArray2, nArray3, nArray4});
    }

    private static void BlockMix(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n4) {
        System.arraycopy(nArray, nArray.length - 16, nArray2, 0, 16);
        int n5 = 0;
        int n6 = 0;
        int n7 = nArray.length >>> 1;
        for (int i4 = 2 * n4; i4 > 0; --i4) {
            SCrypt.Xor(nArray2, nArray, n5, nArray3);
            Salsa20Engine.salsaCore(8, nArray3, nArray2);
            System.arraycopy(nArray2, 0, nArray4, n6, 16);
            n6 = n7 + n5 - n6;
            n5 += 16;
        }
        System.arraycopy(nArray4, 0, nArray, 0, nArray4.length);
    }

    private static void Xor(int[] nArray, int[] nArray2, int n4, int[] nArray3) {
        for (int i4 = nArray3.length - 1; i4 >= 0; --i4) {
            nArray3[i4] = nArray[i4] ^ nArray2[n4 + i4];
        }
    }

    private static void Clear(byte[] byArray) {
        if (byArray != null) {
            Arrays.fill(byArray, (byte)0);
        }
    }

    private static void Clear(int[] nArray) {
        if (nArray != null) {
            Arrays.fill(nArray, 0);
        }
    }

    private static void ClearAll(int[][] nArray) {
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            SCrypt.Clear(nArray[i4]);
        }
    }
}

