/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.util.Arrays;

public class PKCS5S2ParametersGenerator
extends PBEParametersGenerator {
    private Mac hMac;
    private byte[] state;

    public PKCS5S2ParametersGenerator() {
        this(DigestFactory.createSHA1());
    }

    public PKCS5S2ParametersGenerator(Digest digest) {
        this.hMac = new HMac(digest);
        this.state = new byte[this.hMac.getMacSize()];
    }

    private void F(byte[] byArray, int n4, byte[] byArray2, byte[] byArray3, int n5) {
        if (n4 == 0) {
            throw new IllegalArgumentException("iteration count must be at least 1.");
        }
        if (byArray != null) {
            this.hMac.update(byArray, 0, byArray.length);
        }
        this.hMac.update(byArray2, 0, byArray2.length);
        this.hMac.doFinal(this.state, 0);
        System.arraycopy(this.state, 0, byArray3, n5, this.state.length);
        for (int i4 = 1; i4 < n4; ++i4) {
            this.hMac.update(this.state, 0, this.state.length);
            this.hMac.doFinal(this.state, 0);
            for (int i5 = 0; i5 != this.state.length; ++i5) {
                int n6 = n5 + i5;
                byArray3[n6] = (byte)(byArray3[n6] ^ this.state[i5]);
            }
        }
    }

    private byte[] generateDerivedKey(int n4) {
        int n5 = this.hMac.getMacSize();
        int n6 = (n4 + n5 - 1) / n5;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[n6 * n5];
        int n7 = 0;
        KeyParameter keyParameter = new KeyParameter(this.password);
        this.hMac.init(keyParameter);
        for (int i4 = 1; i4 <= n6; ++i4) {
            int n8;
            int n9 = 3;
            do {
                n8 = n9--;
            } while ((byArray[n8] = (byte)(byArray[n8] + 1)) == 0);
            this.F(this.salt, this.iterationCount, byArray, byArray2, n7);
            n7 += n5;
        }
        return byArray2;
    }

    public CipherParameters generateDerivedParameters(int n4) {
        byte[] byArray = Arrays.copyOfRange(this.generateDerivedKey(n4 /= 8), 0, n4);
        return new KeyParameter(byArray, 0, n4);
    }

    public CipherParameters generateDerivedParameters(int n4, int n5) {
        byte[] byArray = this.generateDerivedKey((n4 /= 8) + (n5 /= 8));
        return new ParametersWithIV(new KeyParameter(byArray, 0, n4), byArray, n4, n5);
    }

    public CipherParameters generateDerivedMacParameters(int n4) {
        return this.generateDerivedParameters(n4);
    }
}

