/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.DigestDerivationFunction;
import org.bouncycastle.crypto.params.ISO18033KDFParameters;
import org.bouncycastle.crypto.params.KDFParameters;
import org.bouncycastle.util.Pack;

public class BaseKDFBytesGenerator
implements DigestDerivationFunction {
    private int counterStart;
    private Digest digest;
    private byte[] shared;
    private byte[] iv;

    protected BaseKDFBytesGenerator(int n4, Digest digest) {
        this.counterStart = n4;
        this.digest = digest;
    }

    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFParameters) {
            KDFParameters kDFParameters = (KDFParameters)derivationParameters;
            this.shared = kDFParameters.getSharedSecret();
            this.iv = kDFParameters.getIV();
        } else if (derivationParameters instanceof ISO18033KDFParameters) {
            ISO18033KDFParameters iSO18033KDFParameters = (ISO18033KDFParameters)derivationParameters;
            this.shared = iSO18033KDFParameters.getSeed();
            this.iv = null;
        } else {
            throw new IllegalArgumentException("KDF parameters required for generator");
        }
    }

    public Digest getDigest() {
        return this.digest;
    }

    public int generateBytes(byte[] byArray, int n4, int n5) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n5 < n4) {
            throw new DataLengthException("output buffer too small");
        }
        long l4 = n5;
        int n6 = this.digest.getDigestSize();
        if (l4 > 0x1FFFFFFFFL) {
            throw new IllegalArgumentException("Output length too large");
        }
        int n7 = (int)((l4 + (long)n6 - 1L) / (long)n6);
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        byte[] byArray3 = new byte[4];
        Pack.intToBigEndian(this.counterStart, byArray3, 0);
        int n8 = this.counterStart & 0xFFFFFF00;
        for (int i4 = 0; i4 < n7; ++i4) {
            this.digest.update(this.shared, 0, this.shared.length);
            this.digest.update(byArray3, 0, byArray3.length);
            if (this.iv != null) {
                this.digest.update(this.iv, 0, this.iv.length);
            }
            this.digest.doFinal(byArray2, 0);
            if (n5 > n6) {
                System.arraycopy(byArray2, 0, byArray, n4, n6);
                n4 += n6;
                n5 -= n6;
            } else {
                System.arraycopy(byArray2, 0, byArray, n4, n5);
            }
            byArray3[3] = (byte)(byArray3[3] + 1);
            if (byArray3[3] != 0) continue;
            Pack.intToBigEndian(n8 += 256, byArray3, 0);
        }
        this.digest.reset();
        return (int)l4;
    }
}

