/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.util.Arrays;

public class RC2WrapEngine
implements Wrapper {
    private CBCBlockCipher engine;
    private CipherParameters param;
    private ParametersWithIV paramPlusIV;
    private byte[] iv;
    private boolean forWrapping;
    private SecureRandom sr;
    private static final byte[] IV2 = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    Digest sha1 = DigestFactory.createSHA1();
    byte[] digest = new byte[20];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forWrapping = bl;
        this.engine = new CBCBlockCipher(new RC2Engine());
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.sr = parametersWithRandom.getRandom();
            cipherParameters = parametersWithRandom.getParameters();
        } else {
            this.sr = new SecureRandom();
        }
        if (cipherParameters instanceof ParametersWithIV) {
            this.paramPlusIV = (ParametersWithIV)cipherParameters;
            this.iv = this.paramPlusIV.getIV();
            this.param = this.paramPlusIV.getParameters();
            if (!this.forWrapping) throw new IllegalArgumentException("You should not supply an IV for unwrapping");
            if (this.iv != null && this.iv.length == 8) return;
            throw new IllegalArgumentException("IV is not 8 octets");
        }
        this.param = cipherParameters;
        if (!this.forWrapping) return;
        this.iv = new byte[8];
        this.sr.nextBytes(this.iv);
        this.paramPlusIV = new ParametersWithIV(this.param, this.iv);
    }

    public String getAlgorithmName() {
        return "RC2";
    }

    public byte[] wrap(byte[] byArray, int n4, int n5) {
        if (!this.forWrapping) {
            throw new IllegalStateException("Not initialized for wrapping");
        }
        int n6 = n5 + 1;
        if (n6 % 8 != 0) {
            n6 += 8 - n6 % 8;
        }
        byte[] byArray2 = new byte[n6];
        byArray2[0] = (byte)n5;
        System.arraycopy(byArray, n4, byArray2, 1, n5);
        byte[] byArray3 = new byte[byArray2.length - n5 - 1];
        if (byArray3.length > 0) {
            this.sr.nextBytes(byArray3);
            System.arraycopy(byArray3, 0, byArray2, n5 + 1, byArray3.length);
        }
        byte[] byArray4 = this.calculateCMSKeyChecksum(byArray2);
        byte[] byArray5 = new byte[byArray2.length + byArray4.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray4, 0, byArray5, byArray2.length, byArray4.length);
        byte[] byArray6 = new byte[byArray5.length];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length);
        int n7 = byArray5.length / this.engine.getBlockSize();
        int n8 = byArray5.length % this.engine.getBlockSize();
        if (n8 != 0) {
            throw new IllegalStateException("Not multiple of block length");
        }
        this.engine.init(true, this.paramPlusIV);
        for (int i4 = 0; i4 < n7; ++i4) {
            int n9 = i4 * this.engine.getBlockSize();
            this.engine.processBlock(byArray6, n9, byArray6, n9);
        }
        byte[] byArray7 = new byte[this.iv.length + byArray6.length];
        System.arraycopy(this.iv, 0, byArray7, 0, this.iv.length);
        System.arraycopy(byArray6, 0, byArray7, this.iv.length, byArray6.length);
        byte[] byArray8 = new byte[byArray7.length];
        for (int i5 = 0; i5 < byArray7.length; ++i5) {
            byArray8[i5] = byArray7[byArray7.length - (i5 + 1)];
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.param, IV2);
        this.engine.init(true, parametersWithIV);
        for (int i6 = 0; i6 < n7 + 1; ++i6) {
            int n10 = i6 * this.engine.getBlockSize();
            this.engine.processBlock(byArray8, n10, byArray8, n10);
        }
        return byArray8;
    }

    public byte[] unwrap(byte[] byArray, int n4, int n5) throws InvalidCipherTextException {
        int n6;
        if (this.forWrapping) {
            throw new IllegalStateException("Not set for unwrapping");
        }
        if (byArray == null) {
            throw new InvalidCipherTextException("Null pointer as ciphertext");
        }
        if (n5 % this.engine.getBlockSize() != 0) {
            throw new InvalidCipherTextException("Ciphertext not multiple of " + this.engine.getBlockSize());
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.param, IV2);
        this.engine.init(false, parametersWithIV);
        byte[] byArray2 = new byte[n5];
        System.arraycopy(byArray, n4, byArray2, 0, n5);
        for (int i4 = 0; i4 < byArray2.length / this.engine.getBlockSize(); ++i4) {
            n6 = i4 * this.engine.getBlockSize();
            this.engine.processBlock(byArray2, n6, byArray2, n6);
        }
        byte[] byArray3 = new byte[byArray2.length];
        for (n6 = 0; n6 < byArray2.length; ++n6) {
            byArray3[n6] = byArray2[byArray2.length - (n6 + 1)];
        }
        this.iv = new byte[8];
        byte[] byArray4 = new byte[byArray3.length - 8];
        System.arraycopy(byArray3, 0, this.iv, 0, 8);
        System.arraycopy(byArray3, 8, byArray4, 0, byArray3.length - 8);
        this.paramPlusIV = new ParametersWithIV(this.param, this.iv);
        this.engine.init(false, this.paramPlusIV);
        byte[] byArray5 = new byte[byArray4.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        for (int i5 = 0; i5 < byArray5.length / this.engine.getBlockSize(); ++i5) {
            int n7 = i5 * this.engine.getBlockSize();
            this.engine.processBlock(byArray5, n7, byArray5, n7);
        }
        byte[] byArray6 = new byte[byArray5.length - 8];
        byte[] byArray7 = new byte[8];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length - 8);
        System.arraycopy(byArray5, byArray5.length - 8, byArray7, 0, 8);
        if (!this.checkCMSKeyChecksum(byArray6, byArray7)) {
            throw new InvalidCipherTextException("Checksum inside ciphertext is corrupted");
        }
        if (byArray6.length - ((byArray6[0] & 0xFF) + 1) > 7) {
            throw new InvalidCipherTextException("too many pad bytes (" + (byArray6.length - ((byArray6[0] & 0xFF) + 1)) + ")");
        }
        byte[] byArray8 = new byte[byArray6[0]];
        System.arraycopy(byArray6, 1, byArray8, 0, byArray8.length);
        return byArray8;
    }

    private byte[] calculateCMSKeyChecksum(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        this.sha1.update(byArray, 0, byArray.length);
        this.sha1.doFinal(this.digest, 0);
        System.arraycopy(this.digest, 0, byArray2, 0, 8);
        return byArray2;
    }

    private boolean checkCMSKeyChecksum(byte[] byArray, byte[] byArray2) {
        return Arrays.constantTimeAreEqual(this.calculateCMSKeyChecksum(byArray), byArray2);
    }
}

