/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class IDEAEngine
implements BlockCipher {
    protected static final int BLOCK_SIZE = 8;
    private int[] workingKey = null;
    private static final int MASK = 65535;
    private static final int BASE = 65537;

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.workingKey = this.generateWorkingKey(bl, ((KeyParameter)cipherParameters).getKey());
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to IDEA init - " + cipherParameters.getClass().getName());
    }

    public String getAlgorithmName() {
        return "IDEA";
    }

    public int getBlockSize() {
        return 8;
    }

    public int processBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        if (this.workingKey == null) {
            throw new IllegalStateException("IDEA engine not initialised");
        }
        if (n4 + 8 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n5 + 8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.ideaFunc(this.workingKey, byArray, n4, byArray2, n5);
        return 8;
    }

    public void reset() {
    }

    private int bytesToWord(byte[] byArray, int n4) {
        return (byArray[n4] << 8 & 0xFF00) + (byArray[n4 + 1] & 0xFF);
    }

    private void wordToBytes(int n4, byte[] byArray, int n5) {
        byArray[n5] = (byte)(n4 >>> 8);
        byArray[n5 + 1] = (byte)n4;
    }

    private int mul(int n4, int n5) {
        int n6;
        n4 = n4 == 0 ? 65537 - n5 : (n5 == 0 ? 65537 - n4 : n5 - n4 + ((n5 = (n6 = n4 * n5) & 0xFFFF) < (n4 = n6 >>> 16) ? 1 : 0));
        return n4 & 0xFFFF;
    }

    private void ideaFunc(int[] nArray, byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6 = 0;
        int n7 = this.bytesToWord(byArray, n4);
        int n8 = this.bytesToWord(byArray, n4 + 2);
        int n9 = this.bytesToWord(byArray, n4 + 4);
        int n10 = this.bytesToWord(byArray, n4 + 6);
        for (int i4 = 0; i4 < 8; ++i4) {
            n7 = this.mul(n7, nArray[n6++]);
            n8 += nArray[n6++];
            n9 += nArray[n6++];
            n10 = this.mul(n10, nArray[n6++]);
            int n11 = n8 &= 0xFFFF;
            int n12 = n9 &= 0xFFFF;
            n9 ^= n7;
            n8 ^= n10;
            n9 = this.mul(n9, nArray[n6++]);
            n8 += n9;
            n8 &= 0xFFFF;
            n8 = this.mul(n8, nArray[n6++]);
            n9 += n8;
            n7 ^= n8;
            n10 ^= (n9 &= 0xFFFF);
            n8 ^= n12;
            n9 ^= n11;
        }
        this.wordToBytes(this.mul(n7, nArray[n6++]), byArray2, n5);
        this.wordToBytes(n9 + nArray[n6++], byArray2, n5 + 2);
        this.wordToBytes(n8 + nArray[n6++], byArray2, n5 + 4);
        this.wordToBytes(this.mul(n10, nArray[n6]), byArray2, n5 + 6);
    }

    private int[] expandKey(byte[] byArray) {
        int n4;
        int[] nArray = new int[52];
        if (byArray.length < 16) {
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
            byArray = byArray2;
        }
        for (n4 = 0; n4 < 8; ++n4) {
            nArray[n4] = this.bytesToWord(byArray, n4 * 2);
        }
        for (n4 = 8; n4 < 52; ++n4) {
            nArray[n4] = (n4 & 7) < 6 ? ((nArray[n4 - 7] & 0x7F) << 9 | nArray[n4 - 6] >> 7) & 0xFFFF : ((n4 & 7) == 6 ? ((nArray[n4 - 7] & 0x7F) << 9 | nArray[n4 - 14] >> 7) & 0xFFFF : ((nArray[n4 - 15] & 0x7F) << 9 | nArray[n4 - 14] >> 7) & 0xFFFF);
        }
        return nArray;
    }

    private int mulInv(int n4) {
        if (n4 < 2) {
            return n4;
        }
        int n5 = 1;
        int n6 = 65537 / n4;
        for (int i4 = 65537 % n4; i4 != 1; i4 %= n4) {
            int n7 = n4 / i4;
            n5 = n5 + n6 * n7 & 0xFFFF;
            if ((n4 %= i4) == 1) {
                return n5;
            }
            n7 = i4 / n4;
            n6 = n6 + n5 * n7 & 0xFFFF;
        }
        return 1 - n6 & 0xFFFF;
    }

    int addInv(int n4) {
        return 0 - n4 & 0xFFFF;
    }

    private int[] invertKey(int[] nArray) {
        int n4 = 52;
        int[] nArray2 = new int[52];
        int n5 = 0;
        int n6 = this.mulInv(nArray[n5++]);
        int n7 = this.addInv(nArray[n5++]);
        int n8 = this.addInv(nArray[n5++]);
        int n9 = this.mulInv(nArray[n5++]);
        nArray2[--n4] = n9;
        nArray2[--n4] = n8;
        nArray2[--n4] = n7;
        nArray2[--n4] = n6;
        for (int i4 = 1; i4 < 8; ++i4) {
            n6 = nArray[n5++];
            n7 = nArray[n5++];
            nArray2[--n4] = n7;
            nArray2[--n4] = n6;
            n6 = this.mulInv(nArray[n5++]);
            n7 = this.addInv(nArray[n5++]);
            n8 = this.addInv(nArray[n5++]);
            n9 = this.mulInv(nArray[n5++]);
            nArray2[--n4] = n9;
            nArray2[--n4] = n7;
            nArray2[--n4] = n8;
            nArray2[--n4] = n6;
        }
        n6 = nArray[n5++];
        n7 = nArray[n5++];
        nArray2[--n4] = n7;
        nArray2[--n4] = n6;
        n6 = this.mulInv(nArray[n5++]);
        n7 = this.addInv(nArray[n5++]);
        n8 = this.addInv(nArray[n5++]);
        n9 = this.mulInv(nArray[n5]);
        nArray2[--n4] = n9;
        nArray2[--n4] = n8;
        nArray2[--n4] = n7;
        nArray2[--n4] = n6;
        return nArray2;
    }

    private int[] generateWorkingKey(boolean bl, byte[] byArray) {
        if (bl) {
            return this.expandKey(byArray);
        }
        return this.invertKey(this.expandKey(byArray));
    }
}

