/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class HC128Engine
implements StreamCipher {
    private int[] p = new int[512];
    private int[] q = new int[512];
    private int cnt = 0;
    private byte[] key;
    private byte[] iv;
    private boolean initialised;
    private byte[] buf = new byte[4];
    private int idx = 0;

    private static int f1(int n4) {
        return HC128Engine.rotateRight(n4, 7) ^ HC128Engine.rotateRight(n4, 18) ^ n4 >>> 3;
    }

    private static int f2(int n4) {
        return HC128Engine.rotateRight(n4, 17) ^ HC128Engine.rotateRight(n4, 19) ^ n4 >>> 10;
    }

    private int g1(int n4, int n5, int n6) {
        return (HC128Engine.rotateRight(n4, 10) ^ HC128Engine.rotateRight(n6, 23)) + HC128Engine.rotateRight(n5, 8);
    }

    private int g2(int n4, int n5, int n6) {
        return (HC128Engine.rotateLeft(n4, 10) ^ HC128Engine.rotateLeft(n6, 23)) + HC128Engine.rotateLeft(n5, 8);
    }

    private static int rotateLeft(int n4, int n5) {
        return n4 << n5 | n4 >>> -n5;
    }

    private static int rotateRight(int n4, int n5) {
        return n4 >>> n5 | n4 << -n5;
    }

    private int h1(int n4) {
        return this.q[n4 & 0xFF] + this.q[(n4 >> 16 & 0xFF) + 256];
    }

    private int h2(int n4) {
        return this.p[n4 & 0xFF] + this.p[(n4 >> 16 & 0xFF) + 256];
    }

    private static int mod1024(int n4) {
        return n4 & 0x3FF;
    }

    private static int mod512(int n4) {
        return n4 & 0x1FF;
    }

    private static int dim(int n4, int n5) {
        return HC128Engine.mod512(n4 - n5);
    }

    private int step() {
        int n4;
        int n5 = HC128Engine.mod512(this.cnt);
        if (this.cnt < 512) {
            int n6 = n5;
            this.p[n6] = this.p[n6] + this.g1(this.p[HC128Engine.dim(n5, 3)], this.p[HC128Engine.dim(n5, 10)], this.p[HC128Engine.dim(n5, 511)]);
            n4 = this.h1(this.p[HC128Engine.dim(n5, 12)]) ^ this.p[n5];
        } else {
            int n7 = n5;
            this.q[n7] = this.q[n7] + this.g2(this.q[HC128Engine.dim(n5, 3)], this.q[HC128Engine.dim(n5, 10)], this.q[HC128Engine.dim(n5, 511)]);
            n4 = this.h2(this.q[HC128Engine.dim(n5, 12)]) ^ this.q[n5];
        }
        this.cnt = HC128Engine.mod1024(this.cnt + 1);
        return n4;
    }

    private void init() {
        int n4;
        if (this.key.length != 16) {
            throw new IllegalArgumentException("The key must be 128 bits long");
        }
        this.idx = 0;
        this.cnt = 0;
        int[] nArray = new int[1280];
        for (n4 = 0; n4 < 16; ++n4) {
            int n5 = n4 >> 2;
            nArray[n5] = nArray[n5] | (this.key[n4] & 0xFF) << 8 * (n4 & 3);
        }
        System.arraycopy(nArray, 0, nArray, 4, 4);
        for (n4 = 0; n4 < this.iv.length && n4 < 16; ++n4) {
            int n6 = (n4 >> 2) + 8;
            nArray[n6] = nArray[n6] | (this.iv[n4] & 0xFF) << 8 * (n4 & 3);
        }
        System.arraycopy(nArray, 8, nArray, 12, 4);
        for (n4 = 16; n4 < 1280; ++n4) {
            nArray[n4] = HC128Engine.f2(nArray[n4 - 2]) + nArray[n4 - 7] + HC128Engine.f1(nArray[n4 - 15]) + nArray[n4 - 16] + n4;
        }
        System.arraycopy(nArray, 256, this.p, 0, 512);
        System.arraycopy(nArray, 768, this.q, 0, 512);
        for (n4 = 0; n4 < 512; ++n4) {
            this.p[n4] = this.step();
        }
        for (n4 = 0; n4 < 512; ++n4) {
            this.q[n4] = this.step();
        }
        this.cnt = 0;
    }

    public String getAlgorithmName() {
        return "HC-128";
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        CipherParameters cipherParameters2 = cipherParameters;
        if (cipherParameters instanceof ParametersWithIV) {
            this.iv = ((ParametersWithIV)cipherParameters).getIV();
            cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
        } else {
            this.iv = new byte[0];
        }
        if (!(cipherParameters2 instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid parameter passed to HC128 init - " + cipherParameters.getClass().getName());
        }
        this.key = ((KeyParameter)cipherParameters2).getKey();
        this.init();
        this.initialised = true;
    }

    private byte getByte() {
        int n4;
        if (this.idx == 0) {
            n4 = this.step();
            this.buf[0] = (byte)(n4 & 0xFF);
            this.buf[1] = (byte)((n4 >>= 8) & 0xFF);
            this.buf[2] = (byte)((n4 >>= 8) & 0xFF);
            this.buf[3] = (byte)((n4 >>= 8) & 0xFF);
        }
        n4 = this.buf[this.idx];
        this.idx = this.idx + 1 & 3;
        return (byte)n4;
    }

    public int processBytes(byte[] byArray, int n4, int n5, byte[] byArray2, int n6) throws DataLengthException {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n4 + n5 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n6 + n5 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i4 = 0; i4 < n5; ++i4) {
            byArray2[n6 + i4] = (byte)(byArray[n4 + i4] ^ this.getByte());
        }
        return n5;
    }

    public void reset() {
        this.init();
    }

    public byte returnByte(byte by) {
        return (byte)(by ^ this.getByte());
    }
}

