/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.KeccakDigest;

public class SHA3Digest
extends KeccakDigest {
    private static int checkBitLength(int n4) {
        switch (n4) {
            case 224: 
            case 256: 
            case 384: 
            case 512: {
                return n4;
            }
        }
        throw new IllegalArgumentException("'bitLength' " + n4 + " not supported for SHA-3");
    }

    public SHA3Digest() {
        this(256);
    }

    public SHA3Digest(int n4) {
        super(SHA3Digest.checkBitLength(n4));
    }

    public SHA3Digest(SHA3Digest sHA3Digest) {
        super(sHA3Digest);
    }

    public String getAlgorithmName() {
        return "SHA3-" + this.fixedOutputLength;
    }

    public int doFinal(byte[] byArray, int n4) {
        this.absorb(new byte[]{2}, 0, 2L);
        return super.doFinal(byArray, n4);
    }

    protected int doFinal(byte[] byArray, int n4, byte by, int n5) {
        if (n5 < 0 || n5 > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int n6 = by & (1 << n5) - 1 | 2 << n5;
        int n7 = n5 + 2;
        if (n7 >= 8) {
            this.oneByte[0] = (byte)n6;
            this.absorb(this.oneByte, 0, 8L);
            n7 -= 8;
            n6 >>>= 8;
        }
        return super.doFinal(byArray, n4, (byte)n6, n7);
    }
}

