/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.jcajce;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.InputExpander;
import org.bouncycastle.operator.InputExpanderProvider;
import org.bouncycastle.util.io.StreamOverflowException;

public class ZlibExpanderProvider
implements InputExpanderProvider {
    private final long limit;

    public ZlibExpanderProvider() {
        this.limit = -1L;
    }

    public ZlibExpanderProvider(long l4) {
        this.limit = l4;
    }

    public InputExpander get(final AlgorithmIdentifier algorithmIdentifier) {
        return new InputExpander(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier;
            }

            public InputStream getInputStream(InputStream inputStream) {
                FilterInputStream filterInputStream = new InflaterInputStream(inputStream);
                if (ZlibExpanderProvider.this.limit >= 0L) {
                    filterInputStream = new LimitedInputStream(filterInputStream, ZlibExpanderProvider.this.limit);
                }
                return filterInputStream;
            }
        };
    }

    private static class LimitedInputStream
    extends FilterInputStream {
        private long remaining;

        public LimitedInputStream(InputStream inputStream, long l4) {
            super(inputStream);
            this.remaining = l4;
        }

        public int read() throws IOException {
            int n4;
            if (this.remaining >= 0L && ((n4 = this.in.read()) < 0 || --this.remaining >= 0L)) {
                return n4;
            }
            throw new StreamOverflowException("expanded byte limit exceeded");
        }

        public int read(byte[] byArray, int n4, int n5) throws IOException {
            if (n5 < 1) {
                return super.read(byArray, n4, n5);
            }
            if (this.remaining < 1L) {
                this.read();
                return -1;
            }
            int n6 = this.remaining > (long)n5 ? n5 : (int)this.remaining;
            int n7 = this.in.read(byArray, n4, n6);
            if (n7 > 0) {
                this.remaining -= (long)n7;
            }
            return n7;
        }
    }
}

