/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.BERGenerator;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;

public class BEROctetStringGenerator
extends BERGenerator {
    public BEROctetStringGenerator(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.writeBERHeader(36);
    }

    public BEROctetStringGenerator(OutputStream outputStream, int n4, boolean bl) throws IOException {
        super(outputStream, n4, bl);
        this.writeBERHeader(36);
    }

    public OutputStream getOctetOutputStream() {
        return this.getOctetOutputStream(new byte[1000]);
    }

    public OutputStream getOctetOutputStream(byte[] byArray) {
        return new BufferedBEROctetStream(byArray);
    }

    private class BufferedBEROctetStream
    extends OutputStream {
        private byte[] _buf;
        private int _off;
        private DEROutputStream _derOut;

        BufferedBEROctetStream(byte[] byArray) {
            this._buf = byArray;
            this._off = 0;
            this._derOut = new DEROutputStream(BEROctetStringGenerator.this._out);
        }

        public void write(int n4) throws IOException {
            this._buf[this._off++] = (byte)n4;
            if (this._off == this._buf.length) {
                DEROctetString.encode(this._derOut, this._buf);
                this._off = 0;
            }
        }

        public void write(byte[] byArray, int n4, int n5) throws IOException {
            while (n5 > 0) {
                int n6 = Math.min(n5, this._buf.length - this._off);
                System.arraycopy(byArray, n4, this._buf, this._off, n6);
                this._off += n6;
                if (this._off < this._buf.length) break;
                DEROctetString.encode(this._derOut, this._buf);
                this._off = 0;
                n4 += n6;
                n5 -= n6;
            }
        }

        public void close() throws IOException {
            if (this._off != 0) {
                byte[] byArray = new byte[this._off];
                System.arraycopy(this._buf, 0, byArray, 0, this._off);
                DEROctetString.encode(this._derOut, byArray);
            }
            BEROctetStringGenerator.this.writeBEREnd();
        }
    }
}

