/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DLBitString;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public abstract class ASN1BitString
extends ASN1Primitive
implements ASN1String {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected final byte[] data;
    protected final int padBits;

    protected static int getPadBits(int n4) {
        int n5;
        int n6 = 0;
        for (n5 = 3; n5 >= 0; --n5) {
            if (n5 != 0) {
                if (n4 >> n5 * 8 == 0) continue;
                n6 = n4 >> n5 * 8 & 0xFF;
                break;
            }
            if (n4 == 0) continue;
            n6 = n4 & 0xFF;
            break;
        }
        if (n6 == 0) {
            return 0;
        }
        n5 = 1;
        while (((n6 <<= 1) & 0xFF) != 0) {
            ++n5;
        }
        return 8 - n5;
    }

    protected static byte[] getBytes(int n4) {
        if (n4 == 0) {
            return new byte[0];
        }
        int n5 = 4;
        for (int i4 = 3; i4 >= 1 && (n4 & 255 << i4 * 8) == 0; --i4) {
            --n5;
        }
        byte[] byArray = new byte[n5];
        for (int i5 = 0; i5 < n5; ++i5) {
            byArray[i5] = (byte)(n4 >> i5 * 8 & 0xFF);
        }
        return byArray;
    }

    public ASN1BitString(byte[] byArray, int n4) {
        if (byArray == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (byArray.length == 0 && n4 != 0) {
            throw new IllegalArgumentException("zero length data with non-zero pad bits");
        }
        if (n4 > 7 || n4 < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        this.data = Arrays.clone(byArray);
        this.padBits = n4;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            aSN1OutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException("Internal error encoding BitString: " + iOException.getMessage(), iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (int i4 = 0; i4 != byArray.length; ++i4) {
            stringBuffer.append(table[byArray[i4] >>> 4 & 0xF]);
            stringBuffer.append(table[byArray[i4] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public int intValue() {
        int n4 = 0;
        byte[] byArray = this.data;
        if (this.padBits > 0 && this.data.length <= 4) {
            byArray = ASN1BitString.derForm(this.data, this.padBits);
        }
        for (int i4 = 0; i4 != byArray.length && i4 != 4; ++i4) {
            n4 |= (byArray[i4] & 0xFF) << 8 * i4;
        }
        return n4;
    }

    public byte[] getOctets() {
        if (this.padBits != 0) {
            throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
        }
        return Arrays.clone(this.data);
    }

    public byte[] getBytes() {
        return ASN1BitString.derForm(this.data, this.padBits);
    }

    public int getPadBits() {
        return this.padBits;
    }

    public String toString() {
        return this.getString();
    }

    public int hashCode() {
        return this.padBits ^ Arrays.hashCode(this.getBytes());
    }

    protected boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1BitString)) {
            return false;
        }
        ASN1BitString aSN1BitString = (ASN1BitString)aSN1Primitive;
        return this.padBits == aSN1BitString.padBits && Arrays.areEqual(this.getBytes(), aSN1BitString.getBytes());
    }

    protected static byte[] derForm(byte[] byArray, int n4) {
        byte[] byArray2 = Arrays.clone(byArray);
        if (n4 > 0) {
            int n5 = byArray.length - 1;
            byArray2[n5] = (byte)(byArray2[n5] & 255 << n4);
        }
        return byArray2;
    }

    static ASN1BitString fromInputStream(int n4, InputStream inputStream) throws IOException {
        if (n4 < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int n5 = inputStream.read();
        byte[] byArray = new byte[n4 - 1];
        if (byArray.length != 0) {
            if (Streams.readFully(inputStream, byArray) != byArray.length) {
                throw new EOFException("EOF encountered in middle of BIT STRING");
            }
            if (n5 > 0 && n5 < 8 && byArray[byArray.length - 1] != (byte)(byArray[byArray.length - 1] & 255 << n5)) {
                return new DLBitString(byArray, n5);
            }
        }
        return new DERBitString(byArray, n5);
    }

    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    ASN1Primitive toDERObject() {
        return new DERBitString(this.data, this.padBits);
    }

    ASN1Primitive toDLObject() {
        return new DLBitString(this.data, this.padBits);
    }

    abstract void encode(ASN1OutputStream var1) throws IOException;
}

