/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;

@Beta
@GwtCompatible(emulated=true)
public final class Utf8 {
    public static int encodedLength(CharSequence sequence) {
        int i4;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i4 = 0; i4 < utf16Length && sequence.charAt(i4) < '\u0080'; ++i4) {
        }
        while (i4 < utf16Length) {
            char c4 = sequence.charAt(i4);
            if (c4 < '\u0800') {
                utf8Length += 127 - c4 >>> 31;
            } else {
                utf8Length += Utf8.encodedLengthGeneral(sequence, i4);
                break;
            }
            ++i4;
        }
        if (utf8Length < utf16Length) {
            long l4 = (long)utf8Length + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l4).toString());
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start) {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i4 = start; i4 < utf16Length; ++i4) {
            char c4 = sequence.charAt(i4);
            if (c4 < '\u0800') {
                utf8Length += 127 - c4 >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c4 || c4 > '\udfff') continue;
            if (Character.codePointAt(sequence, i4) == c4) {
                throw new IllegalArgumentException(Utf8.unpairedSurrogateMsg(i4));
            }
            ++i4;
        }
        return utf8Length;
    }

    public static boolean isWellFormed(byte[] bytes) {
        return Utf8.isWellFormed(bytes, 0, bytes.length);
    }

    public static boolean isWellFormed(byte[] bytes, int off, int len) {
        int end = off + len;
        Preconditions.checkPositionIndexes(off, end, bytes.length);
        for (int i4 = off; i4 < end; ++i4) {
            if (bytes[i4] >= 0) continue;
            return Utf8.isWellFormedSlowPath(bytes, i4, end);
        }
        return true;
    }

    private static boolean isWellFormedSlowPath(byte[] bytes, int off, int end) {
        int index = off;
        while (true) {
            byte byte2;
            byte byte1;
            if (index >= end) {
                return true;
            }
            if ((byte1 = bytes[index++]) >= 0) continue;
            if (byte1 < -32) {
                if (index == end) {
                    return false;
                }
                if (byte1 >= -62 && bytes[index++] <= -65) continue;
                return false;
            }
            if (byte1 < -16) {
                if (index + 1 >= end) {
                    return false;
                }
                if (!((byte2 = bytes[index++]) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && -96 <= byte2) && bytes[index++] <= -65) continue;
                return false;
            }
            if (index + 2 >= end) {
                return false;
            }
            if ((byte2 = bytes[index++]) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || bytes[index++] > -65 || bytes[index++] > -65) break;
        }
        return false;
    }

    private static String unpairedSurrogateMsg(int i4) {
        return new StringBuilder(39).append("Unpaired surrogate at index ").append(i4).toString();
    }

    private Utf8() {
    }
}

