/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Compressor;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Location;
import com.android.zipflinger.PayloadInputStream;
import com.android.zipflinger.Zip64;
import com.android.zipflinger.ZipMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;

public class ZipRepo
implements Closeable {
    private final ZipMap zipMap;
    private final FileChannel channel;
    private final File file;

    public ZipRepo(String filePath) throws IOException {
        this(ZipMap.from(new File(filePath), false, Zip64.Policy.ALLOW));
    }

    public ZipRepo(File file) throws IOException {
        this(ZipMap.from(file, false, Zip64.Policy.ALLOW));
    }

    public ZipRepo(Path path) throws IOException {
        this(ZipMap.from(path.toFile(), false, Zip64.Policy.ALLOW));
    }

    public ZipRepo(ZipMap zipMap) throws IOException {
        this.zipMap = zipMap;
        this.channel = FileChannel.open(zipMap.getFile().toPath(), StandardOpenOption.READ);
        this.file = zipMap.getFile();
    }

    public Map<String, Entry> getEntries() {
        return this.zipMap.getEntries();
    }

    ZipMap getZipMap() {
        return this.zipMap;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public InputStream getContent(String entryName) throws IOException {
        Entry entry = this.zipMap.getEntries().get(entryName);
        if (entry == null) {
            String msg = String.format("No entry '%s' in file '%s'", entryName, this.file);
            throw new IllegalArgumentException(msg);
        }
        Location payloadLocation = entry.getPayloadLocation();
        PayloadInputStream inputStream = new PayloadInputStream(this.channel, payloadLocation);
        if (!entry.isCompressed()) {
            return inputStream;
        }
        return Compressor.wrapToInflate(inputStream);
    }
}

