/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.CodeTransparencyOuterClass;
import com.android.tools.build.bundletool.commands.AutoValue_AddTransparencyCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.io.AppBundleSerializer;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.Password;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.transparency.CodeTransparencyFactory;
import com.google.auto.value.AutoValue;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Optional;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@AutoValue
public abstract class AddTransparencyCommand {
    public static final String COMMAND_NAME = "add-transparency";
    private static final Flag<Path> BUNDLE_LOCATION_FLAG = Flag.path("bundle");
    private static final Flag<Path> OUTPUT_FLAG = Flag.path("output");
    private static final Flag<Path> KEYSTORE_FLAG = Flag.path("ks");
    private static final Flag<String> KEY_ALIAS_FLAG = Flag.string("ks-key-alias");
    private static final Flag<Password> KEYSTORE_PASSWORD_FLAG = Flag.password("ks-pass");
    private static final Flag<Password> KEY_PASSWORD_FLAG = Flag.password("key-pass");

    public abstract Path getBundlePath();

    public abstract Path getOutputPath();

    public abstract SignerConfig getSignerConfig();

    public static Builder builder() {
        return new AutoValue_AddTransparencyCommand.Builder();
    }

    public static AddTransparencyCommand fromFlags(ParsedFlags flags) {
        Path keystorePath = KEYSTORE_FLAG.getRequiredValue(flags);
        String keyAlias = KEY_ALIAS_FLAG.getRequiredValue(flags);
        Optional<Password> keystorePassword = KEYSTORE_PASSWORD_FLAG.getValue(flags);
        Optional<Password> keyPassword = KEY_PASSWORD_FLAG.getValue(flags);
        SignerConfig signerConfig = SignerConfig.extractFromKeystore(keystorePath, keyAlias, keystorePassword, keyPassword);
        Builder addTransparencyCommandBuilder = AddTransparencyCommand.builder().setBundlePath(BUNDLE_LOCATION_FLAG.getRequiredValue(flags)).setOutputPath(OUTPUT_FLAG.getRequiredValue(flags)).setSignerConfig(signerConfig);
        flags.checkNoUnknownFlags();
        return addTransparencyCommandBuilder.build();
    }

    public void execute() {
        this.validateInputs();
        try (ZipFile bundleZip = new ZipFile(this.getBundlePath().toFile());){
            AppBundle inputBundle = AppBundle.buildFromZip(bundleZip);
            if (inputBundle.hasSharedUserId()) {
                throw InvalidBundleException.builder().withUserMessage("Transparency can not be added because `sharedUserId` attribute is specified in one of the manifests.").build();
            }
            AppBundle.Builder bundleBuilder = inputBundle.toBuilder();
            bundleBuilder.setBundleMetadata(inputBundle.getBundleMetadata().toBuilder().addFile("com.android.tools.build.bundletool", "code_transparency.json", AddTransparencyCommand.toJsonBytes(CodeTransparencyFactory.createCodeTransparencyMetadata(inputBundle))).build());
            new AppBundleSerializer().writeToDisk(bundleBuilder.build(), this.getOutputPath());
        }
        catch (ZipException e4) {
            throw InvalidBundleException.builder().withCause(e4).withUserMessage("The App Bundle is not a valid zip file.").build();
        }
        catch (IOException e5) {
            throw new UncheckedIOException("An error occurred when processing the App Bundle.", e5);
        }
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Generates code transparency file and adds it to the output bundle.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(BUNDLE_LOCATION_FLAG.getName()).setExampleValue("path/to/bundle.aab").setDescription("Path to the Android App Bundle that we want to add transparency file to.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FLAG.getName()).setExampleValue("path/to/bundle_with_transparency.aab").setDescription("Path to where the output bundle should be written.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEYSTORE_FLAG.getName()).setExampleValue("path/to/keystore").setDescription("Path to the keystore that should be used to sign the code transparency file.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEY_ALIAS_FLAG.getName()).setExampleValue("key-alias").setDescription("Alias of the key to use in the keystore to sign the code transparency file.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEYSTORE_PASSWORD_FLAG.getName()).setExampleValue("[pass|file]:value").setOptional(true).setDescription("Password of the keystore to use to sign the code transparency file. Must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the password will be requested on the prompt.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEY_PASSWORD_FLAG.getName()).setExampleValue("[pass|file]:value").setOptional(true).setDescription("Password of the key in the keystore to use to sign the code transparency file. Must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the keystore password will be tried. If that fails, the password will be requested on the prompt.").build()).build();
    }

    private static ByteSource toJsonBytes(CodeTransparencyOuterClass.CodeTransparency codeTransparency) throws InvalidProtocolBufferException {
        return CharSource.wrap(JsonFormat.printer().print(codeTransparency)).asByteSource(Charset.defaultCharset());
    }

    private void validateInputs() {
        FilePreconditions.checkFileHasExtension("AAB file", this.getBundlePath(), ".aab");
        FilePreconditions.checkFileExistsAndReadable(this.getBundlePath());
        FilePreconditions.checkFileHasExtension("AAB file", this.getOutputPath(), ".aab");
        FilePreconditions.checkFileDoesNotExist(this.getOutputPath());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBundlePath(Path var1);

        public abstract Builder setOutputPath(Path var1);

        public abstract Builder setSignerConfig(SignerConfig var1);

        public abstract AddTransparencyCommand build();
    }
}

