/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.zfile;

import com.android.tools.build.apkzlib.sign.ManifestGenerationExtension;
import com.android.tools.build.apkzlib.sign.SigningExtension;
import com.android.tools.build.apkzlib.sign.SigningOptions;
import com.android.tools.build.apkzlib.zip.AlignmentRule;
import com.android.tools.build.apkzlib.zip.AlignmentRules;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.android.tools.build.apkzlib.zip.ZFileOptions;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;

public class ZFiles {
    private static final AlignmentRule APK_DEFAULT_RULE = AlignmentRules.constant(4);
    private static final String DEFAULT_BUILD_BY = "Generated-by-ADT";
    private static final String DEFAULT_CREATED_BY = "Generated-by-ADT";

    public static ZFile apk(File f4, ZFileOptions options) throws IOException {
        options.setAlignmentRule(AlignmentRules.compose(options.getAlignmentRule(), APK_DEFAULT_RULE));
        return ZFile.openReadWrite(f4, options);
    }

    public static ZFile apk(File f4, ZFileOptions options, Optional<SigningOptions> signingOptions, @Nullable String builtBy, @Nullable String createdBy) throws IOException {
        return ZFiles.apk(f4, options, signingOptions, builtBy, createdBy, true);
    }

    @Deprecated
    public static ZFile apk(File f4, ZFileOptions options, Optional<SigningOptions> signingOptions, @Nullable String builtBy, @Nullable String createdBy, boolean writeManifest) throws IOException {
        ZFile zfile = ZFiles.apk(f4, options);
        if (signingOptions.isPresent() && signingOptions.get().isV1SigningEnabled() || writeManifest) {
            if (builtBy == null) {
                builtBy = "Generated-by-ADT";
            }
            if (createdBy == null) {
                createdBy = "Generated-by-ADT";
            }
            ManifestGenerationExtension manifestExt = new ManifestGenerationExtension(builtBy, createdBy);
            manifestExt.register(zfile);
        }
        if (signingOptions.isPresent()) {
            SigningOptions signOptions = signingOptions.get();
            try {
                new SigningExtension(signOptions).register(zfile);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e4) {
                throw new IOException("Failed to create signature extensions", e4);
            }
        }
        return zfile;
    }
}

