/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import java.io.File;
import java.io.IOException;
import org.jf.baksmali.Baksmali;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.analysis.InlineMethodResolver;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedOdexFile;
import org.jf.dexlib2.iface.MultiDexContainer;

public class SmaliDecoder {
    private final File mApkFile;
    private final File mOutDir;
    private final String mDexFile;
    private final boolean mBakDeb;
    private final int mApi;

    public static void decode(File apkFile, File outDir, String dexName, boolean bakdeb, int api) throws AndrolibException {
        new SmaliDecoder(apkFile, outDir, dexName, bakdeb, api).decode();
    }

    private SmaliDecoder(File apkFile, File outDir, String dexName, boolean bakdeb, int api) {
        this.mApkFile = apkFile;
        this.mOutDir = outDir;
        this.mDexFile = dexName;
        this.mBakDeb = bakdeb;
        this.mApi = api;
    }

    private void decode() throws AndrolibException {
        try {
            MultiDexContainer<? extends DexBackedDexFile> container;
            MultiDexContainer.DexEntry<? extends DexBackedDexFile> dexEntry;
            BaksmaliOptions options = new BaksmaliOptions();
            options.deodex = false;
            options.implicitReferences = false;
            options.parameterRegisters = true;
            options.localsDirective = true;
            options.sequentialLabels = true;
            options.debugInfo = this.mBakDeb;
            options.codeOffsets = false;
            options.accessorComments = false;
            options.registerInfo = 0;
            options.inlineResolver = null;
            int jobs = Runtime.getRuntime().availableProcessors();
            if (jobs > 6) {
                jobs = 6;
            }
            if ((dexEntry = (container = DexFileFactory.loadDexContainer(this.mApkFile, Opcodes.forApi(this.mApi))).getDexEntryNames().size() == 1 ? container.getEntry(container.getDexEntryNames().get(0)) : container.getEntry(this.mDexFile)) == null) {
                dexEntry = container.getEntry(container.getDexEntryNames().get(0));
            }
            assert (dexEntry != null);
            DexBackedDexFile dexFile = dexEntry.getDexFile();
            if (dexFile.supportsOptimizedOpcodes()) {
                throw new AndrolibException("Warning: You are disassembling an odex file without deodexing it.");
            }
            if (dexFile instanceof DexBackedOdexFile) {
                options.inlineResolver = InlineMethodResolver.createInlineMethodResolver(((DexBackedOdexFile)dexFile).getOdexVersion());
            }
            Baksmali.disassembleDexFile(dexFile, this.mOutDir, jobs, options);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }
}

