/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable.debug;

import com.google.common.collect.ImmutableList;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.debug.EndLocal;
import org.jf.dexlib2.iface.debug.EpilogueBegin;
import org.jf.dexlib2.iface.debug.LineNumber;
import org.jf.dexlib2.iface.debug.PrologueEnd;
import org.jf.dexlib2.iface.debug.RestartLocal;
import org.jf.dexlib2.iface.debug.SetSourceFile;
import org.jf.dexlib2.iface.debug.StartLocal;
import org.jf.dexlib2.immutable.debug.ImmutableEndLocal;
import org.jf.dexlib2.immutable.debug.ImmutableEpilogueBegin;
import org.jf.dexlib2.immutable.debug.ImmutableLineNumber;
import org.jf.dexlib2.immutable.debug.ImmutablePrologueEnd;
import org.jf.dexlib2.immutable.debug.ImmutableRestartLocal;
import org.jf.dexlib2.immutable.debug.ImmutableSetSourceFile;
import org.jf.dexlib2.immutable.debug.ImmutableStartLocal;
import org.jf.util.ExceptionWithContext;
import org.jf.util.ImmutableConverter;

public abstract class ImmutableDebugItem
implements DebugItem {
    protected final int codeAddress;
    private static final ImmutableConverter<ImmutableDebugItem, DebugItem> CONVERTER = new ImmutableConverter<ImmutableDebugItem, DebugItem>(){

        @Override
        protected boolean isImmutable(DebugItem item) {
            return item instanceof ImmutableDebugItem;
        }

        @Override
        protected ImmutableDebugItem makeImmutable(DebugItem item) {
            return ImmutableDebugItem.of(item);
        }
    };

    public ImmutableDebugItem(int codeAddress) {
        this.codeAddress = codeAddress;
    }

    public static ImmutableDebugItem of(DebugItem debugItem) {
        if (debugItem instanceof ImmutableDebugItem) {
            return (ImmutableDebugItem)debugItem;
        }
        switch (debugItem.getDebugItemType()) {
            case 3: {
                return ImmutableStartLocal.of((StartLocal)debugItem);
            }
            case 5: {
                return ImmutableEndLocal.of((EndLocal)debugItem);
            }
            case 6: {
                return ImmutableRestartLocal.of((RestartLocal)debugItem);
            }
            case 7: {
                return ImmutablePrologueEnd.of((PrologueEnd)debugItem);
            }
            case 8: {
                return ImmutableEpilogueBegin.of((EpilogueBegin)debugItem);
            }
            case 9: {
                return ImmutableSetSourceFile.of((SetSourceFile)debugItem);
            }
            case 10: {
                return ImmutableLineNumber.of((LineNumber)debugItem);
            }
        }
        throw new ExceptionWithContext("Invalid debug item type: %d", debugItem.getDebugItemType());
    }

    @Override
    public int getCodeAddress() {
        return this.codeAddress;
    }

    public static ImmutableList<ImmutableDebugItem> immutableListOf(Iterable<? extends DebugItem> list) {
        return CONVERTER.toList(list);
    }
}

