/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import brut.common.InvalidUnknownFileException;
import brut.common.RootUnknownFileException;
import brut.common.TraversalUnknownFileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class BrutIO {
    public static void copyAndClose(InputStream in, OutputStream out) throws IOException {
        try {
            IOUtils.copy(in, out);
        }
        finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
    }

    public static long recursiveModifiedTime(File[] files) {
        long modified = 0L;
        for (File file : files) {
            long submodified = BrutIO.recursiveModifiedTime(file);
            if (submodified <= modified) continue;
            modified = submodified;
        }
        return modified;
    }

    public static long recursiveModifiedTime(File file) {
        long modified = file.lastModified();
        if (file.isDirectory()) {
            File[] subfiles;
            for (File subfile : subfiles = file.listFiles()) {
                long submodified = BrutIO.recursiveModifiedTime(subfile);
                if (submodified <= modified) continue;
                modified = submodified;
            }
        }
        return modified;
    }

    public static CRC32 calculateCrc(InputStream input) throws IOException {
        int bytesRead;
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        while ((bytesRead = input.read(buffer)) != -1) {
            crc.update(buffer, 0, bytesRead);
        }
        return crc;
    }

    public static String sanitizeUnknownFile(File directory, String entry) throws IOException, BrutException {
        if (entry.length() == 0) {
            throw new InvalidUnknownFileException("Invalid Unknown File");
        }
        if (new File(entry).isAbsolute()) {
            throw new RootUnknownFileException("Absolute Unknown Files is not allowed");
        }
        String canonicalDirPath = directory.getCanonicalPath() + File.separator;
        String canonicalEntryPath = new File(directory, entry).getCanonicalPath();
        if (!canonicalEntryPath.startsWith(canonicalDirPath)) {
            throw new TraversalUnknownFileException("Directory Traversal is not allowed");
        }
        return canonicalEntryPath.substring(canonicalDirPath.length());
    }

    public static String normalizePath(String path) {
        char separator = File.separatorChar;
        if (separator != '/') {
            return path.replace(separator, '/');
        }
        return path;
    }

    public static void copy(File inputFile, ZipOutputStream outputFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(inputFile);){
            IOUtils.copy((InputStream)fis, (OutputStream)outputFile);
        }
    }

    public static void copy(ZipFile inputFile, ZipOutputStream outputFile, ZipEntry entry) throws IOException {
        try (InputStream is = inputFile.getInputStream(entry);){
            IOUtils.copy(is, (OutputStream)outputFile);
        }
    }
}

