/*
 * Decompiled with CFR 0.152.
 */
package brut.apktool;

import brut.androlib.Androlib;
import brut.androlib.AndrolibException;
import brut.androlib.ApkDecoder;
import brut.androlib.ApktoolProperties;
import brut.androlib.err.CantFindFrameworkResException;
import brut.androlib.err.InFileNotFoundException;
import brut.androlib.err.OutDirExistsException;
import brut.androlib.options.BuildOptions;
import brut.common.BrutException;
import brut.directory.DirectoryException;
import brut.util.AaptManager;
import brut.util.OSDetection;
import java.io.File;
import java.io.IOException;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    private static boolean advanceMode = false;
    private static final Options normalOptions = new Options();
    private static final Options decodeOptions;
    private static final Options buildOptions;
    private static final Options frameOptions;
    private static final Options allOptions;
    private static final Options emptyOptions;
    private static final Options emptyFrameworkOptions;
    private static final Options listFrameworkOptions;

    public static void main(String[] args) throws BrutException {
        CommandLine commandLine;
        System.setProperty("java.awt.headless", "true");
        Verbosity verbosity = Verbosity.NORMAL;
        DefaultParser parser = new DefaultParser();
        Main._Options();
        try {
            commandLine = parser.parse(allOptions, args, false);
            if (!OSDetection.is64Bit()) {
                System.err.println("32 bit support is deprecated. Apktool will not support 32bit on v3.0.0.");
            }
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            Main.usage();
            System.exit(1);
            return;
        }
        if (commandLine.hasOption("-v") || commandLine.hasOption("--verbose")) {
            verbosity = Verbosity.VERBOSE;
        } else if (commandLine.hasOption("-q") || commandLine.hasOption("--quiet")) {
            verbosity = Verbosity.QUIET;
        }
        Main.setupLogging(verbosity);
        if (commandLine.hasOption("advance") || commandLine.hasOption("advanced")) {
            Main.setAdvanceMode();
        }
        boolean cmdFound = false;
        for (String opt : commandLine.getArgs()) {
            if (opt.equalsIgnoreCase("d") || opt.equalsIgnoreCase("decode")) {
                Main.cmdDecode(commandLine);
                cmdFound = true;
                continue;
            }
            if (opt.equalsIgnoreCase("b") || opt.equalsIgnoreCase("build")) {
                Main.cmdBuild(commandLine);
                cmdFound = true;
                continue;
            }
            if (opt.equalsIgnoreCase("if") || opt.equalsIgnoreCase("install-framework")) {
                Main.cmdInstallFramework(commandLine);
                cmdFound = true;
                continue;
            }
            if (opt.equalsIgnoreCase("empty-framework-dir")) {
                Main.cmdEmptyFrameworkDirectory(commandLine);
                cmdFound = true;
                continue;
            }
            if (opt.equalsIgnoreCase("list-frameworks")) {
                Main.cmdListFrameworks(commandLine);
                cmdFound = true;
                continue;
            }
            if (!opt.equalsIgnoreCase("publicize-resources")) continue;
            Main.cmdPublicizeResources(commandLine);
            cmdFound = true;
        }
        if (!cmdFound) {
            if (commandLine.hasOption("version")) {
                Main._version();
                System.exit(0);
            } else {
                Main.usage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cmdDecode(CommandLine cli) throws AndrolibException {
        File outDir;
        ApkDecoder decoder = new ApkDecoder();
        int paraCount = cli.getArgList().size();
        String apkName = cli.getArgList().get(paraCount - 1);
        if (cli.hasOption("s") || cli.hasOption("no-src")) {
            decoder.setDecodeSources((short)0);
        }
        if (cli.hasOption("only-main-classes")) {
            decoder.setDecodeSources((short)16);
        }
        if (cli.hasOption("d") || cli.hasOption("debug")) {
            System.err.println("SmaliDebugging has been removed in 2.1.0 onward. Please see: https://github.com/iBotPeaches/Apktool/issues/1061");
            System.exit(1);
        }
        if (cli.hasOption("b") || cli.hasOption("no-debug-info")) {
            decoder.setBaksmaliDebugMode(false);
        }
        if (cli.hasOption("t") || cli.hasOption("frame-tag")) {
            decoder.setFrameworkTag(cli.getOptionValue("t"));
        }
        if (cli.hasOption("f") || cli.hasOption("force")) {
            decoder.setForceDelete(true);
        }
        if (cli.hasOption("r") || cli.hasOption("no-res")) {
            decoder.setDecodeResources((short)256);
        }
        if (cli.hasOption("force-manifest")) {
            decoder.setForceDecodeManifest((short)1);
        }
        if (cli.hasOption("no-assets")) {
            decoder.setDecodeAssets((short)0);
        }
        if (cli.hasOption("k") || cli.hasOption("keep-broken-res")) {
            decoder.setKeepBrokenResources(true);
        }
        if (cli.hasOption("p") || cli.hasOption("frame-path")) {
            decoder.setFrameworkDir(cli.getOptionValue("p"));
        }
        if (cli.hasOption("m") || cli.hasOption("match-original")) {
            decoder.setAnalysisMode(true);
        }
        if (cli.hasOption("api") || cli.hasOption("api-level")) {
            decoder.setApiLevel(Integer.parseInt(cli.getOptionValue("api")));
        }
        if (cli.hasOption("o") || cli.hasOption("output")) {
            outDir = new File(cli.getOptionValue("o"));
        } else {
            String outName = apkName;
            outName = outName.endsWith(".apk") ? outName.substring(0, outName.length() - 4).trim() : outName + ".out";
            outName = new File(outName).getName();
            outDir = new File(outName);
        }
        decoder.setOutDir(outDir);
        decoder.setApkFile(new File(apkName));
        try {
            decoder.decode();
        }
        catch (OutDirExistsException ex) {
            System.err.println("Destination directory (" + outDir.getAbsolutePath() + ") already exists. Use -f switch if you want to overwrite it.");
            System.exit(1);
        }
        catch (InFileNotFoundException ex) {
            System.err.println("Input file (" + apkName + ") was not found or was not readable.");
            System.exit(1);
        }
        catch (CantFindFrameworkResException ex) {
            System.err.println("Can't find framework resources for package of id: " + ex.getPkgId() + ". You must install proper framework files, see project website for more info.");
            System.exit(1);
        }
        catch (IOException ex) {
            System.err.println("Could not modify file. Please ensure you have permission.");
            System.exit(1);
        }
        catch (DirectoryException ex) {
            System.err.println("Could not modify internal dex files. Please ensure you have permission.");
            System.exit(1);
        }
        finally {
            try {
                decoder.close();
            }
            catch (IOException ex) {}
        }
    }

    private static void cmdBuild(CommandLine cli) {
        File aabFile;
        String[] args = cli.getArgs();
        String appDirName = args.length < 2 ? "." : args[1];
        BuildOptions buildOptions = new BuildOptions();
        if (cli.hasOption("f") || cli.hasOption("force-all")) {
            buildOptions.forceBuildAll = true;
        }
        if (cli.hasOption("d") || cli.hasOption("debug")) {
            buildOptions.debugMode = true;
        }
        if (cli.hasOption("v") || cli.hasOption("verbose")) {
            buildOptions.verbose = true;
        }
        if (cli.hasOption("M") || cli.hasOption("proto-format")) {
            buildOptions.protoFormat = true;
            buildOptions.useAapt2 = true;
        }
        if (cli.hasOption("a") || cli.hasOption("aapt")) {
            buildOptions.aaptPath = cli.getOptionValue("a");
        }
        if (cli.hasOption("c") || cli.hasOption("copy-original")) {
            System.err.println("-c/--copy-original has been deprecated. Removal planned for v3.0.0 (#2129)");
            buildOptions.copyOriginalFiles = true;
        }
        if (cli.hasOption("p") || cli.hasOption("frame-path")) {
            buildOptions.frameworkFolderLocation = cli.getOptionValue("p");
        }
        if (cli.hasOption("nc") || cli.hasOption("no-crunch")) {
            buildOptions.noCrunch = true;
        }
        if (cli.hasOption("use-aapt2")) {
            buildOptions.useAapt2 = true;
        }
        if (cli.hasOption("api") || cli.hasOption("api-level")) {
            buildOptions.forceApi = Integer.parseInt(cli.getOptionValue("api"));
        }
        File outFile = cli.hasOption("o") || cli.hasOption("output") ? new File(cli.getOptionValue("o")) : null;
        if (buildOptions.protoFormat) {
            if (cli.hasOption("aab") || cli.hasOption("A")) {
                aabFile = new File(cli.getOptionValue("A"));
            } else {
                aabFile = null;
                System.err.println("-m is only supported with --aab");
                System.exit(1);
            }
        } else {
            aabFile = null;
        }
        try {
            if (cli.hasOption("a") || cli.hasOption("aapt")) {
                buildOptions.aaptVersion = AaptManager.getAaptVersion(cli.getOptionValue("a"));
            }
            new Androlib(buildOptions).build(new File(appDirName), outFile, aabFile);
        }
        catch (BrutException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    private static void cmdInstallFramework(CommandLine cli) throws AndrolibException {
        int paraCount = cli.getArgList().size();
        String apkName = cli.getArgList().get(paraCount - 1);
        BuildOptions buildOptions = new BuildOptions();
        if (cli.hasOption("p") || cli.hasOption("frame-path")) {
            buildOptions.frameworkFolderLocation = cli.getOptionValue("p");
        }
        if (cli.hasOption("t") || cli.hasOption("tag")) {
            buildOptions.frameworkTag = cli.getOptionValue("t");
        }
        new Androlib(buildOptions).installFramework(new File(apkName));
    }

    private static void cmdListFrameworks(CommandLine cli) throws AndrolibException {
        BuildOptions buildOptions = new BuildOptions();
        if (cli.hasOption("p") || cli.hasOption("frame-path")) {
            buildOptions.frameworkFolderLocation = cli.getOptionValue("p");
        }
        new Androlib(buildOptions).listFrameworks();
    }

    private static void cmdPublicizeResources(CommandLine cli) throws AndrolibException {
        int paraCount = cli.getArgList().size();
        String apkName = cli.getArgList().get(paraCount - 1);
        new Androlib().publicizeResources(new File(apkName));
    }

    private static void cmdEmptyFrameworkDirectory(CommandLine cli) throws AndrolibException {
        BuildOptions buildOptions = new BuildOptions();
        if (cli.hasOption("f") || cli.hasOption("force")) {
            buildOptions.forceDeleteFramework = true;
        }
        if (cli.hasOption("p") || cli.hasOption("frame-path")) {
            buildOptions.frameworkFolderLocation = cli.getOptionValue("p");
        }
        new Androlib(buildOptions).emptyFrameworkDirectory();
    }

    private static void _version() {
        System.out.println(Androlib.getVersion());
    }

    private static void _Options() {
        Option versionOption = Option.builder("version").longOpt("version").desc("prints the version then exits").build();
        Option advanceOption = Option.builder("advance").longOpt("advanced").desc("prints advance information.").build();
        Option noSrcOption = Option.builder("s").longOpt("no-src").desc("Do not decode sources.").build();
        Option onlyMainClassesOption = Option.builder().longOpt("only-main-classes").desc("Only disassemble the main dex classes (classes[0-9]*.dex) in the root.").build();
        Option noResOption = Option.builder("r").longOpt("no-res").desc("Do not decode resources.").build();
        Option forceManOption = Option.builder().longOpt("force-manifest").desc("Decode the APK's compiled manifest, even if decoding of resources is set to \"false\".").build();
        Option noAssetOption = Option.builder().longOpt("no-assets").desc("Do not decode assets.").build();
        Option debugDecOption = Option.builder("d").longOpt("debug").desc("REMOVED (DOES NOT WORK): Decode in debug mode.").build();
        Option analysisOption = Option.builder("m").longOpt("match-original").desc("Keeps files to closest to original as possible. Prevents rebuild.").build();
        Option apiLevelOption = Option.builder("api").longOpt("api-level").desc("The numeric api-level of the file to generate, e.g. 14 for ICS.").hasArg(true).argName("API").build();
        Option debugBuiOption = Option.builder("d").longOpt("debug").desc("Sets android:debuggable to \"true\" in the APK's compiled manifest").build();
        Option noDbgOption = Option.builder("b").longOpt("no-debug-info").desc("don't write out debug info (.local, .param, .line, etc.)").build();
        Option forceDecOption = Option.builder("f").longOpt("force").desc("Force delete destination directory.").build();
        Option frameTagOption = Option.builder("t").longOpt("frame-tag").desc("Uses framework files tagged by <tag>.").hasArg(true).argName("tag").build();
        Option frameDirOption = Option.builder("p").longOpt("frame-path").desc("Uses framework files located in <dir>.").hasArg(true).argName("dir").build();
        Option frameIfDirOption = Option.builder("p").longOpt("frame-path").desc("Stores framework files into <dir>.").hasArg(true).argName("dir").build();
        Option keepResOption = Option.builder("k").longOpt("keep-broken-res").desc("Use if there was an error and some resources were dropped, e.g.\n            \"Invalid config flags detected. Dropping resources\", but you\n            want to decode them anyway, even with errors. You will have to\n            fix them manually before building.").build();
        Option forceBuiOption = Option.builder("f").longOpt("force-all").desc("Skip changes detection and build all files.").build();
        Option aaptOption = Option.builder("a").longOpt("aapt").hasArg(true).argName("loc").desc("Loads aapt from specified location.").build();
        Option aapt2Option = Option.builder().longOpt("use-aapt2").desc("Upgrades apktool to use experimental aapt2 binary.").build();
        Option originalOption = Option.builder("c").longOpt("copy-original").desc("Copies original AndroidManifest.xml and META-INF. See project page for more info.").build();
        Option noCrunchOption = Option.builder("nc").longOpt("no-crunch").desc("Disable crunching of resource files during the build step.").build();
        Option tagOption = Option.builder("t").longOpt("tag").desc("Tag frameworks using <tag>.").hasArg(true).argName("tag").build();
        Option outputBuiOption = Option.builder("o").longOpt("output").desc("The name of apk that gets written. Default is dist/name.apk").hasArg(true).argName("dir").build();
        Option outputDecOption = Option.builder("o").longOpt("output").desc("The name of folder that gets written. Default is apk.out").hasArg(true).argName("dir").build();
        Option quietOption = Option.builder("q").longOpt("quiet").build();
        Option verboseOption = Option.builder("v").longOpt("verbose").build();
        Option aabBuiOption = Option.builder("A").longOpt("aab").desc("aab dir path").hasArg(true).argName("dir").build();
        Option protoOption = Option.builder("M").longOpt("proto-format").desc("build resource use proto format.").build();
        if (Main.isAdvanceMode()) {
            decodeOptions.addOption(noDbgOption);
            decodeOptions.addOption(keepResOption);
            decodeOptions.addOption(analysisOption);
            decodeOptions.addOption(onlyMainClassesOption);
            decodeOptions.addOption(apiLevelOption);
            decodeOptions.addOption(noAssetOption);
            decodeOptions.addOption(forceManOption);
            buildOptions.addOption(apiLevelOption);
            buildOptions.addOption(debugBuiOption);
            buildOptions.addOption(aaptOption);
            buildOptions.addOption(originalOption);
            buildOptions.addOption(aapt2Option);
            buildOptions.addOption(noCrunchOption);
        }
        normalOptions.addOption(versionOption);
        normalOptions.addOption(advanceOption);
        decodeOptions.addOption(frameTagOption);
        decodeOptions.addOption(outputDecOption);
        decodeOptions.addOption(frameDirOption);
        decodeOptions.addOption(forceDecOption);
        decodeOptions.addOption(noSrcOption);
        decodeOptions.addOption(noResOption);
        buildOptions.addOption(outputBuiOption);
        buildOptions.addOption(frameDirOption);
        buildOptions.addOption(forceBuiOption);
        frameOptions.addOption(tagOption);
        frameOptions.addOption(frameIfDirOption);
        emptyFrameworkOptions.addOption(forceDecOption);
        emptyFrameworkOptions.addOption(frameIfDirOption);
        listFrameworkOptions.addOption(frameIfDirOption);
        for (Option op : normalOptions.getOptions()) {
            allOptions.addOption(op);
        }
        for (Option op : decodeOptions.getOptions()) {
            allOptions.addOption(op);
        }
        for (Option op : buildOptions.getOptions()) {
            allOptions.addOption(op);
        }
        for (Option op : frameOptions.getOptions()) {
            allOptions.addOption(op);
        }
        allOptions.addOption(apiLevelOption);
        allOptions.addOption(analysisOption);
        allOptions.addOption(debugDecOption);
        allOptions.addOption(noDbgOption);
        allOptions.addOption(forceManOption);
        allOptions.addOption(noAssetOption);
        allOptions.addOption(keepResOption);
        allOptions.addOption(debugBuiOption);
        allOptions.addOption(aaptOption);
        allOptions.addOption(originalOption);
        allOptions.addOption(verboseOption);
        allOptions.addOption(quietOption);
        allOptions.addOption(aapt2Option);
        allOptions.addOption(noCrunchOption);
        allOptions.addOption(onlyMainClassesOption);
        allOptions.addOption(aabBuiOption);
        allOptions.addOption(protoOption);
    }

    private static String verbosityHelp() {
        if (Main.isAdvanceMode()) {
            return "[-q|--quiet OR -v|--verbose] ";
        }
        return "";
    }

    private static void usage() {
        Main._Options();
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(120);
        System.out.println("Apktool v" + Androlib.getVersion() + " - a tool for reengineering Android apk files\nwith smali v" + ApktoolProperties.get("smaliVersion") + " and baksmali v" + ApktoolProperties.get("baksmaliVersion") + "\nCopyright 2010 Ryszard Wi\u8263niewski <brut.alll@gmail.com>\nCopyright 2010 Connor Tumbleson <connor.tumbleson@gmail.com>");
        if (Main.isAdvanceMode()) {
            System.out.println("Apache License 2.0 (https://www.apache.org/licenses/LICENSE-2.0)\n");
        } else {
            System.out.println();
        }
        formatter.printHelp("apktool " + Main.verbosityHelp(), normalOptions);
        formatter.printHelp("apktool " + Main.verbosityHelp() + "if|install-framework [options] <framework.apk>", frameOptions);
        formatter.printHelp("apktool " + Main.verbosityHelp() + "d[ecode] [options] <file_apk>", decodeOptions);
        formatter.printHelp("apktool " + Main.verbosityHelp() + "b[uild] [options] <app_path>", buildOptions);
        if (Main.isAdvanceMode()) {
            formatter.printHelp("apktool " + Main.verbosityHelp() + "publicize-resources <file_path>", emptyOptions);
            formatter.printHelp("apktool " + Main.verbosityHelp() + "empty-framework-dir [options]", emptyFrameworkOptions);
            formatter.printHelp("apktool " + Main.verbosityHelp() + "list-frameworks [options]", listFrameworkOptions);
        }
        System.out.println();
        System.out.println("For additional info, see: https://ibotpeaches.github.io/Apktool/ \nFor smali/baksmali info, see: https://github.com/JesusFreke/smali");
    }

    private static void setupLogging(final Verbosity verbosity) {
        Logger logger = Logger.getLogger("");
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        LogManager.getLogManager().reset();
        if (verbosity == Verbosity.QUIET) {
            return;
        }
        Handler handler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (this.getFormatter() == null) {
                    this.setFormatter(new SimpleFormatter());
                }
                try {
                    String message = this.getFormatter().format(record);
                    if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                        System.err.write(message.getBytes());
                    } else if (record.getLevel().intValue() >= Level.INFO.intValue()) {
                        System.out.write(message.getBytes());
                    } else if (verbosity == Verbosity.VERBOSE) {
                        System.out.write(message.getBytes());
                    }
                }
                catch (Exception exception) {
                    this.reportError(null, exception, 5);
                }
            }

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }
        };
        logger.addHandler(handler);
        if (verbosity == Verbosity.VERBOSE) {
            handler.setLevel(Level.ALL);
            logger.setLevel(Level.ALL);
        } else {
            handler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getLevel().toString().charAt(0) + ": " + record.getMessage() + System.getProperty("line.separator");
                }
            });
        }
    }

    private static boolean isAdvanceMode() {
        return advanceMode;
    }

    private static void setAdvanceMode() {
        advanceMode = true;
    }

    static {
        buildOptions = new Options();
        decodeOptions = new Options();
        frameOptions = new Options();
        allOptions = new Options();
        emptyOptions = new Options();
        emptyFrameworkOptions = new Options();
        listFrameworkOptions = new Options();
    }

    private static enum Verbosity {
        NORMAL,
        VERBOSE,
        QUIET;

    }
}

