/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.xml.ResXmlEncoders;
import java.io.IOException;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlSerializer;

public class ResStringValue
extends ResScalarValue {
    private static final Pattern allDigits = Pattern.compile("\\d{9,}");

    public ResStringValue(String value, int rawValue) {
        this(value, rawValue, "string");
    }

    public ResStringValue(String value, int rawValue, String type) {
        super(type, rawValue, value);
    }

    @Override
    public String encodeAsResXmlAttr() {
        return this.checkIfStringIsNumeric(ResXmlEncoders.encodeAsResXmlAttr(this.mRawValue));
    }

    @Override
    public String encodeAsResXmlItemValue() {
        return ResXmlEncoders.enumerateNonPositionalSubstitutionsIfRequired(ResXmlEncoders.encodeAsXmlValue(this.mRawValue));
    }

    @Override
    public String encodeAsResXmlValue() {
        return ResXmlEncoders.encodeAsXmlValue(this.mRawValue);
    }

    @Override
    protected String encodeAsResXml() throws AndrolibException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void serializeExtraXmlAttrs(XmlSerializer serializer, ResResource res) throws IOException {
        if (ResXmlEncoders.hasMultipleNonPositionalSubstitutions(this.mRawValue)) {
            serializer.attribute(null, "formatted", "false");
        }
    }

    private String checkIfStringIsNumeric(String val) {
        if (val == null || val.isEmpty()) {
            return val;
        }
        return allDigits.matcher(val).matches() ? "\\ " + val : val;
    }
}

