/*
 * Decompiled with CFR 0.152.
 */
package kotlin.sequences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.sequences.ConstrainedOnceSequence;
import kotlin.sequences.EmptySequence;
import kotlin.sequences.FlatteningSequence;
import kotlin.sequences.GeneratorSequence;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.sequences.SequencesKt__SequencesJVMKt;
import kotlin.sequences.SequencesKt__SequencesKt;
import kotlin.sequences.TransformingSequence;

@Metadata(d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\u001a.\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0014\b\u0004\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00050\u0004H\u0087\b\u00f8\u0001\u0000\u001a\u0012\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002\u001ab\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\t\"\u0004\b\u0002\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\t0\f2\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u0002H\t\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00050\u000eH\u0000\u001a&\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u0004\u001a<\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00102\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u00042\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u000e\u001a=\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u0001H\u00022\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u000eH\u0007\u00a2\u0006\u0002\u0010\u0014\u001a+\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0017\"\u0002H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0005\u001a\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001aC\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\b0\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00050\u000eH\u0002\u00a2\u0006\u0002\b\u001c\u001a)\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u001d0\u0001H\u0007\u00a2\u0006\u0002\b\u001e\u001a\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0001\u001a2\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0004H\u0007\u001a!\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001H\u0087\b\u001a\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0001H\u0007\u001a&\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010#\u001a\u00020$H\u0007\u001a@\u0010%\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0'0&\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\b*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\b0&0\u0001\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"Sequence", "Lkotlin/sequences/Sequence;", "T", "iterator", "Lkotlin/Function0;", "", "emptySequence", "flatMapIndexed", "R", "C", "source", "transform", "Lkotlin/Function2;", "", "Lkotlin/Function1;", "generateSequence", "", "nextFunction", "seedFunction", "seed", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lkotlin/sequences/Sequence;", "sequenceOf", "elements", "", "([Ljava/lang/Object;)Lkotlin/sequences/Sequence;", "asSequence", "constrainOnce", "flatten", "flatten$SequencesKt__SequencesKt", "", "flattenSequenceOfIterable", "ifEmpty", "defaultValue", "orEmpty", "shuffled", "random", "Lkotlin/random/Random;", "unzip", "Lkotlin/Pair;", "", "kotlin-stdlib"}, k=5, mv={1, 5, 1}, xi=1, xs="kotlin/sequences/SequencesKt")
class SequencesKt__SequencesKt
extends SequencesKt__SequencesJVMKt {
    private static final <T> Sequence<T> Sequence(Function0<? extends Iterator<? extends T>> function0) {
        return new Sequence<T>(function0){
            final /* synthetic */ Function0 $iterator;
            {
                this.$iterator = function0;
            }

            public Iterator<T> iterator() {
                return (Iterator)this.$iterator.invoke();
            }
        };
    }

    public static final <T> Sequence<T> asSequence(Iterator<? extends T> iterator2) {
        Intrinsics.checkNotNullParameter(iterator2, "$this$asSequence");
        return SequencesKt.constrainOnce((Sequence)new Sequence<T>(iterator2){
            final /* synthetic */ Iterator $this_asSequence$inlined;
            {
                this.$this_asSequence$inlined = iterator2;
            }

            public Iterator<T> iterator() {
                return this.$this_asSequence$inlined;
            }
        });
    }

    public static final <T> Sequence<T> constrainOnce(Sequence<? extends T> sequence) {
        Intrinsics.checkNotNullParameter(sequence, "$this$constrainOnce");
        if (!(sequence instanceof ConstrainedOnceSequence)) {
            sequence = (Sequence)new ConstrainedOnceSequence(sequence);
        }
        return sequence;
    }

    public static final <T> Sequence<T> emptySequence() {
        return (Sequence)EmptySequence.INSTANCE;
    }

    public static final <T, C, R> Sequence<R> flatMapIndexed(Sequence<? extends T> sequence, Function2<? super Integer, ? super T, ? extends C> function2, Function1<? super C, ? extends Iterator<? extends R>> function1) {
        Intrinsics.checkNotNullParameter(sequence, "source");
        Intrinsics.checkNotNullParameter(function2, "transform");
        Intrinsics.checkNotNullParameter(function1, "iterator");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super R>, Continuation<? super Unit>, Object>(sequence, function2, function1, null){
            final /* synthetic */ Function1 $iterator;
            final /* synthetic */ Sequence $source;
            final /* synthetic */ Function2 $transform;
            int I$0;
            private /* synthetic */ Object L$0;
            Object L$1;
            int label;
            {
                this.$source = sequence;
                this.$transform = function2;
                this.$iterator = function1;
                super(2, continuation);
            }

            public final Continuation<Unit> create(Object object, Continuation<?> object2) {
                Intrinsics.checkNotNullParameter(object2, "completion");
                object2 = new /* invalid duplicate definition of identical inner class */;
                object2.L$0 = object;
                return object2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                SequenceScope sequenceScope;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n2 = this.label;
                if (n2 != 0) {
                    if (n2 != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    n2 = this.I$0;
                    Iterator iterator2 = (Iterator)this.L$1;
                    sequenceScope = (SequenceScope)this.L$0;
                    ResultKt.throwOnFailure((Object)object);
                    object = iterator2;
                } else {
                    ResultKt.throwOnFailure((Object)object);
                    sequenceScope = (SequenceScope)this.L$0;
                    n2 = 0;
                    object = this.$source.iterator();
                }
                while (object.hasNext()) {
                    E e2 = object.next();
                    Function2 function2 = this.$transform;
                    int n3 = n2 + 1;
                    if (n2 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    R r2 = function2.invoke(Boxing.boxInt((int)n2), e2);
                    Iterator iterator3 = (Iterator)this.$iterator.invoke(r2);
                    this.L$0 = sequenceScope;
                    this.L$1 = object;
                    this.I$0 = n3;
                    this.label = 1;
                    if (sequenceScope.yieldAll(iterator3, (Continuation)this) == object2) {
                        return object2;
                    }
                    n2 = n3;
                }
                return Unit.INSTANCE;
            }
        });
    }

    public static final <T> Sequence<T> flatten(Sequence<? extends Sequence<? extends T>> sequence) {
        Intrinsics.checkNotNullParameter(sequence, "$this$flatten");
        return SequencesKt__SequencesKt.flatten$SequencesKt__SequencesKt(sequence, flatten.1.INSTANCE);
    }

    private static final <T, R> Sequence<R> flatten$SequencesKt__SequencesKt(Sequence<? extends T> sequence, Function1<? super T, ? extends Iterator<? extends R>> function1) {
        if (sequence instanceof TransformingSequence) {
            return ((TransformingSequence)sequence).flatten$kotlin_stdlib(function1);
        }
        return (Sequence)new FlatteningSequence(sequence, (Function1)flatten.3.INSTANCE, function1);
    }

    public static final <T> Sequence<T> flattenSequenceOfIterable(Sequence<? extends Iterable<? extends T>> sequence) {
        Intrinsics.checkNotNullParameter(sequence, "$this$flatten");
        return SequencesKt__SequencesKt.flatten$SequencesKt__SequencesKt(sequence, flatten.2.INSTANCE);
    }

    public static final <T> Sequence<T> generateSequence(T object, Function1<? super T, ? extends T> function1) {
        Intrinsics.checkNotNullParameter(function1, "nextFunction");
        object = object == null ? (Sequence)EmptySequence.INSTANCE : (Sequence)new GeneratorSequence(new Function0<T>(object){
            final /* synthetic */ Object $seed;
            {
                this.$seed = object;
                super(0);
            }

            public final T invoke() {
                return (T)this.$seed;
            }
        }, function1);
        return object;
    }

    public static final <T> Sequence<T> generateSequence(Function0<? extends T> function0) {
        Intrinsics.checkNotNullParameter(function0, "nextFunction");
        return SequencesKt.constrainOnce((Sequence)((Sequence)new GeneratorSequence(function0, new Function1<T, T>(function0){
            final /* synthetic */ Function0 $nextFunction;
            {
                this.$nextFunction = function0;
                super(1);
            }

            public final T invoke(T t2) {
                Intrinsics.checkNotNullParameter(t2, "it");
                return (T)this.$nextFunction.invoke();
            }
        })));
    }

    public static final <T> Sequence<T> generateSequence(Function0<? extends T> function0, Function1<? super T, ? extends T> function1) {
        Intrinsics.checkNotNullParameter(function0, "seedFunction");
        Intrinsics.checkNotNullParameter(function1, "nextFunction");
        return (Sequence)new GeneratorSequence(function0, function1);
    }

    public static final <T> Sequence<T> ifEmpty(Sequence<? extends T> sequence, Function0<? extends Sequence<? extends T>> function0) {
        Intrinsics.checkNotNullParameter(sequence, "$this$ifEmpty");
        Intrinsics.checkNotNullParameter(function0, "defaultValue");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super T>, Continuation<? super Unit>, Object>(sequence, function0, null){
            final /* synthetic */ Function0 $defaultValue;
            final /* synthetic */ Sequence $this_ifEmpty;
            private /* synthetic */ Object L$0;
            int label;
            {
                this.$this_ifEmpty = sequence;
                this.$defaultValue = function0;
                super(2, continuation);
            }

            public final Continuation<Unit> create(Object object, Continuation<?> object2) {
                Intrinsics.checkNotNullParameter(object2, "completion");
                object2 = new /* invalid duplicate definition of identical inner class */;
                object2.L$0 = object;
                return object2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }

            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n2 = this.label;
                if (n2 != 0) {
                    if (n2 != 1 && n2 != 2) {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    ResultKt.throwOnFailure((Object)object);
                } else {
                    ResultKt.throwOnFailure((Object)object);
                    object = (SequenceScope)this.L$0;
                    Iterator iterator2 = this.$this_ifEmpty.iterator();
                    if (iterator2.hasNext()) {
                        this.label = 1;
                        if (object.yieldAll(iterator2, (Continuation)this) == object2) {
                            return object2;
                        }
                    } else {
                        iterator2 = (Sequence)this.$defaultValue.invoke();
                        this.label = 2;
                        if (object.yieldAll((Sequence)iterator2, (Continuation)this) == object2) {
                            return object2;
                        }
                    }
                }
                return Unit.INSTANCE;
            }
        });
    }

    private static final <T> Sequence<T> orEmpty(Sequence<? extends T> sequence) {
        if (sequence == null) {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    public static final <T> Sequence<T> sequenceOf(T ... sequence) {
        Intrinsics.checkNotNullParameter(sequence, "elements");
        boolean bl = ((T[])sequence).length == 0;
        sequence = bl ? SequencesKt.emptySequence() : ArraysKt.asSequence((Object[])sequence);
        return sequence;
    }

    public static final <T> Sequence<T> shuffled(Sequence<? extends T> sequence) {
        Intrinsics.checkNotNullParameter(sequence, "$this$shuffled");
        return SequencesKt.shuffled(sequence, (Random)Random.Default);
    }

    public static final <T> Sequence<T> shuffled(Sequence<? extends T> sequence, Random random) {
        Intrinsics.checkNotNullParameter(sequence, "$this$shuffled");
        Intrinsics.checkNotNullParameter(random, "random");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super T>, Continuation<? super Unit>, Object>(sequence, random, null){
            final /* synthetic */ Random $random;
            final /* synthetic */ Sequence $this_shuffled;
            private /* synthetic */ Object L$0;
            Object L$1;
            int label;
            {
                this.$this_shuffled = sequence;
                this.$random = random;
                super(2, continuation);
            }

            public final Continuation<Unit> create(Object object, Continuation<?> object2) {
                Intrinsics.checkNotNullParameter(object2, "completion");
                object2 = new /* invalid duplicate definition of identical inner class */;
                object2.L$0 = object;
                return object2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                SequenceScope sequenceScope;
                Object object2;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n2 = this.label;
                if (n2 != 0) {
                    if (n2 != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    object2 = (List)this.L$1;
                    sequenceScope = (SequenceScope)this.L$0;
                    ResultKt.throwOnFailure((Object)object);
                    object = object2;
                } else {
                    ResultKt.throwOnFailure((Object)object);
                    sequenceScope = (SequenceScope)this.L$0;
                    object = SequencesKt.toMutableList((Sequence)this.$this_shuffled);
                }
                while (((Collection)object).isEmpty() ^ true) {
                    Object object4;
                    n2 = this.$random.nextInt(object.size());
                    object2 = object4 = CollectionsKt.removeLast((List)object);
                    if (n2 < object.size()) {
                        object2 = object.set(n2, object4);
                    }
                    this.L$0 = sequenceScope;
                    this.L$1 = object;
                    this.label = 1;
                    if (sequenceScope.yield(object2, (Continuation)this) != object3) continue;
                    return object3;
                }
                return Unit.INSTANCE;
            }
        });
    }

    public static final <T, R> Pair<List<T>, List<R>> unzip(Sequence<? extends Pair<? extends T, ? extends R>> pair2) {
        Intrinsics.checkNotNullParameter(pair2, "$this$unzip");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Pair pair2 : pair2) {
            arrayList.add(pair2.getFirst());
            arrayList2.add(pair2.getSecond());
        }
        return TuplesKt.to(arrayList, arrayList2);
    }
}

