/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.io.Serializable;
import java.util.Arrays;
import kotlin.KotlinNullPointerException;
import kotlin.UninitializedPropertyAccessException;

public class Intrinsics {
    private Intrinsics() {
    }

    public static boolean areEqual(double d2, Double d3) {
        boolean bl = d3 != null && d2 == d3;
        return bl;
    }

    public static boolean areEqual(float f2, Float f3) {
        boolean bl = f3 != null && f2 == f3.floatValue();
        return bl;
    }

    public static boolean areEqual(Double d2, double d3) {
        boolean bl = d2 != null && d2 == d3;
        return bl;
    }

    public static boolean areEqual(Double d2, Double d3) {
        boolean bl = true;
        if (!(d2 == null ? d3 == null : d3 != null && d2.doubleValue() == d3.doubleValue())) {
            bl = false;
        }
        return bl;
    }

    public static boolean areEqual(Float f2, float f3) {
        boolean bl = f2 != null && f2.floatValue() == f3;
        return bl;
    }

    public static boolean areEqual(Float f2, Float f3) {
        boolean bl = true;
        if (!(f2 == null ? f3 == null : f3 != null && f2.floatValue() == f3.floatValue())) {
            bl = false;
        }
        return bl;
    }

    public static boolean areEqual(Object object, Object object2) {
        boolean bl = object == null ? object2 == null : object.equals(object2);
        return bl;
    }

    public static void checkExpressionValueIsNotNull(Object object, String string2) {
        if (object != null) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(" must not be null");
        throw Intrinsics.sanitizeStackTrace(new IllegalStateException(((StringBuilder)object).toString()));
    }

    public static void checkFieldIsNotNull(Object object, String string2) {
        if (object != null) {
            return;
        }
        throw Intrinsics.sanitizeStackTrace(new IllegalStateException(string2));
    }

    public static void checkFieldIsNotNull(Object object, String string2, String string3) {
        if (object != null) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Field specified as non-null is null: ");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(".");
        ((StringBuilder)object).append(string3);
        throw Intrinsics.sanitizeStackTrace(new IllegalStateException(((StringBuilder)object).toString()));
    }

    public static void checkHasClass(String string2) throws ClassNotFoundException {
        string2 = string2.replace('/', '.');
        try {
            Class.forName(string2);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Class ");
            stringBuilder.append(string2);
            stringBuilder.append(" is not found. Please update the Kotlin runtime to the latest version");
            throw Intrinsics.sanitizeStackTrace(new ClassNotFoundException(stringBuilder.toString(), classNotFoundException));
        }
    }

    public static void checkHasClass(String string2, String string3) throws ClassNotFoundException {
        String string4 = string2.replace('/', '.');
        try {
            Class.forName(string4);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Class ");
            stringBuilder.append(string4);
            stringBuilder.append(" is not found: this code requires the Kotlin runtime of version at least ");
            stringBuilder.append(string3);
            throw Intrinsics.sanitizeStackTrace(new ClassNotFoundException(stringBuilder.toString(), classNotFoundException));
        }
    }

    public static void checkNotNull(Object object) {
        if (object == null) {
            Intrinsics.throwJavaNpe();
        }
    }

    public static void checkNotNull(Object object, String string2) {
        if (object == null) {
            Intrinsics.throwJavaNpe(string2);
        }
    }

    public static void checkNotNullExpressionValue(Object object, String string2) {
        if (object != null) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(" must not be null");
        throw Intrinsics.sanitizeStackTrace(new NullPointerException(((StringBuilder)object).toString()));
    }

    public static void checkNotNullParameter(Object object, String string2) {
        if (object == null) {
            Intrinsics.throwParameterIsNullNPE(string2);
        }
    }

    public static void checkParameterIsNotNull(Object object, String string2) {
        if (object == null) {
            Intrinsics.throwParameterIsNullIAE(string2);
        }
    }

    public static void checkReturnedValueIsNotNull(Object object, String string2) {
        if (object != null) {
            return;
        }
        throw Intrinsics.sanitizeStackTrace(new IllegalStateException(string2));
    }

    public static void checkReturnedValueIsNotNull(Object object, String string2, String string3) {
        if (object != null) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Method specified as non-null returned null: ");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(".");
        ((StringBuilder)object).append(string3);
        throw Intrinsics.sanitizeStackTrace(new IllegalStateException(((StringBuilder)object).toString()));
    }

    public static int compare(int n2, int n3) {
        n2 = n2 < n3 ? -1 : (n2 == n3 ? 0 : 1);
        return n2;
    }

    public static int compare(long l2, long l3) {
        int n2 = l2 < l3 ? -1 : (l2 == l3 ? 0 : 1);
        return n2;
    }

    private static String createParameterIsNullExceptionMessage(String string2) {
        Serializable serializable = Thread.currentThread().getStackTrace()[4];
        String string3 = ((StackTraceElement)serializable).getClassName();
        String string4 = ((StackTraceElement)serializable).getMethodName();
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Parameter specified as non-null is null: method ");
        ((StringBuilder)serializable).append(string3);
        ((StringBuilder)serializable).append(".");
        ((StringBuilder)serializable).append(string4);
        ((StringBuilder)serializable).append(", parameter ");
        ((StringBuilder)serializable).append(string2);
        return ((StringBuilder)serializable).toString();
    }

    public static void needClassReification() {
        Intrinsics.throwUndefinedForReified();
    }

    public static void needClassReification(String string2) {
        Intrinsics.throwUndefinedForReified(string2);
    }

    public static void reifiedOperationMarker(int n2, String string2) {
        Intrinsics.throwUndefinedForReified();
    }

    public static void reifiedOperationMarker(int n2, String string2, String string3) {
        Intrinsics.throwUndefinedForReified(string3);
    }

    private static <T extends Throwable> T sanitizeStackTrace(T t2) {
        return Intrinsics.sanitizeStackTrace(t2, Intrinsics.class.getName());
    }

    static <T extends Throwable> T sanitizeStackTrace(T t2, String string2) {
        StackTraceElement[] stackTraceElementArray = t2.getStackTrace();
        int n2 = stackTraceElementArray.length;
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string2.equals(stackTraceElementArray[i2].getClassName())) continue;
            n3 = i2;
        }
        t2.setStackTrace(Arrays.copyOfRange(stackTraceElementArray, n3 + 1, n2));
        return t2;
    }

    public static String stringPlus(String string2, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(object);
        return stringBuilder.toString();
    }

    public static void throwAssert() {
        throw Intrinsics.sanitizeStackTrace(new AssertionError());
    }

    public static void throwAssert(String string2) {
        throw Intrinsics.sanitizeStackTrace(new AssertionError((Object)string2));
    }

    public static void throwIllegalArgument() {
        throw Intrinsics.sanitizeStackTrace(new IllegalArgumentException());
    }

    public static void throwIllegalArgument(String string2) {
        throw Intrinsics.sanitizeStackTrace(new IllegalArgumentException(string2));
    }

    public static void throwIllegalState() {
        throw Intrinsics.sanitizeStackTrace(new IllegalStateException());
    }

    public static void throwIllegalState(String string2) {
        throw Intrinsics.sanitizeStackTrace(new IllegalStateException(string2));
    }

    public static void throwJavaNpe() {
        throw Intrinsics.sanitizeStackTrace(new NullPointerException());
    }

    public static void throwJavaNpe(String string2) {
        throw Intrinsics.sanitizeStackTrace(new NullPointerException(string2));
    }

    public static void throwNpe() {
        throw Intrinsics.sanitizeStackTrace(new KotlinNullPointerException());
    }

    public static void throwNpe(String string2) {
        throw Intrinsics.sanitizeStackTrace(new KotlinNullPointerException(string2));
    }

    private static void throwParameterIsNullIAE(String string2) {
        throw Intrinsics.sanitizeStackTrace(new IllegalArgumentException(Intrinsics.createParameterIsNullExceptionMessage(string2)));
    }

    private static void throwParameterIsNullNPE(String string2) {
        throw Intrinsics.sanitizeStackTrace(new NullPointerException(Intrinsics.createParameterIsNullExceptionMessage(string2)));
    }

    public static void throwUndefinedForReified() {
        Intrinsics.throwUndefinedForReified("This function has a reified type parameter and thus can only be inlined at compilation time, not called directly.");
    }

    public static void throwUndefinedForReified(String string2) {
        throw new UnsupportedOperationException(string2);
    }

    public static void throwUninitializedProperty(String string2) {
        throw Intrinsics.sanitizeStackTrace(new UninitializedPropertyAccessException(string2));
    }

    public static void throwUninitializedPropertyAccessException(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("lateinit property ");
        stringBuilder.append(string2);
        stringBuilder.append(" has not been initialized");
        Intrinsics.throwUninitializedProperty(stringBuilder.toString());
    }

    public static class Kotlin {
        private Kotlin() {
        }
    }
}

