/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilePathComponents;
import kotlin.io.FileSystemException;
import kotlin.io.FilesKt;
import kotlin.io.FilesKt__FileTreeWalkKt;
import kotlin.io.FilesKt__UtilsKt;
import kotlin.io.NoSuchFileException;
import kotlin.io.OnErrorAction;
import kotlin.io.TerminateException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;

@Metadata(d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u001a*\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0007\u001a*\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0007\u001a8\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\u001a\b\u0002\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u001a&\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u000f*\u00020\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0001\u001a\n\u0010\u001c\u001a\u00020\u0002*\u00020\u0002\u001a\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d*\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0002\u00a2\u0006\u0002\b\u001e\u001a\u0011\u0010\u001c\u001a\u00020\u001f*\u00020\u001fH\u0002\u00a2\u0006\u0002\b\u001e\u001a\u0012\u0010 \u001a\u00020\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u0014\u0010\"\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u0012\u0010#\u001a\u00020\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u0012\u0010$\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a\u0012\u0010$\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010&\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a\u0012\u0010&\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010'\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002\u001a\u0012\u0010'\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0012\u0010(\u001a\u00020\u0001*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u001b\u0010)\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\b*\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\u00a8\u0006+"}, d2={"extension", "", "Ljava/io/File;", "getExtension", "(Ljava/io/File;)Ljava/lang/String;", "invariantSeparatorsPath", "getInvariantSeparatorsPath", "nameWithoutExtension", "getNameWithoutExtension", "createTempDir", "prefix", "suffix", "directory", "createTempFile", "copyRecursively", "", "target", "overwrite", "onError", "Lkotlin/Function2;", "Ljava/io/IOException;", "Lkotlin/io/OnErrorAction;", "copyTo", "bufferSize", "", "deleteRecursively", "endsWith", "other", "normalize", "", "normalize$FilesKt__UtilsKt", "Lkotlin/io/FilePathComponents;", "relativeTo", "base", "relativeToOrNull", "relativeToOrSelf", "resolve", "relative", "resolveSibling", "startsWith", "toRelativeString", "toRelativeStringOrNull", "toRelativeStringOrNull$FilesKt__UtilsKt", "kotlin-stdlib"}, k=5, mv={1, 5, 1}, xi=1, xs="kotlin/io/FilesKt")
class FilesKt__UtilsKt
extends FilesKt__FileTreeWalkKt {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean copyRecursively(File file, File file2, boolean bl, Function2<? super File, ? super IOException, ? extends OnErrorAction> function2) {
        Intrinsics.checkNotNullParameter(file, "$this$copyRecursively");
        Intrinsics.checkNotNullParameter(file2, "target");
        Intrinsics.checkNotNullParameter(function2, "onError");
        boolean bl2 = file.exists();
        boolean bl3 = true;
        if (!bl2) {
            if (function2.invoke(file, (IOException)new NoSuchFileException(file, null, "The source file doesn't exist.", 2, null)) == OnErrorAction.TERMINATE) return false;
            return bl3;
        }
        try {
            Object object = FilesKt.walkTopDown(file);
            Function2<File, IOException, Unit> function22 = new Function2<File, IOException, Unit>(function2){
                final /* synthetic */ Function2 $onError;
                {
                    this.$onError = function2;
                    super(2);
                }

                public final void invoke(File file, IOException iOException) {
                    Intrinsics.checkNotNullParameter(file, "f");
                    Intrinsics.checkNotNullParameter(iOException, "e");
                    if ((OnErrorAction)this.$onError.invoke(file, iOException) != OnErrorAction.TERMINATE) {
                        return;
                    }
                    throw (Throwable)new TerminateException(file);
                }
            };
            function22 = object.onFail((Function2)function22).iterator();
            while (function22.hasNext()) {
                boolean bl4;
                Object object2;
                object = (File)function22.next();
                if (!((File)object).exists()) {
                    object2 = new NoSuchFileException((File)object, null, "The source file doesn't exist.", 2, null);
                    if (function2.invoke((File)object, (IOException)object2) != OnErrorAction.TERMINATE) continue;
                    return false;
                }
                String string2 = FilesKt.toRelativeString((File)object, file);
                object2 = new File(file2, string2);
                if (((File)object2).exists() && (!((File)object).isDirectory() || !((File)object2).isDirectory()) && (bl4 = !bl || (((File)object2).isDirectory() ? !FilesKt.deleteRecursively((File)object2) : !((File)object2).delete()))) {
                    string2 = new FileAlreadyExistsException((File)object, (File)object2, "The destination file already exists.");
                    if (function2.invoke((File)object2, (IOException)((Object)string2)) != OnErrorAction.TERMINATE) continue;
                    return false;
                }
                if (((File)object).isDirectory()) {
                    ((File)object2).mkdirs();
                    continue;
                }
                if (FilesKt.copyTo$default((File)object, (File)object2, bl, 0, 4, null).length() == ((File)object).length()) continue;
                object2 = new IOException("Source file wasn't copied completely, length of destination file differs.");
                if ((object2 = function2.invoke((File)object, (IOException)object2)) == (object = OnErrorAction.TERMINATE)) return false;
            }
            return true;
        }
        catch (TerminateException terminateException) {
            return false;
        }
    }

    public static /* synthetic */ boolean copyRecursively$default(File file, File file2, boolean bl, Function2 function2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            function2 = copyRecursively.1.INSTANCE;
        }
        return FilesKt.copyRecursively(file, file2, bl, function2);
    }

    /*
     * Loose catch block
     */
    public static final File copyTo(File object, File file, boolean bl, int n2) {
        Intrinsics.checkNotNullParameter(object, "$this$copyTo");
        Intrinsics.checkNotNullParameter(file, "target");
        if (((File)object).exists()) {
            Object object2;
            if (file.exists()) {
                if (bl) {
                    if (!file.delete()) {
                        throw (Throwable)new FileAlreadyExistsException((File)object, file, "Tried to overwrite the destination, but failed to delete it.");
                    }
                } else {
                    throw (Throwable)new FileAlreadyExistsException((File)object, file, "The destination file already exists.");
                }
            }
            if (((File)object).isDirectory()) {
                if (!file.mkdirs()) {
                    throw (Throwable)new FileSystemException((File)object, file, "Failed to create target directory.");
                }
            } else {
                object2 = file.getParentFile();
                if (object2 != null) {
                    ((File)object2).mkdirs();
                }
                object = new FileInputStream((File)object);
                Throwable throwable = null;
                FileInputStream fileInputStream = (FileInputStream)object;
                object2 = new FileOutputStream(file);
                object2 = (Closeable)object2;
                Throwable throwable2 = null;
                FileOutputStream fileOutputStream = (FileOutputStream)object2;
                ByteStreamsKt.copyTo(fileInputStream, fileOutputStream, n2);
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable2);
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            return file;
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    try {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        try {
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable4);
                            throw throwable5;
                        }
                    }
                }
            }
        }
        throw (Throwable)new NoSuchFileException((File)object, null, "The source file doesn't exist.", 2, null);
    }

    public static /* synthetic */ File copyTo$default(File file, File file2, boolean bl, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            bl = false;
        }
        if ((n3 & 4) != 0) {
            n2 = 8192;
        }
        return FilesKt.copyTo(file, file2, bl, n2);
    }

    @Deprecated(message="Avoid creating temporary directories in the default temp location with this function due to too wide permissions on the newly created directory. Use kotlin.io.path.createTempDirectory instead.")
    public static final File createTempDir(String charSequence, String object, File file) {
        Intrinsics.checkNotNullParameter(charSequence, "prefix");
        object = File.createTempFile((String)charSequence, (String)object, file);
        ((File)object).delete();
        if (((File)object).mkdir()) {
            Intrinsics.checkNotNullExpressionValue(object, "dir");
            return object;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("Unable to create temporary directory ");
        ((StringBuilder)charSequence).append(object);
        ((StringBuilder)charSequence).append('.');
        throw (Throwable)new IOException(((StringBuilder)charSequence).toString());
    }

    public static /* synthetic */ File createTempDir$default(String string2, String string3, File file, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = "tmp";
        }
        if ((n2 & 2) != 0) {
            string3 = null;
        }
        if ((n2 & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempDir(string2, string3, file);
    }

    @Deprecated(message="Avoid creating temporary files in the default temp location with this function due to too wide permissions on the newly created file. Use kotlin.io.path.createTempFile instead or resort to java.io.File.createTempFile.")
    public static final File createTempFile(String object, String string2, File file) {
        Intrinsics.checkNotNullParameter(object, "prefix");
        object = File.createTempFile((String)object, string2, file);
        Intrinsics.checkNotNullExpressionValue(object, "File.createTempFile(prefix, suffix, directory)");
        return object;
    }

    public static /* synthetic */ File createTempFile$default(String string2, String string3, File file, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = "tmp";
        }
        if ((n2 & 2) != 0) {
            string3 = null;
        }
        if ((n2 & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempFile(string2, string3, file);
    }

    public static final boolean deleteRecursively(File file) {
        boolean bl;
        Intrinsics.checkNotNullParameter(file, "$this$deleteRecursively");
        Iterator iterator2 = ((Sequence)FilesKt.walkBottomUp(file)).iterator();
        block0: while (true) {
            bl = true;
            while (iterator2.hasNext()) {
                file = (File)iterator2.next();
                if ((file.delete() || !file.exists()) && bl) continue block0;
                bl = false;
            }
            break;
        }
        return bl;
    }

    public static final boolean endsWith(File file, File file2) {
        Intrinsics.checkNotNullParameter(file, "$this$endsWith");
        Intrinsics.checkNotNullParameter(file2, "other");
        FilePathComponents filePathComponents = FilesKt.toComponents(file);
        FilePathComponents filePathComponents2 = FilesKt.toComponents(file2);
        if (filePathComponents2.isRooted()) {
            return Intrinsics.areEqual(file, file2);
        }
        int n2 = filePathComponents.getSize() - filePathComponents2.getSize();
        boolean bl = n2 < 0 ? false : ((Object)filePathComponents.getSegments().subList(n2, filePathComponents.getSize())).equals(filePathComponents2.getSegments());
        return bl;
    }

    public static final boolean endsWith(File file, String string2) {
        Intrinsics.checkNotNullParameter(file, "$this$endsWith");
        Intrinsics.checkNotNullParameter(string2, "other");
        return FilesKt.endsWith(file, new File(string2));
    }

    public static final String getExtension(File object) {
        Intrinsics.checkNotNullParameter(object, "$this$extension");
        object = ((File)object).getName();
        Intrinsics.checkNotNullExpressionValue(object, "name");
        return StringsKt.substringAfterLast((String)object, (char)'.', (String)"");
    }

    public static final String getInvariantSeparatorsPath(File object) {
        Intrinsics.checkNotNullParameter(object, "$this$invariantSeparatorsPath");
        if (File.separatorChar != '/') {
            object = ((File)object).getPath();
            Intrinsics.checkNotNullExpressionValue(object, "path");
            object = StringsKt.replace$default((String)object, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        } else {
            object = ((File)object).getPath();
            Intrinsics.checkNotNullExpressionValue(object, "path");
        }
        return object;
    }

    public static final String getNameWithoutExtension(File object) {
        Intrinsics.checkNotNullParameter(object, "$this$nameWithoutExtension");
        object = ((File)object).getName();
        Intrinsics.checkNotNullExpressionValue(object, "name");
        return StringsKt.substringBeforeLast$default((String)object, (String)".", null, (int)2, null);
    }

    public static final File normalize(File file) {
        Intrinsics.checkNotNullParameter(file, "$this$normalize");
        Object object = FilesKt.toComponents(file);
        file = object.getRoot();
        Iterable iterable = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(object.getSegments());
        object = File.separator;
        Intrinsics.checkNotNullExpressionValue(object, "File.separator");
        return FilesKt.resolve(file, CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)((CharSequence)object), null, null, (int)0, null, null, (int)62, null));
    }

    private static final List<File> normalize$FilesKt__UtilsKt(List<? extends File> object) {
        List list = new ArrayList(object.size());
        Iterator<? extends File> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            File file = iterator2.next();
            object = file.getName();
            if (object != null) {
                int n2 = ((String)object).hashCode();
                if (n2 != 46) {
                    if (n2 == 1472 && ((String)object).equals("..")) {
                        if (!list.isEmpty() && Intrinsics.areEqual(((File)CollectionsKt.last((List)list)).getName(), "..") ^ true) {
                            list.remove(list.size() - 1);
                            continue;
                        }
                        list.add(file);
                        continue;
                    }
                } else if (((String)object).equals(".")) continue;
            }
            list.add(file);
        }
        return list;
    }

    private static final FilePathComponents normalize$FilesKt__UtilsKt(FilePathComponents filePathComponents) {
        return new FilePathComponents(filePathComponents.getRoot(), FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(filePathComponents.getSegments()));
    }

    public static final File relativeTo(File file, File file2) {
        Intrinsics.checkNotNullParameter(file, "$this$relativeTo");
        Intrinsics.checkNotNullParameter(file2, "base");
        return new File(FilesKt.toRelativeString(file, file2));
    }

    public static final File relativeToOrNull(File object, File file) {
        Intrinsics.checkNotNullParameter(object, "$this$relativeToOrNull");
        Intrinsics.checkNotNullParameter(file, "base");
        object = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt((File)object, file);
        object = object != null ? new File((String)object) : null;
        return object;
    }

    public static final File relativeToOrSelf(File file, File object) {
        Intrinsics.checkNotNullParameter(file, "$this$relativeToOrSelf");
        Intrinsics.checkNotNullParameter(object, "base");
        object = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt(file, (File)object);
        if (object != null) {
            file = new File((String)object);
        }
        return file;
    }

    public static final File resolve(File object, File file) {
        Intrinsics.checkNotNullParameter(object, "$this$resolve");
        Intrinsics.checkNotNullParameter(file, "relative");
        if (FilesKt.isRooted(file)) {
            return file;
        }
        object = ((File)object).toString();
        Intrinsics.checkNotNullExpressionValue(object, "this.toString()");
        CharSequence charSequence = (CharSequence)object;
        boolean bl = charSequence.length() == 0;
        if (!bl && !StringsKt.endsWith$default((CharSequence)charSequence, (char)File.separatorChar, (boolean)false, (int)2, null)) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append(File.separatorChar);
            ((StringBuilder)charSequence).append(file);
            object = new File(((StringBuilder)charSequence).toString());
        } else {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append(file);
            object = new File(((StringBuilder)charSequence).toString());
        }
        return object;
    }

    public static final File resolve(File file, String string2) {
        Intrinsics.checkNotNullParameter(file, "$this$resolve");
        Intrinsics.checkNotNullParameter(string2, "relative");
        return FilesKt.resolve(file, new File(string2));
    }

    public static final File resolveSibling(File file, File file2) {
        Intrinsics.checkNotNullParameter(file, "$this$resolveSibling");
        Intrinsics.checkNotNullParameter(file2, "relative");
        FilePathComponents filePathComponents = FilesKt.toComponents(file);
        file = filePathComponents.getSize() == 0 ? new File("..") : filePathComponents.subPath(0, filePathComponents.getSize() - 1);
        return FilesKt.resolve(FilesKt.resolve(filePathComponents.getRoot(), file), file2);
    }

    public static final File resolveSibling(File file, String string2) {
        Intrinsics.checkNotNullParameter(file, "$this$resolveSibling");
        Intrinsics.checkNotNullParameter(string2, "relative");
        return FilesKt.resolveSibling(file, new File(string2));
    }

    public static final boolean startsWith(File file, File file2) {
        Intrinsics.checkNotNullParameter(file, "$this$startsWith");
        Intrinsics.checkNotNullParameter(file2, "other");
        file = FilesKt.toComponents(file);
        file2 = FilesKt.toComponents(file2);
        boolean bl = Intrinsics.areEqual(file.getRoot(), file2.getRoot());
        boolean bl2 = false;
        if (bl ^ true) {
            return false;
        }
        if (file.getSize() >= file2.getSize()) {
            bl2 = ((Object)file.getSegments().subList(0, file2.getSize())).equals(file2.getSegments());
        }
        return bl2;
    }

    public static final boolean startsWith(File file, String string2) {
        Intrinsics.checkNotNullParameter(file, "$this$startsWith");
        Intrinsics.checkNotNullParameter(string2, "other");
        return FilesKt.startsWith(file, new File(string2));
    }

    public static final String toRelativeString(File file, File file2) {
        Intrinsics.checkNotNullParameter(file, "$this$toRelativeString");
        Intrinsics.checkNotNullParameter(file2, "base");
        CharSequence charSequence = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt(file, file2);
        if (charSequence != null) {
            return charSequence;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("this and base files have different roots: ");
        ((StringBuilder)charSequence).append(file);
        ((StringBuilder)charSequence).append(" and ");
        ((StringBuilder)charSequence).append(file2);
        ((StringBuilder)charSequence).append('.');
        throw (Throwable)new IllegalArgumentException(((StringBuilder)charSequence).toString());
    }

    private static final String toRelativeStringOrNull$FilesKt__UtilsKt(File comparable, File object) {
        int n2;
        Object object2 = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(FilesKt.toComponents((File)comparable));
        object = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(FilesKt.toComponents((File)object));
        if (Intrinsics.areEqual(object2.getRoot(), object.getRoot()) ^ true) {
            return null;
        }
        int n3 = object.getSize();
        int n4 = object2.getSize();
        int n5 = Math.min(n4, n3);
        for (n2 = 0; n2 < n5 && Intrinsics.areEqual((File)object2.getSegments().get(n2), (File)object.getSegments().get(n2)); ++n2) {
        }
        comparable = new StringBuilder();
        n5 = n3 - 1;
        if (n5 >= n2) {
            while (true) {
                if (Intrinsics.areEqual(((File)object.getSegments().get(n5)).getName(), "..")) {
                    return null;
                }
                ((StringBuilder)comparable).append("..");
                if (n5 != n2) {
                    ((StringBuilder)comparable).append(File.separatorChar);
                }
                if (n5 == n2) break;
                --n5;
            }
        }
        if (n2 < n4) {
            if (n2 < n3) {
                ((StringBuilder)comparable).append(File.separatorChar);
            }
            object = CollectionsKt.drop((Iterable)object2.getSegments(), (int)n2);
            object2 = (Appendable)((Object)comparable);
            String string2 = File.separator;
            Intrinsics.checkNotNullExpressionValue(string2, "File.separator");
            CollectionsKt.joinTo$default((Iterable)object, (Appendable)object2, (CharSequence)string2, null, null, (int)0, null, null, (int)124, null);
        }
        return ((StringBuilder)comparable).toString();
    }
}

