/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.webview;

import android.os.Build;
import android.os.ConditionVariable;
import android.os.Looper;
import android.view.View;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebViewClient;
import com.safedk.android.analytics.brandsafety.creatives.CreativeInfoManager;
import com.safedk.android.internal.partials.UnityCoreNetworkBridge;
import com.safedk.android.utils.Logger;
import com.unity3d.services.ads.api.AdUnit;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.InitializeThread;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.misc.ViewUtilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.SDKMetrics;
import com.unity3d.services.core.webview.WebView;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import com.unity3d.services.core.webview.bridge.Invocation;
import com.unity3d.services.core.webview.bridge.NativeCallback;
import com.unity3d.services.core.webview.bridge.WebViewBridge;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;

public class WebViewApp
implements IWebViewBridgeInvoker {
    private static final int INVOKE_JS_CHARS_LENGTH = 22;
    private static ConditionVariable _conditionVariable;
    private static WebViewApp _currentApp;
    private static AtomicReference<Boolean> _initialized;
    private static AtomicReference<Integer> _webAppFailureCode;
    private static AtomicReference<String> _webAppFailureMessage;
    private Configuration _configuration;
    private HashMap<String, NativeCallback> _nativeCallbacks;
    private boolean _webAppLoaded = false;
    private WebView _webView;

    static {
        _initialized = new AtomicReference<Boolean>(false);
        _webAppFailureMessage = new AtomicReference();
        _webAppFailureCode = new AtomicReference();
    }

    public WebViewApp() {
    }

    private WebViewApp(Configuration configuration) {
        this.setConfiguration(configuration);
        WebViewBridge.setClassTable((Class[])this.getConfiguration().getWebAppApiClassList());
        this._webView = new WebView(ClientProperties.getApplicationContext());
        this._webView.setWebViewClient((WebViewClient)new WebAppClient());
        this._webView.setWebChromeClient((WebChromeClient)new WebAppChromeClient());
    }

    public static boolean create(Configuration object) throws IllegalThreadStateException {
        DeviceLog.entered();
        if (!Thread.currentThread().equals(Looper.getMainLooper().getThread())) {
            Utilities.runOnUiThread((Runnable)new Runnable((Configuration)object){
                final /* synthetic */ Configuration val$configuration;
                {
                    this.val$configuration = configuration;
                }

                @Override
                public void run() {
                    CharSequence charSequence;
                    CharSequence charSequence2;
                    WebViewApp webViewApp;
                    try {
                        webViewApp = new WebViewApp(this.val$configuration);
                        charSequence = charSequence2 = "?platform=android";
                    }
                    catch (Exception exception) {
                        DeviceLog.error((String)"Couldn't construct WebViewApp");
                        _conditionVariable.open();
                        return;
                    }
                    try {
                        if (this.val$configuration.getWebViewUrl() != null) {
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append("?platform=android");
                            ((StringBuilder)charSequence).append("&origin=");
                            ((StringBuilder)charSequence).append(URLEncoder.encode(this.val$configuration.getWebViewUrl(), "UTF-8"));
                            charSequence = ((StringBuilder)charSequence).toString();
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        DeviceLog.exception((String)"Unsupported charset when encoding origin url", (Exception)unsupportedEncodingException);
                        charSequence = charSequence2;
                    }
                    charSequence2 = charSequence;
                    try {
                        if (this.val$configuration.getWebViewVersion() != null) {
                            charSequence2 = new StringBuilder();
                            ((StringBuilder)charSequence2).append((String)charSequence);
                            ((StringBuilder)charSequence2).append("&version=");
                            ((StringBuilder)charSequence2).append(URLEncoder.encode(this.val$configuration.getWebViewVersion(), "UTF-8"));
                            charSequence2 = ((StringBuilder)charSequence2).toString();
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        DeviceLog.exception((String)"Unsupported charset when encoding webview version", (Exception)unsupportedEncodingException);
                        charSequence2 = charSequence;
                    }
                    charSequence = webViewApp.getWebView();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("file://");
                    stringBuilder.append(SdkProperties.getLocalWebViewFile());
                    stringBuilder.append((String)charSequence2);
                    UnityCoreNetworkBridge.webviewLoadDataWithBaseURL((android.webkit.WebView)charSequence, stringBuilder.toString(), this.val$configuration.getWebViewData(), "text/html", "UTF-8", null);
                    WebViewApp.setCurrentApp(webViewApp);
                }
            });
            _conditionVariable = new ConditionVariable();
            final boolean bl = _conditionVariable.block(object.getWebViewAppCreateTimeout());
            object = WebViewApp.getCurrentApp();
            boolean bl2 = true;
            final boolean bl3 = object != null;
            final boolean bl4 = bl3 && WebViewApp.getCurrentApp().isWebAppInitialized();
            if (!(bl && bl3 && bl4)) {
                bl2 = false;
            }
            if (!bl2) {
                SDKMetrics.getInstance().sendEventWithTags("native_webview_creation_failed", (Map)new HashMap<String, String>(){
                    {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("");
                        stringBuilder.append(bl ^ true);
                        this.put("wto", stringBuilder.toString());
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("");
                        stringBuilder.append(bl3);
                        this.put("wad", stringBuilder.toString());
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("");
                        stringBuilder.append(bl4);
                        this.put("wai", stringBuilder.toString());
                    }
                });
            }
            return bl2;
        }
        throw new IllegalThreadStateException("Cannot call create() from main thread!");
    }

    public static WebViewApp getCurrentApp() {
        return _currentApp;
    }

    private void invokeJavascriptMethod(String charSequence, String string2, JSONArray object) throws JSONException {
        object = object.toString();
        StringBuilder stringBuilder = new StringBuilder(((String)charSequence).length() + 22 + string2.length() + ((String)object).length());
        stringBuilder.append("javascript:window.");
        stringBuilder.append((String)charSequence);
        stringBuilder.append(".");
        stringBuilder.append(string2);
        stringBuilder.append("(");
        stringBuilder.append((String)object);
        stringBuilder.append(");");
        string2 = stringBuilder.toString();
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("Invoking javascript: ");
        ((StringBuilder)charSequence).append(string2);
        DeviceLog.debug((String)((StringBuilder)charSequence).toString());
        this.getWebView().invokeJavascript(string2);
    }

    public static void setCurrentApp(WebViewApp webViewApp) {
        _currentApp = webViewApp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCallback(NativeCallback nativeCallback) {
        if (this._nativeCallbacks == null) {
            this._nativeCallbacks = new HashMap();
        }
        HashMap<String, NativeCallback> hashMap = this._nativeCallbacks;
        synchronized (hashMap) {
            this._nativeCallbacks.put(nativeCallback.getId(), nativeCallback);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NativeCallback getCallback(String string2) {
        HashMap<String, NativeCallback> hashMap = this._nativeCallbacks;
        synchronized (hashMap) {
            return this._nativeCallbacks.get(string2);
        }
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public int getWebAppFailureCode() {
        return _webAppFailureCode.get();
    }

    public String getWebAppFailureMessage() {
        return _webAppFailureMessage.get();
    }

    public WebView getWebView() {
        return this._webView;
    }

    public boolean invokeCallback(Invocation object) {
        if (!this.isWebAppLoaded()) {
            DeviceLog.debug((String)"invokeBatchCallback ignored because web app is not loaded");
            return false;
        }
        JSONArray jSONArray = new JSONArray();
        if ((object = object.getResponses()) != null && !((ArrayList)object).isEmpty()) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                Object object2 = (Object[])object.next();
                Object object3 = (CallbackStatus)((ArrayList)object2).get(0);
                Enum enum_ = (Enum)((ArrayList)object2).get(1);
                object2 = (Object[])((ArrayList)object2).get(2);
                String string2 = (String)object2[0];
                Object[] objectArray = Arrays.copyOfRange(object2, 1, ((Object[])object2).length);
                object2 = new ArrayList();
                ((ArrayList)object2).add(string2);
                ((ArrayList)object2).add(object3.toString());
                object3 = new JSONArray();
                if (enum_ != null) {
                    object3.put((Object)enum_.name());
                }
                int n2 = objectArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    object3.put(objectArray[i2]);
                }
                ((ArrayList)object2).add(object3);
                enum_ = new JSONArray();
                object3 = ((ArrayList)object2).iterator();
                while (object3.hasNext()) {
                    enum_.put(object3.next());
                }
                jSONArray.put((Object)enum_);
            }
        }
        try {
            this.invokeJavascriptMethod("nativebridge", "handleCallback", jSONArray);
        }
        catch (Exception exception) {
            DeviceLog.exception((String)"Error while invoking batch response for WebView", (Exception)exception);
        }
        return true;
    }

    public boolean invokeMethod(String string2, String string3, Method method, Object ... objectArray) {
        if (!this.isWebAppLoaded()) {
            DeviceLog.debug((String)"invokeMethod ignored because web app is not loaded");
            return false;
        }
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)string2);
        jSONArray.put((Object)string3);
        if (method != null) {
            string2 = new NativeCallback(method);
            this.addCallback((NativeCallback)string2);
            jSONArray.put((Object)string2.getId());
        } else {
            jSONArray.put(null);
        }
        if (objectArray != null) {
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jSONArray.put(objectArray[i2]);
            }
        }
        try {
            this.invokeJavascriptMethod("nativebridge", "handleInvocation", jSONArray);
            return true;
        }
        catch (Exception exception) {
            DeviceLog.exception((String)"Error invoking javascript method", (Exception)exception);
            return false;
        }
    }

    public boolean isWebAppInitialized() {
        return _initialized.get();
    }

    public boolean isWebAppLoaded() {
        return this._webAppLoaded;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeCallback(NativeCallback nativeCallback) {
        HashMap<String, NativeCallback> hashMap = this._nativeCallbacks;
        if (hashMap == null) {
            return;
        }
        synchronized (hashMap) {
            this._nativeCallbacks.remove(nativeCallback.getId());
            return;
        }
    }

    public void resetWebViewAppInitialization() {
        this._webAppLoaded = false;
        _webAppFailureCode.set(-1);
        _webAppFailureMessage.set("");
        _initialized.set(false);
    }

    public boolean sendEvent(Enum enum_, Enum enum_2, Object ... objectArray) {
        if (!this.isWebAppLoaded()) {
            DeviceLog.debug((String)"sendEvent ignored because web app is not loaded");
            return false;
        }
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)enum_.name());
        jSONArray.put((Object)enum_2.name());
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            jSONArray.put(objectArray[i2]);
        }
        try {
            this.invokeJavascriptMethod("nativebridge", "handleEvent", jSONArray);
            return true;
        }
        catch (Exception exception) {
            DeviceLog.exception((String)"Error while sending event to WebView", (Exception)exception);
            return false;
        }
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    public void setWebAppFailureCode(int n2) {
        _webAppFailureCode.set(n2);
    }

    public void setWebAppFailureMessage(String string2) {
        _webAppFailureMessage.set(string2);
    }

    public void setWebAppInitialized(boolean bl) {
        _initialized.set(bl);
        _conditionVariable.open();
    }

    public void setWebAppLoaded(boolean bl) {
        this._webAppLoaded = bl;
    }

    public void setWebView(WebView webView) {
        this._webView = webView;
    }

    private class WebAppChromeClient
    extends WebChromeClient {
        private WebAppChromeClient() {
        }

        public void onConsoleMessage(String string2, int n2, String string3) {
            Comparable<File> comparable;
            try {
                comparable = new Comparable<File>(string3);
            }
            catch (Exception exception) {
                DeviceLog.exception((String)"Could not handle sourceId", (Exception)exception);
                comparable = null;
            }
            if (comparable != null) {
                string3 = ((File)comparable).getName();
            }
            if (Build.VERSION.SDK_INT < 19) {
                comparable = new StringBuilder();
                ((StringBuilder)comparable).append("JavaScript (sourceId=");
                ((StringBuilder)comparable).append(string3);
                ((StringBuilder)comparable).append(", line=");
                ((StringBuilder)comparable).append(n2);
                ((StringBuilder)comparable).append("): ");
                ((StringBuilder)comparable).append(string2);
                DeviceLog.debug((String)((StringBuilder)comparable).toString());
            }
        }
    }

    private class WebAppClient
    extends WebViewClient {
        private WebAppClient() {
        }

        public void onLoadResource(android.webkit.WebView webView, String string2) {
            super.onLoadResource(webView, string2);
            CreativeInfoManager.onResourceLoaded("com.unity3d.services.core", webView, string2);
        }

        public void onPageFinished(android.webkit.WebView webView, String string2) {
            Logger.d("UnityCore|SafeDK: Execution> Lcom/unity3d/services/core/webview/WebViewApp$WebAppClient;->onPageFinished(Landroid/webkit/WebView;Ljava/lang/String;)V");
            CreativeInfoManager.onWebViewPageFinished("com.unity3d.services.core", webView, string2);
            this.safedk_WebViewApp$WebAppClient_onPageFinished_04e34a27a27fb7594f0b675e3426abd6(webView, string2);
        }

        public void onReceivedError(android.webkit.WebView object, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
            super.onReceivedError((android.webkit.WebView)object, webResourceRequest, webResourceError);
            if (object != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("WEBVIEW_ERROR: ");
                stringBuilder.append(object.toString());
                DeviceLog.error((String)stringBuilder.toString());
            }
            if (webResourceRequest != null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("WEBVIEW_ERROR: ");
                ((StringBuilder)object).append(webResourceRequest.toString());
                DeviceLog.error((String)((StringBuilder)object).toString());
            }
            if (webResourceError != null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("WEBVIEW_ERROR: ");
                ((StringBuilder)object).append(webResourceError.toString());
                DeviceLog.error((String)((StringBuilder)object).toString());
            }
        }

        public boolean onRenderProcessGone(android.webkit.WebView object, final RenderProcessGoneDetail renderProcessGoneDetail) {
            Utilities.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (AdUnit.getAdUnitActivity() != null) {
                        AdUnit.getAdUnitActivity().finish();
                    }
                    if (WebViewApp.getCurrentApp() != null && WebViewApp.getCurrentApp().getWebView() != null) {
                        ViewUtilities.removeViewFromParent((View)WebViewApp.getCurrentApp().getWebView());
                    }
                    InitializeThread.reset();
                }
            });
            object = new StringBuilder();
            ((StringBuilder)object).append("UnityAds Sdk WebView onRenderProcessGone : ");
            ((StringBuilder)object).append(renderProcessGoneDetail.toString());
            DeviceLog.error((String)((StringBuilder)object).toString());
            SDKMetrics.getInstance().sendEventWithTags("native_webview_render_process_gone", (Map)new HashMap<String, String>(){
                {
                    if (Build.VERSION.SDK_INT >= 26) {
                        WebAppClient.this = new StringBuilder();
                        ((StringBuilder)WebAppClient.this).append("");
                        ((StringBuilder)WebAppClient.this).append(renderProcessGoneDetail.didCrash());
                        this.put("dc", ((StringBuilder)WebAppClient.this).toString());
                        WebAppClient.this = new StringBuilder();
                        ((StringBuilder)WebAppClient.this).append("");
                        ((StringBuilder)WebAppClient.this).append(renderProcessGoneDetail.rendererPriorityAtExit());
                        this.put("pae", ((StringBuilder)WebAppClient.this).toString());
                    }
                }
            });
            return true;
        }

        public void safedk_WebViewApp$WebAppClient_onPageFinished_04e34a27a27fb7594f0b675e3426abd6(android.webkit.WebView object, String string2) {
            super.onPageFinished((android.webkit.WebView)object, string2);
            object = new StringBuilder();
            ((StringBuilder)object).append("onPageFinished url: ");
            ((StringBuilder)object).append(string2);
            DeviceLog.debug((String)((StringBuilder)object).toString());
        }

        public WebResourceResponse shouldInterceptRequest(android.webkit.WebView webView, WebResourceRequest webResourceRequest) {
            return CreativeInfoManager.onWebViewResponseWithHeaders("com.unity3d.services.core", webView, webResourceRequest, super.shouldInterceptRequest(webView, webResourceRequest));
        }

        public WebResourceResponse shouldInterceptRequest(android.webkit.WebView webView, String string2) {
            return CreativeInfoManager.onWebViewResponse("com.unity3d.services.core", string2, super.shouldInterceptRequest(webView, string2));
        }

        public boolean shouldOverrideUrlLoading(android.webkit.WebView object, String string2) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Trying to load url: ");
            ((StringBuilder)object).append(string2);
            DeviceLog.debug((String)((StringBuilder)object).toString());
            return false;
        }
    }
}

