/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device;

import android.content.Context;
import com.unity3d.services.core.device.Storage;
import com.unity3d.services.core.properties.SdkProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StorageManager {
    private static final Map<StorageType, String> _storageFileMap = Collections.synchronizedMap(new HashMap());
    private static final List<Storage> _storages = Collections.synchronizedList(new ArrayList());

    public static void addStorageLocation(StorageType storageType, String string2) {
        synchronized (StorageManager.class) {
            if (!_storageFileMap.containsKey((Object)storageType)) {
                _storageFileMap.put(storageType, string2);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Storage getStorage(StorageType storageType) {
        List<Storage> list = _storages;
        if (list == null) return null;
        synchronized (list) {
            Storage storage;
            Iterator<Storage> iterator2 = _storages.iterator();
            do {
                if (!iterator2.hasNext()) return null;
            } while (!(storage = iterator2.next()).getType().equals((Object)storageType));
            return storage;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasStorage(StorageType storageType) {
        List<Storage> list = _storages;
        if (list == null) return false;
        synchronized (list) {
            Iterator<Storage> iterator2 = _storages.iterator();
            do {
                if (!iterator2.hasNext()) return false;
            } while (!iterator2.next().getType().equals((Object)storageType));
            return true;
        }
    }

    public static boolean init(Context object) {
        if (object == null) {
            return false;
        }
        if ((object = object.getFilesDir()) == null) {
            return false;
        }
        Object object2 = StorageType.PUBLIC;
        Object object3 = new StringBuilder();
        object3.append(object);
        object3.append("/");
        object3.append(SdkProperties.getLocalStorageFilePrefix());
        object3.append("public-data.json");
        StorageManager.addStorageLocation((StorageType)((Object)object2), object3.toString());
        if (!StorageManager.setupStorage(StorageType.PUBLIC)) {
            return false;
        }
        object3 = StorageType.PRIVATE;
        object2 = new StringBuilder();
        ((StringBuilder)object2).append(object);
        ((StringBuilder)object2).append("/");
        ((StringBuilder)object2).append(SdkProperties.getLocalStorageFilePrefix());
        ((StringBuilder)object2).append("private-data.json");
        StorageManager.addStorageLocation((StorageType)((Object)object3), ((StringBuilder)object2).toString());
        return StorageManager.setupStorage(StorageType.PRIVATE);
    }

    public static void initStorage(StorageType storageType) {
        if (StorageManager.hasStorage(storageType)) {
            if ((storageType = StorageManager.getStorage(storageType)) != null) {
                storageType.initStorage();
            }
        } else if (_storageFileMap.containsKey((Object)storageType)) {
            storageType = new Storage(_storageFileMap.get((Object)storageType), storageType);
            storageType.initStorage();
            _storages.add((Storage)storageType);
        }
    }

    public static void removeStorage(StorageType storageType) {
        synchronized (StorageManager.class) {
            if (StorageManager.getStorage(storageType) != null) {
                _storages.remove(StorageManager.getStorage(storageType));
            }
            if (_storageFileMap != null) {
                _storageFileMap.remove((Object)storageType);
            }
            return;
        }
    }

    private static boolean setupStorage(StorageType storageType) {
        if (!StorageManager.hasStorage(storageType)) {
            StorageManager.initStorage(storageType);
            storageType = StorageManager.getStorage(storageType);
            if (storageType != null && !storageType.storageFileExists()) {
                storageType.writeStorage();
            }
            if (storageType == null) {
                return false;
            }
        }
        return true;
    }

    public static enum StorageType {
        PRIVATE,
        PUBLIC;

    }
}

