/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.unity3d.services.core.log.DeviceLog;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class AdvertisingId {
    private static final String ADVERTISING_ID_SERVICE_NAME = "com.google.android.gms.ads.identifier.internal.IAdvertisingIdService";
    private static AdvertisingId instance;
    private String advertisingIdentifier = null;
    private boolean limitedAdvertisingTracking = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchAdvertisingId(Context context) {
        GoogleAdvertisingServiceConnection googleAdvertisingServiceConnection;
        block8: {
            boolean bl;
            block7: {
                googleAdvertisingServiceConnection = new GoogleAdvertisingServiceConnection();
                Object object = new Intent("com.google.android.gms.ads.identifier.service.START");
                object.setPackage("com.google.android.gms");
                try {
                    bl = context.bindService((Intent)object, (ServiceConnection)googleAdvertisingServiceConnection, 1);
                }
                catch (Exception exception) {
                    DeviceLog.exception((String)"Couldn't bind to identifier service intent", (Exception)exception);
                    return;
                }
                if (bl) {
                    try {
                        try {
                            object = GoogleAdvertisingInfo.GoogleAdvertisingInfoBinder.create(googleAdvertisingServiceConnection.getBinder());
                            this.advertisingIdentifier = object.getId();
                            this.limitedAdvertisingTracking = object.getEnabled(true);
                            break block7;
                        }
                        catch (Exception exception) {
                            DeviceLog.exception((String)"Couldn't get advertising info", (Exception)exception);
                            if (!bl) return;
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {}
                    if (!bl) throw throwable;
                    context.unbindService((ServiceConnection)googleAdvertisingServiceConnection);
                    throw throwable;
                }
            }
            if (!bl) return;
        }
        context.unbindService((ServiceConnection)googleAdvertisingServiceConnection);
    }

    public static String getAdvertisingTrackingId() {
        return AdvertisingId.getInstance().advertisingIdentifier;
    }

    private static AdvertisingId getInstance() {
        if (instance == null) {
            instance = new AdvertisingId();
        }
        return instance;
    }

    public static boolean getLimitedAdTracking() {
        return AdvertisingId.getInstance().limitedAdvertisingTracking;
    }

    public static void init(Context context) {
        AdvertisingId.getInstance().fetchAdvertisingId(context);
    }

    private static interface GoogleAdvertisingInfo
    extends IInterface {
        public boolean getEnabled(boolean var1) throws RemoteException;

        public String getId() throws RemoteException;

        public static abstract class GoogleAdvertisingInfoBinder
        extends Binder
        implements GoogleAdvertisingInfo {
            public static GoogleAdvertisingInfo create(IBinder iBinder) {
                if (iBinder == null) {
                    return null;
                }
                IInterface iInterface = iBinder.queryLocalInterface(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                if (iInterface != null && iInterface instanceof GoogleAdvertisingInfo) {
                    return (GoogleAdvertisingInfo)iInterface;
                }
                return new GoogleAdvertisingInfoImplementation(iBinder);
            }

            public boolean onTransact(int n2, Parcel object, Parcel parcel, int n3) throws RemoteException {
                if (n2 != 1) {
                    if (n2 != 2) {
                        return super.onTransact(n2, object, parcel, n3);
                    }
                    object.enforceInterface(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                    boolean bl = object.readInt() != 0;
                    n2 = this.getEnabled(bl) ? 1 : 0;
                    parcel.writeNoException();
                    parcel.writeInt(n2);
                    return true;
                }
                object.enforceInterface(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                object = this.getId();
                parcel.writeNoException();
                parcel.writeString((String)object);
                return true;
            }

            private static class GoogleAdvertisingInfoImplementation
            implements GoogleAdvertisingInfo {
                private final IBinder _binder;

                GoogleAdvertisingInfoImplementation(IBinder iBinder) {
                    this._binder = iBinder;
                }

                public IBinder asBinder() {
                    return this._binder;
                }

                @Override
                public boolean getEnabled(boolean bl) throws RemoteException {
                    int n2;
                    boolean bl2;
                    Parcel parcel = Parcel.obtain();
                    Parcel parcel2 = Parcel.obtain();
                    try {
                        parcel.writeInterfaceToken(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                        bl2 = true;
                        n2 = bl ? 1 : 0;
                    }
                    catch (Throwable throwable) {
                        parcel2.recycle();
                        parcel.recycle();
                        throw throwable;
                    }
                    parcel.writeInt(n2);
                    this._binder.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                    bl = n2 != 0 ? bl2 : false;
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }

                @Override
                public String getId() throws RemoteException {
                    Parcel parcel = Parcel.obtain();
                    Parcel parcel2 = Parcel.obtain();
                    try {
                        parcel.writeInterfaceToken(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                        this._binder.transact(1, parcel, parcel2, 0);
                        parcel2.readException();
                        String string2 = parcel2.readString();
                        return string2;
                    }
                    finally {
                        parcel2.recycle();
                        parcel.recycle();
                    }
                }
            }
        }
    }

    private class GoogleAdvertisingServiceConnection
    implements ServiceConnection {
        private final BlockingQueue<IBinder> _binderQueue = new LinkedBlockingQueue<IBinder>();
        boolean _consumed = false;

        private GoogleAdvertisingServiceConnection() {
        }

        public IBinder getBinder() throws InterruptedException {
            if (!this._consumed) {
                this._consumed = true;
                return this._binderQueue.take();
            }
            throw new IllegalStateException();
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                this._binderQueue.put(iBinder);
            }
            catch (InterruptedException interruptedException) {
                DeviceLog.debug((String)"Couldn't put service to binder que");
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }
    }
}

